/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.squid;

import org.sonar.java.squid.visitor.SquidVisitor;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;

public class SquidVisitorNotifier {
    private final SourceFile sourceFile;
    private final SquidVisitor[] squidVisitors;

    public SquidVisitorNotifier(SourceFile sourceFile, SquidVisitor ... squidVisitors) {
        this.sourceFile = sourceFile;
        this.squidVisitors = new SquidVisitor[squidVisitors.length];
        System.arraycopy(squidVisitors, 0, this.squidVisitors, 0, squidVisitors.length);
    }

    public void notifyVisitors() {
        this.callVisitFile();
    }

    private void callVisitFile() {
        for (SquidVisitor visitor : this.squidVisitors) {
            visitor.visitFile(this.sourceFile);
        }
        this.visitChildren((SourceCode)this.sourceFile);
    }

    private void visitChildren(SourceCode sourceCode) {
        if (sourceCode instanceof SourceClass) {
            for (SquidVisitor visitor : this.squidVisitors) {
                visitor.visitClass((SourceClass)sourceCode);
            }
        } else if (sourceCode instanceof SourceMethod) {
            for (SquidVisitor visitor : this.squidVisitors) {
                visitor.visitMethod((SourceMethod)sourceCode);
            }
        }
        if (sourceCode.hasChildren()) {
            for (SourceCode child : sourceCode.getChildren()) {
                this.visitChildren(child);
            }
        }
    }
}

