/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class SuppressWarningsAnnotationUtils {
    private static final String SUPPRESS_WARNINGS_ANNOTATION_NAME = "SuppressWarnings";
    private static final String SUPPRESS_WARNINGS_ANNOTATION_FQ_NAME = "java.lang.SuppressWarnings";
    private static final String VALUE = "\"all\"";

    public static boolean isSuppressAllWarnings(DetailAST ast) {
        DetailAST suppressWarningsAnnotation = SuppressWarningsAnnotationUtils.getSuppressWarningsAnnotation(ast);
        if (suppressWarningsAnnotation != null) {
            DetailAST warningHolder = SuppressWarningsAnnotationUtils.findWarningsHolder(suppressWarningsAnnotation);
            for (DetailAST warning = warningHolder.findFirstToken(28); warning != null; warning = warning.getNextSibling()) {
                String text;
                DetailAST fChild;
                if (warning.getType() != 28 || (fChild = warning.getFirstChild()).getType() != 139 || !VALUE.equals(text = warning.getFirstChild().getText())) continue;
                return true;
            }
        }
        return false;
    }

    private static DetailAST findWarningsHolder(DetailAST aAnnotation) {
        DetailAST annValuePair = aAnnotation.findFirstToken(160);
        DetailAST annArrayInit = annValuePair != null ? annValuePair.findFirstToken(162) : aAnnotation.findFirstToken(162);
        if (annArrayInit != null) {
            return annArrayInit;
        }
        return aAnnotation;
    }

    private static DetailAST getSuppressWarningsAnnotation(DetailAST ast) {
        DetailAST annotation = AnnotationUtility.getAnnotation((DetailAST)ast, (String)SUPPRESS_WARNINGS_ANNOTATION_NAME);
        if (annotation == null) {
            annotation = AnnotationUtility.getAnnotation((DetailAST)ast, (String)SUPPRESS_WARNINGS_ANNOTATION_FQ_NAME);
        }
        return annotation;
    }

    private SuppressWarningsAnnotationUtils() {
    }
}

