/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.check.JavaAstCheck;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="AvoidContinueStatement", name="Avoid using 'continue' branching statement", priority=Priority.MAJOR, description="<p>The use of the 'continue' branching statement increase the essential complexity of the source code and so prevent any refactoring of this source code to replace all well structured control structures with a single statement.</p><p>For instance, in the following java program fragment, it's not possible to apply the 'extract method' refactoring pattern :</p><pre>mylabel : for(int i = 0 ; i< 3; i++) {\n  for (int j = 0; j < 4 ; j++) {\n    doSomething();\n    if (checkSomething()) {\n      continue mylabel;\n    }\n  }\n}\n</pre>")
public class ContinueCheck
extends JavaAstCheck {
    private static final List<Integer> wantedTokens = Arrays.asList(87);

    @Override
    public List<Integer> getWantedTokens() {
        return wantedTokens;
    }

    @Override
    public void visitToken(DetailAST ast) {
        SourceCode currentResource = this.peekSourceCode();
        CheckMessage message = new CheckMessage((CodeCheck)this, "The 'continue' branching statement prevent refactoring the source code to reduce the complexity.", new Object[0]);
        message.setLine(ast.getLineNo());
        SourceFile sourceFile = (SourceFile)currentResource.getParent(SourceFile.class);
        sourceFile.log(message);
    }
}

