/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.resources.InputFile;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.java.recognizer.JavaFootprint;
import org.sonar.java.squid.JavaSquidConfiguration;
import org.sonar.squid.recognizer.CodeRecognizer;
import org.sonar.squid.recognizer.LanguageFootprint;
import org.sonar.squid.text.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckstyleSquidBridge
extends Check {
    private static Logger logger = LoggerFactory.getLogger(CheckstyleSquidBridge.class);
    private static JavaAstVisitor[] visitors;
    private static int[] allTokens;
    private static CodeRecognizer codeRecognizer;
    private static Map<File, InputFile> inputFilesByPath;

    static void setASTVisitors(List<JavaAstVisitor> visitors) {
        CheckstyleSquidBridge.visitors = visitors.toArray(new JavaAstVisitor[visitors.size()]);
        TreeSet<Integer> sorter = new TreeSet<Integer>();
        for (JavaAstVisitor visitor : visitors) {
            sorter.addAll(visitor.getWantedTokens());
            allTokens = new int[sorter.size()];
            int i = 0;
            for (Integer itSorted : sorter) {
                CheckstyleSquidBridge.allTokens[i++] = itSorted;
            }
        }
    }

    static void setSquidConfiguration(JavaSquidConfiguration conf) {
        codeRecognizer = new CodeRecognizer(conf.getCommentedCodeThreshold(), (LanguageFootprint)new JavaFootprint());
    }

    public int[] getDefaultTokens() {
        return allTokens;
    }

    public static InputFile getInputFile(File path) {
        return inputFilesByPath.get(path);
    }

    public static void setInputFiles(Collection<InputFile> inputFiles) {
        inputFilesByPath.clear();
        for (InputFile inputFile : inputFiles) {
            inputFilesByPath.put(inputFile.getFile(), inputFile);
        }
    }

    public void beginTree(DetailAST ast) {
        try {
            Source source = this.createSource();
            for (JavaAstVisitor visitor : visitors) {
                visitor.setFileContents(this.getFileContents());
                visitor.setSource(source);
                visitor.setInputFile(CheckstyleSquidBridge.getInputFile(new File(this.getFileContents().getFilename())));
                visitor.visitFile(ast);
            }
        }
        catch (RuntimeException e) {
            this.logAndThrowException(e);
        }
    }

    private Source createSource() {
        return new Source(this.getFileContents().getLines(), codeRecognizer);
    }

    public void visitToken(DetailAST ast) {
        try {
            for (JavaAstVisitor visitor : visitors) {
                if (!visitor.getWantedTokens().contains(ast.getType())) continue;
                visitor.visitToken(ast);
            }
        }
        catch (RuntimeException e) {
            this.logAndThrowException(e);
        }
    }

    public void leaveToken(DetailAST ast) {
        try {
            for (int i = visitors.length - 1; i >= 0; --i) {
                JavaAstVisitor visitor = visitors[i];
                if (!visitor.getWantedTokens().contains(ast.getType())) continue;
                visitor.leaveToken(ast);
            }
        }
        catch (RuntimeException e) {
            this.logAndThrowException(e);
        }
    }

    public void finishTree(DetailAST ast) {
        try {
            for (int i = visitors.length - 1; i >= 0; --i) {
                JavaAstVisitor visitor = visitors[i];
                visitor.leaveFile(ast);
            }
        }
        catch (RuntimeException e) {
            this.logAndThrowException(e);
        }
    }

    private void logAndThrowException(RuntimeException e) {
        logger.error("Squid Error occurs when analysing :" + this.getFileContents().getFilename(), (Throwable)e);
        throw e;
    }

    static {
        inputFilesByPath = Maps.newHashMap();
    }
}

