/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PropertyCacheFile;
import com.puppycrawl.tools.checkstyle.StringArrayReader;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.grammars.GeneratedJavaLexer;
import com.puppycrawl.tools.checkstyle.grammars.GeneratedJavaRecognizer;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeWalker
extends AbstractFileSetCheck {
    private static final int DEFAULT_TAB_WIDTH = 8;
    private final Multimap<String, Check> mTokenToChecks = HashMultimap.create();
    private final Set<Check> mAllChecks = Sets.newHashSet();
    private int mTabWidth = 8;
    private PropertyCacheFile mCache = new PropertyCacheFile(null, null);
    private ClassLoader mClassLoader;
    private Context mChildContext;
    private ModuleFactory mModuleFactory;
    private final boolean mRecursive;
    private static final Log LOG = LogFactory.getLog((String)"com.puppycrawl.tools.checkstyle.TreeWalker");

    public TreeWalker() {
        this.setFileExtensions(new String[]{"java"});
        String recursive = System.getProperty("checkstyle.use.recursive.algorithm", "false");
        this.mRecursive = "true".equals(recursive);
        if (this.mRecursive) {
            LOG.debug((Object)"TreeWalker uses recursive algorithm");
        } else {
            LOG.debug((Object)"TreeWalker uses iterative algorithm");
        }
    }

    public void setTabWidth(int aTabWidth) {
        this.mTabWidth = aTabWidth;
    }

    public void setCacheFile(String aFileName) {
        Configuration configuration = this.getConfiguration();
        this.mCache = new PropertyCacheFile(configuration, aFileName);
    }

    public void setClassLoader(ClassLoader aClassLoader) {
        this.mClassLoader = aClassLoader;
    }

    public void setModuleFactory(ModuleFactory aModuleFactory) {
        this.mModuleFactory = aModuleFactory;
    }

    @Override
    public void finishLocalSetup() {
        DefaultContext checkContext = new DefaultContext();
        checkContext.add("classLoader", this.mClassLoader);
        checkContext.add("messages", this.getMessageCollector());
        checkContext.add("severity", this.getSeverity());
        checkContext.add("tabWidth", String.valueOf(this.mTabWidth));
        this.mChildContext = checkContext;
    }

    @Override
    public void setupChild(Configuration aChildConf) throws CheckstyleException {
        String name = aChildConf.getName();
        Object module = this.mModuleFactory.createModule(name);
        if (!(module instanceof Check)) {
            throw new CheckstyleException("TreeWalker is not allowed as a parent of " + name);
        }
        Check c = (Check)module;
        c.contextualize(this.mChildContext);
        c.configure(aChildConf);
        c.init();
        this.registerCheck(c);
    }

    @Override
    protected void processFiltered(File aFile, List<String> aLines) {
        long timestamp;
        String fileName = aFile.getPath();
        if (this.mCache.alreadyChecked(fileName, timestamp = aFile.lastModified())) {
            return;
        }
        try {
            FileContents contents = new FileContents(fileName, aLines.toArray(new String[aLines.size()]));
            DetailAST rootAST = TreeWalker.parse(contents);
            this.walk(rootAST, contents);
        }
        catch (RecognitionException re) {
            Utils.getExceptionLogger().debug((Object)"RecognitionException occured.", (Throwable)re);
            this.getMessageCollector().add(new LocalizedMessage(re.getLine(), re.getColumn(), "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{re.getMessage()}, this.getId(), this.getClass(), null));
        }
        catch (TokenStreamRecognitionException tre) {
            Utils.getExceptionLogger().debug((Object)"TokenStreamRecognitionException occured.", (Throwable)tre);
            RecognitionException re = tre.recog;
            if (re != null) {
                this.getMessageCollector().add(new LocalizedMessage(re.getLine(), re.getColumn(), "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{re.getMessage()}, this.getId(), this.getClass(), null));
            } else {
                this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{"TokenStreamRecognitionException occured."}, this.getId(), this.getClass(), null));
            }
        }
        catch (TokenStreamException te) {
            Utils.getExceptionLogger().debug((Object)"TokenStreamException occured.", (Throwable)te);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{te.getMessage()}, this.getId(), this.getClass(), null));
        }
        catch (Throwable err) {
            Utils.getExceptionLogger().debug((Object)"Throwable occured.", err);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{"" + err}, this.getId(), this.getClass(), null));
        }
        if (this.getMessageCollector().size() == 0) {
            this.mCache.checkedOk(fileName, timestamp);
        }
    }

    private void registerCheck(Check aCheck) throws CheckstyleException {
        int[] tokens;
        Set<String> checkTokens = aCheck.getTokenNames();
        if (!checkTokens.isEmpty()) {
            tokens = aCheck.getRequiredTokens();
            int[] acceptableTokens = aCheck.getAcceptableTokens();
            Arrays.sort(acceptableTokens);
            for (String token : checkTokens) {
                try {
                    int tokenId = TokenTypes.getTokenId(token);
                    if (Arrays.binarySearch(acceptableTokens, tokenId) < 0) continue;
                    this.registerCheck(token, aCheck);
                }
                catch (IllegalArgumentException ex) {
                    throw new CheckstyleException("illegal token \"" + token + "\" in check " + aCheck, ex);
                }
            }
        } else {
            tokens = aCheck.getDefaultTokens();
        }
        for (int element : tokens) {
            this.registerCheck(element, aCheck);
        }
        this.mAllChecks.add(aCheck);
    }

    private void registerCheck(int aTokenID, Check aCheck) {
        this.registerCheck(TokenTypes.getTokenName(aTokenID), aCheck);
    }

    private void registerCheck(String aToken, Check aCheck) {
        this.mTokenToChecks.put((Object)aToken, (Object)aCheck);
    }

    private void walk(DetailAST aAST, FileContents aContents) {
        this.getMessageCollector().reset();
        this.notifyBegin(aAST, aContents);
        if (aAST != null) {
            if (this.useRecursiveAlgorithm()) {
                this.processRec(aAST);
            } else {
                this.processIter(aAST);
            }
        }
        this.notifyEnd(aAST);
    }

    private void notifyBegin(DetailAST aRootAST, FileContents aContents) {
        for (Check ch : this.mAllChecks) {
            ch.setFileContents(aContents);
            ch.beginTree(aRootAST);
        }
    }

    private void notifyEnd(DetailAST aRootAST) {
        for (Check ch : this.mAllChecks) {
            ch.finishTree(aRootAST);
        }
    }

    private void processRec(DetailAST aAST) {
        if (aAST == null) {
            return;
        }
        this.notifyVisit(aAST);
        DetailAST child = aAST.getFirstChild();
        if (child != null) {
            this.processRec(child);
        }
        this.notifyLeave(aAST);
        DetailAST sibling = aAST.getNextSibling();
        if (sibling != null) {
            this.processRec(sibling);
        }
    }

    private void notifyVisit(DetailAST aAST) {
        Collection visitors = this.mTokenToChecks.get((Object)TokenTypes.getTokenName(aAST.getType()));
        for (Check c : visitors) {
            c.visitToken(aAST);
        }
    }

    private void notifyLeave(DetailAST aAST) {
        Collection visitors = this.mTokenToChecks.get((Object)TokenTypes.getTokenName(aAST.getType()));
        for (Check ch : visitors) {
            ch.leaveToken(aAST);
        }
    }

    public static DetailAST parse(FileContents aContents) throws RecognitionException, TokenStreamException {
        StringArrayReader sar = new StringArrayReader(aContents.getLines());
        GeneratedJavaLexer lexer = new GeneratedJavaLexer(sar);
        lexer.setFilename(aContents.getFilename());
        lexer.setCommentListener(aContents);
        lexer.setTreatAssertAsKeyword(true);
        lexer.setTreatEnumAsKeyword(true);
        GeneratedJavaRecognizer parser = new GeneratedJavaRecognizer(lexer);
        parser.setFilename(aContents.getFilename());
        parser.setASTNodeClass(DetailAST.class.getName());
        parser.compilationUnit();
        return (DetailAST)parser.getAST();
    }

    @Override
    public void destroy() {
        for (Check c : this.mAllChecks) {
            c.destroy();
        }
        this.mCache.destroy();
        super.destroy();
    }

    private boolean useRecursiveAlgorithm() {
        return this.mRecursive;
    }

    private void processIter(DetailAST aRoot) {
        DetailAST curNode = aRoot;
        while (curNode != null) {
            this.notifyVisit(curNode);
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.notifyLeave(curNode);
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }
}

