/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main {
    private static final Options OPTS = new Options();

    public static void main(String[] aArgs) {
        Properties props;
        PosixParser clp = new PosixParser();
        CommandLine line = null;
        try {
            line = clp.parse(OPTS, aArgs);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Main.usage();
        }
        assert (line != null);
        Properties properties = props = line.hasOption("p") ? Main.loadProperties(new File(line.getOptionValue("p"))) : System.getProperties();
        if (!line.hasOption("c")) {
            System.out.println("Must specify a config XML file.");
            Main.usage();
        }
        Configuration config = Main.loadConfig(line, props);
        OutputStream out = null;
        boolean closeOut = false;
        if (line.hasOption("o")) {
            String fname = line.getOptionValue("o");
            try {
                out = new FileOutputStream(fname);
                closeOut = true;
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not find file: '" + fname + "'");
                System.exit(1);
            }
        } else {
            out = System.out;
            closeOut = false;
        }
        AuditListener listener = Main.createListener(line, out, closeOut);
        List<File> files = Main.getFilesToProcess(line);
        Checker c = Main.createChecker(config, listener);
        int numErrs = c.process(files);
        c.destroy();
        System.exit(numErrs);
    }

    private static Checker createChecker(Configuration aConfig, AuditListener aNosy) {
        Checker c = null;
        try {
            c = new Checker();
            ClassLoader moduleClassLoader = Checker.class.getClassLoader();
            c.setModuleClassLoader(moduleClassLoader);
            c.configure(aConfig);
            c.addListener(aNosy);
        }
        catch (Exception e) {
            System.out.println("Unable to create Checker: " + e.getMessage());
            e.printStackTrace(System.out);
            System.exit(1);
        }
        return c;
    }

    private static List<File> getFilesToProcess(CommandLine aLine) {
        String[] remainingArgs;
        LinkedList files = Lists.newLinkedList();
        if (aLine.hasOption("r")) {
            String[] values = aLine.getOptionValues("r");
            for (String element : values) {
                Main.traverse(new File(element), files);
            }
        }
        for (String element : remainingArgs = aLine.getArgs()) {
            files.add(new File(element));
        }
        if (files.isEmpty() && !aLine.hasOption("r")) {
            System.out.println("Must specify files to process");
            Main.usage();
        }
        return files;
    }

    private static AuditListener createListener(CommandLine aLine, OutputStream aOut, boolean aCloseOut) {
        String format = aLine.hasOption("f") ? aLine.getOptionValue("f") : "plain";
        AutomaticBean listener = null;
        if ("xml".equals(format)) {
            listener = new XMLLogger(aOut, aCloseOut);
        } else if ("plain".equals(format)) {
            listener = new DefaultLogger(aOut, aCloseOut);
        } else {
            System.out.println("Invalid format: (" + format + "). Must be 'plain' or 'xml'.");
            Main.usage();
        }
        return listener;
    }

    private static Configuration loadConfig(CommandLine aLine, Properties aProps) {
        try {
            return ConfigurationLoader.loadConfiguration(aLine.getOptionValue("c"), new PropertiesExpander(aProps));
        }
        catch (CheckstyleException e) {
            System.out.println("Error loading configuration file");
            e.printStackTrace(System.out);
            System.exit(1);
            return null;
        }
    }

    private static void usage() {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("java " + Main.class.getName() + " [options] -c <config.xml> file...", OPTS);
        System.exit(1);
    }

    private static void traverse(File aNode, List<File> aFiles) {
        if (aNode.canRead()) {
            if (aNode.isDirectory()) {
                File[] nodes;
                for (File element : nodes = aNode.listFiles()) {
                    Main.traverse(element, aFiles);
                }
            } else if (aNode.isFile()) {
                aFiles.add(aNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File aFile) {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(aFile);
            properties.load(fis);
        }
        catch (IOException ex) {
            try {
                System.out.println("Unable to load properties from file: " + aFile.getAbsolutePath());
                ex.printStackTrace(System.out);
                System.exit(1);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(fis);
                throw throwable;
            }
            Utils.closeQuietly(fis);
        }
        Utils.closeQuietly(fis);
        return properties;
    }

    static {
        OPTS.addOption("c", true, "The check configuration file to use.");
        OPTS.addOption("r", true, "Traverse the directory for source files");
        OPTS.addOption("o", true, "Sets the output file. Defaults to stdout");
        OPTS.addOption("p", true, "Loads the properties file");
        OPTS.addOption("f", true, "Sets the output format. (plain|xml). Defaults to plain");
    }
}

