/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.xml;

import ch.toe.famix.Visitor;
import org.apache.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLIterator {
    private static final Logger LOG = Logger.getLogger(XMLIterator.class);
    private Visitor visitor;
    private boolean inclAttributeName = true;
    private boolean inclValues = false;

    public XMLIterator(boolean inclAttributeName, boolean inclValues) {
        this.inclAttributeName = inclAttributeName;
        this.inclValues = inclValues;
    }

    public void setVisitor(Visitor visitor) {
        this.visitor = visitor;
    }

    public void scanNodes(Node node) {
        switch (node.getNodeType()) {
            case 3: {
                if (this.inclValues) {
                    this.visitor.visit((Object)node);
                    break;
                }
                return;
            }
            case 9: {
                if (node.getChildNodes().getLength() == 1) {
                    node = node.getFirstChild();
                }
            }
            case 1: {
                this.visitor.visit((Object)node);
                if (node.hasAttributes() && this.inclAttributeName) {
                    this.scanAttributes(node);
                }
                NodeList children = node.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child == null) {
                        LOG.debug((Object)("child not found for node: " + node.getNodeName() + "; children = " + children.getLength()));
                    }
                    if (child.getNodeType() == 2) continue;
                    this.scanNodes(child);
                }
                break;
            }
            default: {
                this.visitor.visit((Object)node);
            }
        }
        this.visitor.endVisit(null);
    }

    private void scanAttributes(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            this.visitor.visit((Object)attr);
            this.visitor.endVisit(null);
        }
    }
}

