/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree.visitor.ast;

import org.eclipse.jdt.core.dom.ASTNode;

public class SourceCodeEntity {
    public static final int ARRAY_ACCESS = 2;
    public static final int ARRAY_CREATION = 3;
    public static final int ARRAY_INITIALIZER = 4;
    public static final int ARRAY_TYPE = 5;
    public static final int ASSERT_STATEMENT = 6;
    public static final int ASSIGNMENT = 7;
    public static final int BLOCK = 8;
    public static final int BOOLEAN_LITERAL = 9;
    public static final int BREAK_STATEMENT = 10;
    public static final int CAST_EXPRESSION = 11;
    public static final int CATCH_CLAUSE = 12;
    public static final int CHARACTER_LITERAL = 13;
    public static final int CLASS_INSTANCE_CREATION = 14;
    public static final int COMPILATION_UNIT = 15;
    public static final int CONDITIONAL_EXPRESSION = 16;
    public static final int CONSTRUCTOR_INVOCATION = 17;
    public static final int CONTINUE_STATEMENT = 18;
    public static final int DO_STATEMENT = 19;
    public static final int EMPTY_STATEMENT = 20;
    public static final int EXPRESSION_STATEMENT = 21;
    public static final int FIELD_ACCESS = 22;
    public static final int FIELD_DECLARATION = 23;
    public static final int FOR_STATEMENT = 24;
    public static final int IF_STATEMENT = 25;
    public static final int IMPORT_DECLARATION = 26;
    public static final int INFIX_EXPRESSION = 27;
    public static final int INITIALIZER = 28;
    public static final int JAVADOC = 29;
    public static final int LABELED_STATEMENT = 30;
    public static final int METHOD_DECLARATION = 31;
    public static final int METHOD_INVOCATION = 32;
    public static final int NULL_LITERAL = 33;
    public static final int NUMBER_LITERAL = 34;
    public static final int PACKAGE_DECLARATION = 35;
    public static final int PARENTHESIZED_EXPRESSION = 36;
    public static final int POSTFIX_EXPRESSION = 37;
    public static final int PREFIX_EXPRESSION = 38;
    public static final int PRIMITIVE_TYPE = 39;
    public static final int QUALIFIED_NAME = 40;
    public static final int RETURN_STATEMENT = 41;
    public static final int SIMPLE_NAME = 42;
    public static final int SIMPLE_TYPE = 43;
    public static final int SINGLE_VARIABLE_DECLARATION = 44;
    public static final int STRING_LITERAL = 45;
    public static final int SUPER_CONSTRUCTOR_INVOCATION = 46;
    public static final int SUPER_FIELD_ACCESS = 47;
    public static final int SUPER_METHOD_INVOCATION = 48;
    public static final int SWITCH_CASE = 49;
    public static final int SWITCH_STATEMENT = 50;
    public static final int SYNCHRONIZED_STATEMENT = 51;
    public static final int THIS_EXPRESSION = 52;
    public static final int THROW_STATEMENT = 53;
    public static final int TRY_STATEMENT = 54;
    public static final int TYPE_DECLARATION = 55;
    public static final int TYPE_DECLARATION_STATEMENT = 56;
    public static final int TYPE_LITERAL = 57;
    public static final int VARIABLE_DECLARATION_EXPRESSION = 58;
    public static final int VARIABLE_DECLARATION_FRAGMENT = 59;
    public static final int VARIABLE_DECLARATION_STATEMENT = 60;
    public static final int WHILE_STATEMENT = 61;
    public static final int INSTANCEOF_EXPRESSION = 62;
    public static final int LINE_COMMENT = 63;
    public static final int BLOCK_COMMENT = 64;
    public static final int TAG_ELEMENT = 65;
    public static final int TEXT_ELEMENT = 66;
    public static final int MEMBER_REF = 67;
    public static final int METHOD_REF = 67;
    public static final int METHOD_REF_PARAMETER = 69;
    public static final int ENHANCED_FOR_STATEMENT = 70;
    public static final int ENUM_DECLARATION = 71;
    public static final int ENUM_CONSTANT_DECLARATION = 72;
    public static final int TYPE_PARAMETER = 73;
    public static final int PARAMETERIZED_TYPE = 74;
    public static final int QUALIFIED_TYPE = 75;
    public static final int WILDCARD_TYPE = 76;
    public static final int NORMAL_ANNOTATION = 77;
    public static final int MARKER_ANNOTATION = 78;
    public static final int SINGLE_MEMBER_ANNOTATION = 79;
    public static final int MEMBER_VALUE_PAIR = 80;
    public static final int ANNOTATION_TYPE_DECLARATION = 81;
    public static final int ANNOTATION_TYPE_MEMBER_DECLARATION = 82;
    public static final int MODIFIER = 83;
    public static final int THEN_STATEMENT = 90;
    public static final int ELSE_STATEMENT = 91;
    public static final int ARRAY_DIMENSION = 92;
    public static final int TYPE_ARGUMENTS = 93;
    public static final int ARGUMENTS = 94;
    public static final int BODY = 95;
    public static final int MODIFIERS = 96;
    public static final int SUPER_INTERFACE_TYPES = 97;
    public static final int ENUM_CONSTANTS = 98;
    public static final int BODY_DECLARATIONS = 99;
    public static final int FRAGMENTS = 100;
    public static final int INITIALIZERS = 101;
    public static final int UPDATERS = 102;
    public static final int EXTENDED_OPERANDS = 103;
    public static final int PARAMETERS = 104;
    public static final int CATCH_CLAUSES = 105;
    public static final int FINALLY = 106;
    public static final int THROW = 107;
    public static final int CLASS = 108;
    public static final int METHOD = 109;
    public static final int ATTRIBUTE = 110;
    private Long id;
    private String fName = null;
    private String fUniqueName = null;
    private int fType = -1;
    private int fDepth = 0;

    public SourceCodeEntity() {
    }

    public SourceCodeEntity(String name, int type) {
        this(name, name, type, -1);
    }

    public SourceCodeEntity(String name, int type, int depth) {
        this(name, name, type, depth);
    }

    public SourceCodeEntity(String name, String uniqueName, int type, int depth) {
        this.fName = name;
        this.fUniqueName = uniqueName;
        this.fType = type;
        this.fDepth = depth;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public String getUniqueName() {
        return this.fUniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.fUniqueName = uniqueName;
    }

    public int getType() {
        return this.fType;
    }

    public static String getSourceCodeEntityKeyword(int keyword) {
        switch (keyword) {
            case 90: {
                return "ThenBlock";
            }
            case 91: {
                return "ElseBlock";
            }
            case 92: {
                return "ArrayDimension";
            }
            case 93: {
                return "TypeArguments";
            }
            case 94: {
                return "Arguments";
            }
            case 95: {
                return "Body";
            }
            case 96: {
                return "Modifiers";
            }
            case 97: {
                return "SuperInterfaces";
            }
            case 98: {
                return "EnumConstants";
            }
            case 99: {
                return "BodyDeclarations";
            }
            case 100: {
                return "Fragments";
            }
            case 101: {
                return "Initializers";
            }
            case 102: {
                return "Updaters";
            }
            case 103: {
                return "ExtendedOperands";
            }
            case 104: {
                return "Parameters";
            }
            case 105: {
                return "CatchClauses";
            }
            case 106: {
                return "FinallyBlock";
            }
            case 107: {
                return "Throw";
            }
            case 108: {
                return "Class";
            }
            case 109: {
                return "Method";
            }
            case 110: {
                return "Attribute";
            }
        }
        String type = ASTNode.nodeClassForType((int)keyword).toString();
        return type.substring(type.lastIndexOf(46) + 1);
    }

    public void setType(int type) {
        this.fType = type;
    }

    public int getDepth() {
        return this.fDepth;
    }

    public void setDepth(int depth) {
        this.fDepth = depth;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SourceCodeEntity)) {
            return false;
        }
        SourceCodeEntity o = (SourceCodeEntity)other;
        return o.getType() == this.getType() && o.getUniqueName().equals(this.getUniqueName());
    }
}

