/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree.visitor.ast;

import javax.swing.tree.DefaultMutableTreeNode;
import simpack.util.tree.visitor.ast.SourceCodeEntity;

public class Node
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 42L;
    private boolean fMatched = false;
    private boolean fOrdered = true;
    private int fLabel = -1;
    private String fValue = null;
    private SourceCodeEntity fEntity = null;
    private int fStatementDepth = -1;

    public Node() {
    }

    public Node(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public Node(Object userObject) {
        super(userObject);
    }

    public Node(int label, String value, SourceCodeEntity entity) {
        this.fLabel = label;
        this.fValue = value;
        this.fEntity = entity;
    }

    public void setUnmatched() {
        this.fMatched = false;
    }

    public void setMatched() {
        this.fMatched = true;
    }

    public boolean isMatched() {
        return this.fMatched;
    }

    public void setOutOfOrder() {
        this.fOrdered = false;
    }

    public void setInOrder() {
        this.fOrdered = true;
    }

    public boolean isInOrder() {
        return this.fOrdered;
    }

    public int getLabel() {
        return this.fLabel;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public void setStatementDepth(int depth) {
        this.fStatementDepth = depth;
    }

    public int getStatementDepth() {
        return this.fStatementDepth;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.fLabel) {
            case 25: {
                sb.append(this.controlStructure("if"));
                break;
            }
            case 61: {
                sb.append(this.controlStructure("while"));
                break;
            }
            case 90: {
                sb.append("then");
                break;
            }
            case 91: {
                sb.append("else");
                break;
            }
            case 41: {
                sb.append("return " + this.fValue);
                break;
            }
            default: {
                sb.append(this.fValue);
            }
        }
        return sb.toString();
    }

    private String controlStructure(String keyword) {
        return keyword + " (" + this.fValue + ")";
    }

    public SourceCodeEntity getEntity() {
        return this.fEntity;
    }

    public void setEntity(SourceCodeEntity entity) {
        this.fEntity = entity;
    }
}

