/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree.visitor.ast;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import simpack.util.tree.visitor.ast.Node;
import simpack.util.tree.visitor.ast.SourceCodeEntity;

public class JavaASTStructureTransformer
extends ASTVisitor {
    private int fStructureDepth = 0;
    private int fOverallDepth = 0;
    private Stack<Node> fStack = new Stack();

    public JavaASTStructureTransformer(Node root) {
        this.fStack.clear();
        this.fStack.push(root);
    }

    public int getOverallDepth() {
        return this.fOverallDepth;
    }

    public boolean visit(AssertStatement node) {
        this.pushValuedNode((ASTNode)node, node.getExpression().toString() + ":" + node.getMessage().toString());
        return false;
    }

    public void endVisit(AssertStatement node) {
        this.pop();
    }

    public boolean visit(Block node) {
        return true;
    }

    public void endVisit(Block node) {
    }

    public boolean visit(BreakStatement node) {
        this.pushValuedNode((ASTNode)node, node.getLabel() != null ? node.getLabel().toString() : "");
        return false;
    }

    public void endVisit(BreakStatement node) {
        this.pop();
    }

    public boolean visit(CatchClause node) {
        this.pushValuedNode((ASTNode)node, ((SimpleType)node.getException().getType()).getName().getFullyQualifiedName());
        this.increaseLevel();
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(CatchClause node) {
        --this.fStructureDepth;
        this.pop();
    }

    public boolean visit(ConstructorInvocation node) {
        this.pushValuedNode((ASTNode)node, node.toString());
        return false;
    }

    public void endVisit(ConstructorInvocation node) {
        this.pop();
    }

    public boolean visit(ContinueStatement node) {
        this.pushValuedNode((ASTNode)node, node.getLabel() != null ? node.getLabel().toString() : "");
        return false;
    }

    public void endVisit(ContinueStatement node) {
        this.pop();
    }

    public boolean visit(DoStatement node) {
        this.pushValuedNode((ASTNode)node, node.getExpression().toString());
        this.increaseLevel();
        return true;
    }

    public void endVisit(DoStatement node) {
        --this.fStructureDepth;
        this.pop();
    }

    public boolean visit(EmptyStatement node) {
        this.pushEmptyNode((ASTNode)node);
        return false;
    }

    public void endVisit(EmptyStatement node) {
        this.pop();
    }

    public boolean visit(EnhancedForStatement node) {
        this.pushValuedNode((ASTNode)node, node.getParameter().toString() + ":" + node.getExpression().toString());
        this.increaseLevel();
        return true;
    }

    public void endVisit(EnhancedForStatement node) {
        --this.fStructureDepth;
        this.pop();
    }

    public boolean visit(ExpressionStatement node) {
        this.pushValuedNode((ASTNode)node.getExpression(), node.toString());
        return false;
    }

    public void endVisit(ExpressionStatement node) {
        this.pop();
    }

    public boolean visit(ForStatement node) {
        this.pushValuedNode((ASTNode)node, node.getExpression().toString());
        this.increaseLevel();
        return true;
    }

    public void endVisit(ForStatement node) {
        --this.fStructureDepth;
        this.pop();
    }

    public boolean visit(IfStatement node) {
        String expression = node.getExpression().toString();
        this.push(node.getNodeType(), expression);
        this.increaseLevel();
        if (node.getThenStatement() != null) {
            this.push(90, expression);
            node.getThenStatement().accept((ASTVisitor)this);
            this.pop();
        }
        if (node.getElseStatement() != null) {
            this.push(91, expression);
            node.getElseStatement().accept((ASTVisitor)this);
            this.pop();
        }
        return false;
    }

    public void endVisit(IfStatement node) {
        --this.fStructureDepth;
        this.pop();
    }

    public boolean visit(LabeledStatement node) {
        this.pushValuedNode((ASTNode)node, node.getLabel().getFullyQualifiedName());
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(LabeledStatement node) {
        this.pop();
    }

    public boolean visit(ReturnStatement node) {
        this.pushValuedNode((ASTNode)node, node.getExpression() != null ? node.getExpression().toString() : "");
        return false;
    }

    public void endVisit(ReturnStatement node) {
        this.pop();
    }

    public boolean visit(SuperConstructorInvocation node) {
        this.pushValuedNode((ASTNode)node, node.toString());
        return false;
    }

    public void endVisit(SuperConstructorInvocation node) {
        this.pop();
    }

    public boolean visit(SwitchCase node) {
        this.pushValuedNode((ASTNode)node, node.getExpression() != null ? node.getExpression().toString() : "default");
        return false;
    }

    public void endVisit(SwitchCase node) {
        this.pop();
    }

    public boolean visit(SwitchStatement node) {
        this.pushValuedNode((ASTNode)node, node.getExpression().toString());
        this.increaseLevel();
        this.visitList(node.statements());
        return false;
    }

    public void endVisit(SwitchStatement node) {
        --this.fStructureDepth;
        this.pop();
    }

    public boolean visit(SynchronizedStatement node) {
        this.pushValuedNode((ASTNode)node, node.getExpression().toString());
        return true;
    }

    public void endVisit(SynchronizedStatement node) {
        this.pop();
    }

    public boolean visit(ThrowStatement node) {
        this.pushValuedNode((ASTNode)node, node.getExpression().toString());
        return false;
    }

    public void endVisit(ThrowStatement node) {
        this.pop();
    }

    public boolean visit(TryStatement node) {
        this.pushEmptyNode((ASTNode)node);
        this.pushLabel(95);
        this.increaseLevel();
        node.getBody().accept((ASTVisitor)this);
        this.pop();
        --this.fStructureDepth;
        this.visitList(105, node.catchClauses());
        if (node.getFinally() != null) {
            this.pushLabel(106);
            this.increaseLevel();
            node.getFinally().accept((ASTVisitor)this);
            --this.fStructureDepth;
            this.pop();
        }
        return false;
    }

    public void endVisit(TryStatement node) {
        this.pop();
    }

    public boolean visit(VariableDeclarationStatement node) {
        this.push(node.getNodeType(), node.toString());
        return false;
    }

    public void endVisit(VariableDeclarationStatement node) {
        this.pop();
    }

    public boolean visit(WhileStatement node) {
        this.push(node.getNodeType(), node.getExpression().toString());
        this.increaseLevel();
        return true;
    }

    public void endVisit(WhileStatement node) {
        --this.fStructureDepth;
        this.pop();
    }

    private void visitList(List list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ((ASTNode)it.next()).accept((ASTVisitor)this);
        }
    }

    private void visitList(int parentLabel, List list) {
        if (!list.isEmpty()) {
            this.pushLabel(parentLabel);
            this.visitList(list);
            this.pop();
        }
    }

    private void pushLabel(int label) {
        this.push(label, "");
    }

    private void pushValuedNode(ASTNode node, String value) {
        this.push(node.getNodeType(), value);
    }

    private void pushEmptyNode(ASTNode node) {
        this.push(node.getNodeType(), "");
    }

    private void push(int label, String value) {
        Node n = new Node(label, value.trim(), new SourceCodeEntity(value.trim(), label, this.fStructureDepth));
        n.setStatementDepth(this.fStructureDepth);
        this.getCurrentParent().add(n);
        this.fStack.push(n);
    }

    private void pop() {
        this.fStack.pop();
    }

    private Node getCurrentParent() {
        return this.fStack.peek();
    }

    private void increaseLevel() {
        ++this.fStructureDepth;
        this.fOverallDepth = this.fStructureDepth > this.fOverallDepth ? this.fStructureDepth : this.fOverallDepth;
    }
}

