/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree.visitor.ast;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import simpack.util.tree.visitor.ast.Node;
import simpack.util.tree.visitor.ast.SourceCodeEntity;

public class JavaASTDeclarationTransformer
extends ASTVisitor {
    public static final int IDENTIFIER = 128;
    private Stack<Node> fStack = new Stack();

    public JavaASTDeclarationTransformer(Node root) {
        this.fStack.clear();
        this.fStack.push(root);
    }

    public boolean visit(Block node) {
        return true;
    }

    public void endVisit(Block node) {
    }

    public boolean visit(FieldDeclaration node) {
        this.visitList(96, node.modifiers());
        node.getType().accept((ASTVisitor)this);
        this.visitList(100, node.fragments());
        return false;
    }

    public void endVisit(FieldDeclaration node) {
        this.pop();
    }

    public boolean visit(Javadoc node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(Javadoc node) {
        this.pop();
    }

    public boolean visit(MethodDeclaration node) {
        this.visitList(96, node.modifiers());
        if (node.getReturnType2() != null) {
            node.getReturnType2().accept((ASTVisitor)this);
        }
        this.visitList(93, node.typeParameters());
        this.visitList(104, node.parameters());
        this.visitList(107, node.thrownExceptions());
        return false;
    }

    public void endVisit(MethodDeclaration node) {
        this.pop();
    }

    public boolean visit(Modifier node) {
        this.pushValuedNode((ASTNode)node, node.getKeyword().toString());
        return false;
    }

    public void endVisit(Modifier node) {
        this.pop();
    }

    public boolean visit(ParameterizedType node) {
        this.pushEmptyNode((ASTNode)node);
        node.getType().accept((ASTVisitor)this);
        this.visitList(93, node.typeArguments());
        return false;
    }

    public void endVisit(ParameterizedType node) {
        this.pop();
    }

    public boolean visit(PrimitiveType node) {
        this.pushValuedNode((ASTNode)node, node.getPrimitiveTypeCode().toString());
        return false;
    }

    public void endVisit(PrimitiveType node) {
        this.pop();
    }

    public boolean visit(QualifiedType node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(QualifiedType node) {
        this.pop();
    }

    public boolean visit(SimpleType node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        return false;
    }

    public void endVisit(SimpleType node) {
        this.pop();
    }

    public boolean visit(SingleVariableDeclaration node) {
        boolean isNotParam = this.getCurrentParent().getLabel() != 104;
        this.pushValuedNode((ASTNode)node, node.getName().getIdentifier());
        if (isNotParam) {
            this.visitList(96, node.modifiers());
        }
        node.getType().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(SingleVariableDeclaration node) {
        this.pop();
    }

    public boolean visit(TypeDeclaration node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        this.visitList(96, node.modifiers());
        this.visitList(93, node.typeParameters());
        if (node.getSuperclassType() != null) {
            node.getSuperclassType().accept((ASTVisitor)this);
        }
        this.visitList(97, node.superInterfaceTypes());
        return false;
    }

    public void endVisit(TypeDeclaration node) {
        this.pop();
    }

    public boolean visit(TypeDeclarationStatement node) {
        return true;
    }

    public void endVisit(TypeDeclarationStatement node) {
    }

    public boolean visit(TypeLiteral node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(TypeLiteral node) {
        this.pop();
    }

    public boolean visit(TypeParameter node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        this.visitList(node.typeBounds());
        return false;
    }

    public void endVisit(TypeParameter node) {
        this.pop();
    }

    public boolean visit(VariableDeclarationExpression node) {
        this.pushEmptyNode((ASTNode)node);
        this.visitList(96, node.modifiers());
        node.getType().accept((ASTVisitor)this);
        this.visitList(100, node.fragments());
        return false;
    }

    public void endVisit(VariableDeclarationExpression node) {
        this.pop();
    }

    public boolean visit(VariableDeclarationFragment node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        return false;
    }

    public void endVisit(VariableDeclarationFragment node) {
        this.pop();
    }

    public boolean visit(VariableDeclarationStatement node) {
        this.pushEmptyNode((ASTNode)node);
        this.visitList(96, node.modifiers());
        node.getType().accept((ASTVisitor)this);
        this.visitList(100, node.fragments());
        return false;
    }

    public void endVisit(VariableDeclarationStatement node) {
        this.pop();
    }

    public boolean visit(WildcardType node) {
        String bound = node.isUpperBound() ? "extends" : "super";
        this.pushValuedNode((ASTNode)node, bound);
        return true;
    }

    public void endVisit(WildcardType node) {
        this.pop();
    }

    private void visitList(List list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ((ASTNode)it.next()).accept((ASTVisitor)this);
        }
    }

    private void visitList(int parentLabel, List list) {
        this.pushLabel(parentLabel);
        if (!list.isEmpty()) {
            this.visitList(list);
        }
        this.pop();
    }

    private void pushLabel(int label) {
        this.push(label, "");
    }

    private void pushEmptyNode(ASTNode node) {
        this.push(node.getNodeType(), "");
    }

    private void pushValuedNode(ASTNode node, String value) {
        this.push(node.getNodeType(), value);
    }

    private void push(int label, String value) {
        SourceCodeEntity st = null;
        st = new SourceCodeEntity(value.trim(), label, 0);
        Node n = new Node(label, value.trim(), st);
        this.getCurrentParent().add(n);
        this.fStack.push(n);
    }

    private void pop() {
        this.fStack.pop();
    }

    private Node getCurrentParent() {
        return this.fStack.peek();
    }
}

