/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree.visitor.ast;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import simpack.api.ITreeNode;
import simpack.util.tree.TreeNode;

public class ASTFullTransformer
extends ASTVisitor {
    public static final int THEN_STATEMENT = 90;
    public static final int ELSE_STATEMENT = 91;
    public static final int ARRAY_DIMENSION = 92;
    public static final int TYPE_ARGUMENTS = 93;
    public static final int ARGUMENTS = 94;
    public static final int BODY = 95;
    public static final int MODIFIERS = 96;
    public static final int SUPER_INTERFACE_TYPES = 97;
    public static final int ENUM_CONSTANTS = 98;
    public static final int BODY_DECLARATIONS = 99;
    public static final int FRAGMENTS = 100;
    public static final int INITIALIZERS = 101;
    public static final int UPDATERS = 102;
    public static final int EXTENDED_OPERANDS = 103;
    public static final int PARAMETERS = 104;
    public static final int CATCH_CLAUSES = 105;
    public static final int FINALLY = 106;
    public static final int THROW = 107;
    public static final int IDENTIFIER = 128;
    private Stack<ITreeNode> fStack = new Stack();

    public ASTFullTransformer() {
        this.fStack.clear();
    }

    public ASTFullTransformer(ITreeNode root) {
        this.fStack.clear();
        this.fStack.push(root);
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return false;
    }

    public void endVisit(AnnotationTypeDeclaration node) {
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        return false;
    }

    public void endVisit(AnnotationTypeMemberDeclaration node) {
    }

    public boolean visit(AnonymousClassDeclaration node) {
        this.push(node);
        return true;
    }

    public void endVisit(AnonymousClassDeclaration node) {
        this.pop();
    }

    public boolean visit(ArrayAccess node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(ArrayAccess node) {
        this.pop();
    }

    public boolean visit(ArrayCreation node) {
        this.pushEmptyNode((ASTNode)node);
        node.getType().accept((ASTVisitor)this);
        if (node.dimensions().isEmpty()) {
            node.getInitializer().accept((ASTVisitor)this);
        } else {
            this.visitList(92, node.dimensions());
        }
        return false;
    }

    public void endVisit(ArrayCreation node) {
        this.pop();
    }

    public boolean visit(ArrayInitializer node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(ArrayInitializer node) {
        this.pop();
    }

    public boolean visit(ArrayType node) {
        return true;
    }

    public void endVisit(ArrayType node) {
    }

    public boolean visit(AssertStatement node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(AssertStatement node) {
        this.pop();
    }

    public boolean visit(Assignment node) {
        return false;
    }

    public void endVisit(Assignment node) {
    }

    public boolean visit(Block node) {
        return true;
    }

    public void endVisit(Block node) {
    }

    public boolean visit(BlockComment node) {
        return false;
    }

    public void endVisit(BlockComment node) {
    }

    public boolean visit(BooleanLiteral node) {
        this.pushValuedNode((ASTNode)node, String.valueOf(node.booleanValue()));
        return false;
    }

    public void endVisit(BooleanLiteral node) {
        this.pop();
    }

    public boolean visit(BreakStatement node) {
        String label = node.getLabel() != null ? node.getLabel().toString() : "";
        this.pushValuedNode((ASTNode)node, label);
        return false;
    }

    public void endVisit(BreakStatement node) {
        this.pop();
    }

    public boolean visit(CastExpression node) {
        this.pushEmptyNode((ASTNode)node);
        return false;
    }

    public void endVisit(CastExpression node) {
        this.pop();
    }

    public boolean visit(CatchClause node) {
        SimpleType exception = (SimpleType)node.getException().getType();
        this.pushValuedNode((ASTNode)node, exception.getName().getFullyQualifiedName());
        if (node.getBody() != null) {
            node.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(CatchClause node) {
        this.pop();
    }

    public boolean visit(CharacterLiteral node) {
        this.pushValuedNode((ASTNode)node, String.valueOf(node.charValue()));
        return false;
    }

    public void endVisit(CharacterLiteral node) {
        this.pop();
    }

    public boolean visit(ClassInstanceCreation node) {
        this.pushEmptyNode((ASTNode)node);
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
        }
        this.visitList(93, node.typeArguments());
        node.getType().accept((ASTVisitor)this);
        this.visitList(94, node.arguments());
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(ClassInstanceCreation node) {
        this.pop();
    }

    public boolean visit(CompilationUnit node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(CompilationUnit node) {
        this.pop();
    }

    public boolean visit(ConditionalExpression node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(ConditionalExpression node) {
        this.pop();
    }

    public boolean visit(ConstructorInvocation node) {
        this.pushEmptyNode((ASTNode)node);
        this.visitList(93, node.typeArguments());
        this.visitList(94, node.arguments());
        return false;
    }

    public void endVisit(ConstructorInvocation node) {
        this.pop();
    }

    public boolean visit(ContinueStatement node) {
        String label = node.getLabel() != null ? node.getLabel().toString() : "";
        this.pushValuedNode((ASTNode)node, label);
        return false;
    }

    public void endVisit(ContinueStatement node) {
        this.pop();
    }

    public boolean visit(DoStatement node) {
        this.pushEmptyNode((ASTNode)node);
        node.getExpression().accept((ASTVisitor)this);
        this.pushLabel(95);
        node.getBody().accept((ASTVisitor)this);
        this.pop();
        return false;
    }

    public void endVisit(DoStatement node) {
        this.pop();
    }

    public boolean visit(EmptyStatement node) {
        this.pushEmptyNode((ASTNode)node);
        return false;
    }

    public void endVisit(EmptyStatement node) {
        this.pop();
    }

    public boolean visit(EnhancedForStatement node) {
        this.pushEmptyNode((ASTNode)node);
        node.getParameter().accept((ASTVisitor)this);
        node.getExpression().accept((ASTVisitor)this);
        this.pushLabel(95);
        node.getBody().accept((ASTVisitor)this);
        this.pop();
        return false;
    }

    public void endVisit(EnhancedForStatement node) {
        this.pop();
    }

    public boolean visit(EnumConstantDeclaration node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.visitList(96, node.modifiers());
        this.visitList(94, node.arguments());
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(EnumConstantDeclaration node) {
        this.pop();
    }

    public boolean visit(EnumDeclaration node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.visitList(96, node.modifiers());
        this.visitList(97, node.superInterfaceTypes());
        this.visitList(98, node.enumConstants());
        this.visitList(99, node.bodyDeclarations());
        return false;
    }

    public void endVisit(EnumDeclaration node) {
        this.pop();
    }

    public boolean visit(ExpressionStatement node) {
        return true;
    }

    public void endVisit(ExpressionStatement node) {
    }

    public boolean visit(FieldAccess node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        node.getExpression().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(FieldAccess node) {
        this.pop();
    }

    public boolean visit(FieldDeclaration node) {
        this.pushEmptyNode((ASTNode)node);
        return false;
    }

    public void endVisit(FieldDeclaration node) {
        this.pop();
    }

    public boolean visit(ForStatement node) {
        this.pushEmptyNode((ASTNode)node);
        this.visitList(101, node.initializers());
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
        }
        this.visitList(102, node.updaters());
        this.pushLabel(95);
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(ForStatement node) {
        this.pop();
    }

    public boolean visit(IfStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        if (node.getThenStatement() != null) {
            this.pushLabel(90);
            node.getThenStatement().accept((ASTVisitor)this);
            this.pop();
        }
        if (node.getElseStatement() != null) {
            this.pushLabel(91);
            node.getElseStatement().accept((ASTVisitor)this);
            this.pop();
        }
        return false;
    }

    public void endVisit(IfStatement node) {
        this.pop();
    }

    public boolean visit(ImportDeclaration node) {
        String name = node.getName().getFullyQualifiedName();
        if (node.isOnDemand()) {
            name = name + ".*";
        }
        this.pushValuedNode((ASTNode)node, name);
        return false;
    }

    public void endVisit(ImportDeclaration node) {
        this.pop();
    }

    public boolean visit(InfixExpression node) {
        this.pushValuedNode((ASTNode)node, node.getOperator().toString());
        node.getLeftOperand().accept((ASTVisitor)this);
        node.getRightOperand().accept((ASTVisitor)this);
        this.visitList(103, node.extendedOperands());
        return false;
    }

    public void endVisit(InfixExpression node) {
        this.pop();
    }

    public boolean visit(Initializer node) {
        this.pushEmptyNode((ASTNode)node);
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        if (node.getBody() != null) {
            this.pushLabel(95);
            node.getBody().accept((ASTVisitor)this);
            this.pop();
        }
        return false;
    }

    public void endVisit(Initializer node) {
        this.pop();
    }

    public boolean visit(InstanceofExpression node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(InstanceofExpression node) {
        this.pop();
    }

    public boolean visit(Javadoc node) {
        return false;
    }

    public void endVisit(Javadoc node) {
    }

    public boolean visit(LabeledStatement node) {
        this.pushValuedNode((ASTNode)node, node.getLabel().getFullyQualifiedName());
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(LabeledStatement node) {
        this.pop();
    }

    public boolean visit(LineComment node) {
        return false;
    }

    public void endVisit(LineComment node) {
    }

    public boolean visit(MarkerAnnotation node) {
        return false;
    }

    public void endVisit(MarkerAnnotation node) {
    }

    public boolean visit(MemberRef node) {
        return false;
    }

    public void endVisit(MemberRef node) {
    }

    public boolean visit(MemberValuePair node) {
        return false;
    }

    public void endVisit(MemberValuePair node) {
    }

    public boolean visit(MethodDeclaration node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        if (node.getReturnType2() != null) {
            node.getReturnType2().accept((ASTVisitor)this);
        }
        this.visitList(93, node.typeParameters());
        this.visitList(104, node.parameters());
        if (node.getBody() != null) {
            node.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(MethodDeclaration node) {
        this.pop();
    }

    public boolean visit(MethodInvocation node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
        }
        this.visitList(93, node.typeArguments());
        this.visitList(94, node.arguments());
        return false;
    }

    public void endVisit(MethodInvocation node) {
        this.pop();
    }

    public boolean visit(MethodRef node) {
        return false;
    }

    public void endVisit(MethodRef node) {
    }

    public boolean visit(MethodRefParameter node) {
        return false;
    }

    public void endVisit(MethodRefParameter node) {
    }

    public boolean visit(Modifier node) {
        return false;
    }

    public void endVisit(Modifier node) {
    }

    public boolean visit(NormalAnnotation node) {
        return false;
    }

    public void endVisit(NormalAnnotation node) {
    }

    public boolean visit(NullLiteral node) {
        return false;
    }

    public void endVisit(NullLiteral node) {
    }

    public boolean visit(NumberLiteral node) {
        return false;
    }

    public void endVisit(NumberLiteral node) {
    }

    public boolean visit(PackageDeclaration node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(PackageDeclaration node) {
        this.pop();
    }

    public boolean visit(ParameterizedType node) {
        this.pushEmptyNode((ASTNode)node);
        node.getType().accept((ASTVisitor)this);
        this.visitList(93, node.typeArguments());
        return false;
    }

    public void endVisit(ParameterizedType node) {
        this.pop();
    }

    public boolean visit(ParenthesizedExpression node) {
        return true;
    }

    public void endVisit(ParenthesizedExpression node) {
    }

    public boolean visit(PostfixExpression node) {
        this.pushValuedNode((ASTNode)node, node.getOperator().toString());
        return true;
    }

    public void endVisit(PostfixExpression node) {
        this.pop();
    }

    public boolean visit(PrefixExpression node) {
        this.pushValuedNode((ASTNode)node, node.getOperator().toString());
        return true;
    }

    public void endVisit(PrefixExpression node) {
        this.pop();
    }

    public boolean visit(PrimitiveType node) {
        this.pushValuedNode((ASTNode)node, node.getPrimitiveTypeCode().toString());
        return false;
    }

    public void endVisit(PrimitiveType node) {
        this.pop();
    }

    public boolean visit(QualifiedName node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(QualifiedName node) {
        this.pop();
    }

    public boolean visit(QualifiedType node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(QualifiedType node) {
        this.pop();
    }

    public boolean visit(ReturnStatement node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(ReturnStatement node) {
        this.pop();
    }

    public boolean visit(SimpleName node) {
        this.pushValuedNode((ASTNode)node, node.getIdentifier());
        return false;
    }

    public void endVisit(SimpleName node) {
        this.pop();
    }

    public boolean visit(SimpleType node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        return false;
    }

    public void endVisit(SimpleType node) {
        this.pop();
    }

    public boolean visit(SingleMemberAnnotation node) {
        return false;
    }

    public void endVisit(SingleMemberAnnotation node) {
        this.pop();
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.pushValuedNode((ASTNode)node, node.getName().getIdentifier());
        this.visitList(96, node.modifiers());
        node.getType().accept((ASTVisitor)this);
        if (node.getInitializer() != null) {
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(SingleVariableDeclaration node) {
        this.pop();
    }

    public boolean visit(StringLiteral node) {
        this.pushValuedNode((ASTNode)node, node.getLiteralValue());
        return false;
    }

    public void endVisit(StringLiteral node) {
        this.pop();
    }

    public boolean visit(SuperConstructorInvocation node) {
        this.pushEmptyNode((ASTNode)node);
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
        }
        this.visitList(93, node.typeArguments());
        this.visitList(94, node.arguments());
        return false;
    }

    public void endVisit(SuperConstructorInvocation node) {
        this.pop();
    }

    public boolean visit(SuperFieldAccess node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        node.getQualifier().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(SuperFieldAccess node) {
        this.pop();
    }

    public boolean visit(SuperMethodInvocation node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        node.getQualifier().accept((ASTVisitor)this);
        this.visitList(93, node.typeArguments());
        this.visitList(94, node.arguments());
        return false;
    }

    public void endVisit(SuperMethodInvocation node) {
        this.pop();
    }

    public boolean visit(SwitchCase node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(SwitchCase node) {
        this.pop();
    }

    public boolean visit(SwitchStatement node) {
        this.pushEmptyNode((ASTNode)node);
        node.getExpression().accept((ASTVisitor)this);
        this.visitList(95, node.statements());
        return false;
    }

    public void endVisit(SwitchStatement node) {
        this.pop();
    }

    public boolean visit(SynchronizedStatement node) {
        this.pushEmptyNode((ASTNode)node);
        node.getExpression().accept((ASTVisitor)this);
        this.pushLabel(95);
        node.getBody().accept((ASTVisitor)this);
        this.pop();
        return false;
    }

    public void endVisit(SynchronizedStatement node) {
        this.pop();
    }

    public boolean visit(TagElement node) {
        return false;
    }

    public void endVisit(TagElement node) {
    }

    public boolean visit(TextElement node) {
        this.pushValuedNode((ASTNode)node, node.getText());
        return false;
    }

    public void endVisit(TextElement node) {
        this.pop();
    }

    public boolean visit(ThisExpression node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(ThisExpression node) {
        this.pop();
    }

    public boolean visit(ThrowStatement node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(ThrowStatement node) {
        this.pop();
    }

    public boolean visit(TryStatement node) {
        this.pushEmptyNode((ASTNode)node);
        this.pushLabel(95);
        node.getBody().accept((ASTVisitor)this);
        this.pop();
        this.visitList(105, node.catchClauses());
        this.pushLabel(106);
        node.getFinally();
        this.pop();
        return false;
    }

    public void endVisit(TryStatement node) {
        this.pop();
    }

    public boolean visit(TypeDeclaration node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.visitList(96, node.modifiers());
        this.visitList(93, node.typeParameters());
        if (node.getSuperclassType() != null) {
            node.getSuperclassType().accept((ASTVisitor)this);
        }
        this.visitList(97, node.superInterfaceTypes());
        this.visitList(99, node.bodyDeclarations());
        return false;
    }

    public void endVisit(TypeDeclaration node) {
        this.pop();
    }

    public boolean visit(TypeDeclarationStatement node) {
        return true;
    }

    public void endVisit(TypeDeclarationStatement node) {
    }

    public boolean visit(TypeLiteral node) {
        this.pushEmptyNode((ASTNode)node);
        return true;
    }

    public void endVisit(TypeLiteral node) {
        this.pop();
    }

    public boolean visit(TypeParameter node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        this.visitList(node.typeBounds());
        return false;
    }

    public void endVisit(TypeParameter node) {
        this.pop();
    }

    public boolean visit(VariableDeclarationExpression node) {
        this.pushEmptyNode((ASTNode)node);
        this.visitList(96, node.modifiers());
        node.getType().accept((ASTVisitor)this);
        this.visitList(100, node.fragments());
        return false;
    }

    public void endVisit(VariableDeclarationExpression node) {
        this.pop();
    }

    public boolean visit(VariableDeclarationFragment node) {
        this.pushValuedNode((ASTNode)node, node.getName().getFullyQualifiedName());
        if (node.getInitializer() != null) {
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(VariableDeclarationFragment node) {
        this.pop();
    }

    public boolean visit(VariableDeclarationStatement node) {
        this.pushEmptyNode((ASTNode)node);
        this.visitList(96, node.modifiers());
        node.getType().accept((ASTVisitor)this);
        this.visitList(100, node.fragments());
        return false;
    }

    public void endVisit(VariableDeclarationStatement node) {
        this.pop();
    }

    public boolean visit(WhileStatement node) {
        this.pushEmptyNode((ASTNode)node);
        node.getExpression().accept((ASTVisitor)this);
        this.pushLabel(95);
        node.getBody().accept((ASTVisitor)this);
        this.pop();
        return false;
    }

    public void endVisit(WhileStatement node) {
        this.pop();
    }

    public boolean visit(WildcardType node) {
        String bound = node.isUpperBound() ? "extends" : "super";
        this.pushValuedNode((ASTNode)node, bound);
        return true;
    }

    public void endVisit(WildcardType node) {
        this.pop();
    }

    private void visitList(List list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ((ASTNode)it.next()).accept((ASTVisitor)this);
        }
    }

    private void visitList(int parentLabel, List list) {
        this.pushLabel(parentLabel);
        if (!list.isEmpty()) {
            this.visitList(list);
        }
        this.pop();
    }

    private void pushLabel(int label) {
        this.push(new Integer(label));
    }

    private void pushEmptyNode(ASTNode node) {
        this.push(node);
    }

    private void pushValuedNode(ASTNode node, String value) {
        this.push(node);
    }

    private void push(Object node) {
        TreeNode n = new TreeNode(node);
        if (!this.fStack.isEmpty()) {
            this.getCurrentParent().add(n);
        }
        this.fStack.push(n);
    }

    private void pop() {
        this.fStack.pop();
    }

    private ITreeNode getCurrentParent() {
        return this.fStack.peek();
    }
}

