/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree.visitor;

import java.util.Map;
import java.util.Stack;
import simpack.api.ITreeNode;
import simpack.util.tree.TreeNode;
import simpack.util.tree.visitor.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTreeVisitor
extends TreeVisitor {
    private Map<TreeNode, TreeNode> mapped;
    private ITreeNode tree;
    private ITreeNode mappedTree;
    private Stack<ITreeNode> currentParent = new Stack();
    private Stack<ITreeNode> currentParentMapped = new Stack();

    public BuildTreeVisitor(Map<TreeNode, TreeNode> mapped, ITreeNode root) {
        super(root);
        this.mapped = mapped;
        this.accept(root);
    }

    @Override
    public boolean visit(ITreeNode node) {
        if (!this.mapped.containsKey(node)) {
            return false;
        }
        ITreeNode clone = (ITreeNode)node.clone();
        if (node.equals(this.root)) {
            this.tree = clone;
            this.mappedTree = this.mapped.get(node);
            this.currentParent.push(clone);
            this.currentParentMapped.push(this.mappedTree);
        } else {
            this.currentParent.peek().add(clone);
            this.currentParent.push(clone);
            this.currentParentMapped.peek().add(this.mapped.get(node));
            this.currentParentMapped.push(this.mapped.get(node));
        }
        return true;
    }

    @Override
    public void postVisit(ITreeNode node) {
        this.currentParent.pop();
        this.currentParentMapped.pop();
    }

    public ITreeNode getTree() {
        return this.tree;
    }

    public ITreeNode getMappedTree() {
        return this.mappedTree;
    }
}

