/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import simpack.api.ITreeNode;
import simpack.exception.InvalidElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeUtil {
    public static int calculateSize(ITreeNode tree) {
        int size = 1;
        Enumeration<? extends TreeNode> enumer = tree.children();
        while (enumer.hasMoreElements()) {
            ITreeNode child = (ITreeNode)enumer.nextElement();
            size += TreeUtil.calculateSize(child);
        }
        return size;
    }

    public static List<ITreeNode> enumerationToList(Enumeration enumeration) throws InvalidElementException {
        LinkedList<ITreeNode> ret = new LinkedList<ITreeNode>();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (o instanceof ITreeNode) {
                ret.add((ITreeNode)o);
                continue;
            }
            throw new InvalidElementException("Unexpected child type in Tree while converting enumeration.");
        }
        return ret;
    }

    public static Double getSimilarity4to1(ITreeNode completeSearchObject, ITreeNode completeMatchedObject, ITreeNode matchedObject) {
        Double completeMatchedObjectSize = new Double(TreeUtil.calculateSize(completeMatchedObject));
        Double completeSearchObjectSize = new Double(TreeUtil.calculateSize(completeSearchObject));
        Double matchedObjectSize = new Double(TreeUtil.calculateSize(matchedObject));
        if (completeMatchedObjectSize == 0.0 || completeSearchObjectSize == 0.0) {
            return 0.0;
        }
        return (4.0 * (matchedObjectSize / completeSearchObjectSize) + matchedObjectSize / completeMatchedObjectSize) / 5.0;
    }

    public static Double getSimilarity1to1(ITreeNode completeSearchObject, ITreeNode completeMatchedObject, ITreeNode matchedObject) {
        Double completeMatchedObjectSize = new Double(TreeUtil.calculateSize(completeMatchedObject));
        Double completeSearchObjectSize = new Double(TreeUtil.calculateSize(completeSearchObject));
        Double matchedObjectSize = new Double(TreeUtil.calculateSize(matchedObject));
        if (completeMatchedObjectSize == 0.0 || completeSearchObjectSize == 0.0) {
            return 0.0;
        }
        return 2.0 * matchedObjectSize / (completeSearchObjectSize + completeMatchedObjectSize);
    }

    public static Double getSimilarityMatchedWeightened(ITreeNode completeSearchObject, ITreeNode completeMatchedObject, ITreeNode matchedObject) {
        Double completeMatchedObjectSize = new Double(TreeUtil.calculateSize(completeMatchedObject));
        Double completeSearchObjectSize = new Double(TreeUtil.calculateSize(completeSearchObject));
        Double matchedObjectSize = new Double(TreeUtil.calculateSize(matchedObject));
        Double percentMatchedSearchObject = matchedObjectSize / completeSearchObjectSize;
        Double percentMatchedObject = matchedObjectSize / completeMatchedObjectSize;
        if (percentMatchedObject > 0.8) {
            return (2.0 * percentMatchedSearchObject + percentMatchedObject) / 3.0;
        }
        if (percentMatchedObject < 0.2) {
            return (percentMatchedSearchObject + 2.0 * percentMatchedObject) / 3.0;
        }
        return (percentMatchedSearchObject + percentMatchedObject) / 2.0;
    }
}

