/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.tree.TreeNode;
import simpack.api.ITreeNode;
import simpack.api.impl.Calculator;
import simpack.exception.InvalidElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquivalenceClassCalculator
extends Calculator {
    private ITreeNode tree1;
    private List<ITreeNode> list1 = null;
    private ITreeNode tree2;
    private List<ITreeNode> list2 = null;
    private boolean ordered;
    private boolean labeled;
    private LinkedHashMap<LinkedList<Integer>, Integer> globalCodes = new LinkedHashMap();
    private int currentMaxEquivalence = 1;
    private LinkedHashMap<ITreeNode, Integer> code1 = new LinkedHashMap();
    private LinkedHashMap<ITreeNode, Integer> code2 = new LinkedHashMap();

    public EquivalenceClassCalculator(ITreeNode tree1, List<ITreeNode> list1, ITreeNode tree2, List<ITreeNode> list2) throws NullPointerException, InvalidElementException {
        this(tree1, list1, tree2, list2, false, false);
    }

    public EquivalenceClassCalculator(ITreeNode tree1, List<ITreeNode> list1, ITreeNode tree2, List<ITreeNode> list2, boolean ordered) throws NullPointerException, InvalidElementException {
        this(tree1, list1, tree2, list2, ordered, false);
    }

    public EquivalenceClassCalculator(ITreeNode tree1, List<ITreeNode> list1, ITreeNode tree2, List<ITreeNode> list2, boolean ordered, boolean labeled) throws NullPointerException, InvalidElementException {
        if (tree1 == null || tree2 == null || list1 == null || list2 == null) {
            throw new NullPointerException();
        }
        this.ordered = ordered;
        this.labeled = labeled;
        this.tree1 = tree1;
        this.list1 = list1;
        this.tree2 = tree2;
        this.list2 = list2;
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        try {
            this.calculateEquivalenceClass(this.list1, this.code1);
            this.calculateEquivalenceClass(this.list2, this.code2);
        }
        catch (InvalidElementException e) {
            return false;
        }
        this.setCalculated(true);
        return true;
    }

    private void calculateEquivalenceClass(List<ITreeNode> list, LinkedHashMap<ITreeNode, Integer> code) throws InvalidElementException {
        ListIterator<ITreeNode> iter = list.listIterator();
        while (iter.hasNext()) {
            ITreeNode node = iter.next();
            if (node.isLeaf()) {
                code.put(node, 1);
                continue;
            }
            LinkedList<Integer> childCodeList = new LinkedList<Integer>();
            Enumeration<? extends TreeNode> enumer = node.children();
            while (enumer.hasMoreElements()) {
                TreeNode o = enumer.nextElement();
                if (o instanceof ITreeNode) {
                    ITreeNode child = (ITreeNode)o;
                    childCodeList.add(code.get(child));
                    continue;
                }
                throw new InvalidElementException("Unexpected child type in Tree while calculating child codes.");
            }
            if (!this.ordered) {
                Collections.sort(childCodeList);
            }
            if (this.labeled) {
                // empty if block
            }
            if (this.globalCodes.containsKey(childCodeList)) {
                code.put(node, this.globalCodes.get(childCodeList));
                continue;
            }
            this.globalCodes.put(childCodeList, ++this.currentMaxEquivalence);
            code.put(node, this.currentMaxEquivalence);
        }
    }

    public LinkedHashMap<ITreeNode, Integer> getEquivalenceClassesTree1() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.code1;
    }

    public LinkedHashMap<ITreeNode, Integer> getEquivalenceClassesTree2() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.code2;
    }

    public ITreeNode getTree1() {
        return this.tree1;
    }

    public ITreeNode getTree2() {
        return this.tree2;
    }
}

