/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.matrix;

import cern.colt.matrix.DoubleMatrix2D;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;

public class ReadAndWriteMatrix {
    static Logger logger = Logger.getLogger(ReadAndWriteMatrix.class);
    private long before;
    private long after;

    public DoubleMatrix2D read(String filename) {
        logger.debug((Object)("Reading " + filename));
        this.before = System.currentTimeMillis();
        DoubleMatrix2D tmp = null;
        try {
            FileInputStream istream = new FileInputStream(filename);
            ObjectInputStream ois = new ObjectInputStream(istream);
            tmp = (DoubleMatrix2D)ois.readObject();
            ois.close();
            istream.close();
            this.after = System.currentTimeMillis();
            logger.debug((Object)("Matrix read in " + (this.after - this.before) / 1000L + " seconds.\n"));
        }
        catch (IOException e) {
            System.out.println("Error while trying to read in " + filename);
            System.out.println(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            System.out.println("Error while trying to read in " + filename);
            System.out.println(e.getMessage());
        }
        return tmp;
    }

    public void write(DoubleMatrix2D matrix, String filename) {
        logger.debug((Object)("Writing into " + filename));
        this.before = System.currentTimeMillis();
        try {
            FileOutputStream ostream = new FileOutputStream(filename);
            ObjectOutputStream oos = new ObjectOutputStream(ostream);
            oos.writeObject(matrix);
            oos.flush();
            ostream.close();
        }
        catch (IOException e) {
            System.out.println("Error while trying to write in " + filename);
            System.out.println(e.getMessage());
        }
        this.after = System.currentTimeMillis();
        logger.debug((Object)("matrix written in " + filename + " in " + (this.after - this.before) / 1000L + " seconds.\n"));
    }
}

