/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.matrix;

import java.io.Serializable;
import simpack.util.matrix.OptimizedMatrix1D;

public class OptimizedMatrix2D
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final OptimizedMatrix1D[] rows;
    private final OptimizedMatrix1D[] cols;
    private final int countRows;
    private final int countCols;

    public OptimizedMatrix2D(int rows, int cols) {
        OptimizedMatrix1D matrix1D;
        this.rows = new OptimizedMatrix1D[rows];
        this.cols = new OptimizedMatrix1D[cols];
        for (int i = 0; i < rows; ++i) {
            this.rows[i] = matrix1D = new OptimizedMatrix1D(cols);
        }
        for (int j = 0; j < cols; ++j) {
            this.cols[j] = matrix1D = new OptimizedMatrix1D(rows);
        }
        this.countRows = rows;
        this.countCols = cols;
    }

    public void setQuick(int row, int column, double value) {
        OptimizedMatrix1D matrixCol = this.cols[column];
        matrixCol.setQuick(row, value);
        OptimizedMatrix1D matrixRow = this.rows[row];
        matrixRow.setQuick(column, value);
    }

    public double getQuick(int row, int column) {
        OptimizedMatrix1D matrixRow = this.rows[row];
        return matrixRow.getQuick(column);
    }

    public int rows() {
        return this.countRows;
    }

    public int columns() {
        return this.countCols;
    }

    public OptimizedMatrix1D viewColumn(int column) {
        return this.cols[column];
    }

    public OptimizedMatrix1D viewRow(int row) {
        return this.rows[row];
    }

    public void trim() {
        int i;
        for (i = 0; i < this.countRows; ++i) {
            this.rows[i].trim();
        }
        for (i = 0; i < this.countCols; ++i) {
            this.cols[i].trim();
        }
    }
}

