/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.matrix;

import java.io.Serializable;
import java.util.Arrays;

public class OptimizedMatrix1D
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int size;
    private int[] positions;
    private double[] values;
    private final int upperDelimiter;
    private int realSize = 0;

    public OptimizedMatrix1D(int size) {
        this.size = size;
        this.upperDelimiter = size;
        this.positions = new int[4];
        this.values = new double[4];
        Arrays.fill(this.positions, this.upperDelimiter);
    }

    public OptimizedMatrix1D(int[] pos, double[] val, int sizeMatrix, int sizeNonZeros) {
        this.positions = pos;
        this.values = val;
        this.size = sizeMatrix;
        this.upperDelimiter = sizeMatrix;
        this.realSize = sizeNonZeros;
    }

    public int size() {
        return this.size;
    }

    private void moveOneBack(int fromIndex) {
        System.arraycopy(this.positions, fromIndex, this.positions, fromIndex + 1, this.realSize - fromIndex);
        System.arraycopy(this.values, fromIndex, this.values, fromIndex + 1, this.realSize - fromIndex);
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.positions.length) {
            int[] temp = new int[this.positions.length * 3 / 2 + 1];
            double[] tempDouble = new double[this.positions.length * 3 / 2 + 1];
            Arrays.fill(temp, this.upperDelimiter);
            System.arraycopy(this.positions, 0, temp, 0, this.positions.length);
            System.arraycopy(this.values, 0, tempDouble, 0, this.values.length);
            this.positions = temp;
            this.values = tempDouble;
        }
    }

    public void setQuick(int i, double val) {
        this.ensureCapacity(this.realSize + 1);
        if (this.realSize > 0 && i > this.positions[this.realSize - 1]) {
            this.positions[this.realSize] = i;
            this.values[this.realSize] = val;
            ++this.realSize;
            return;
        }
        this.insertValueAtPos(i, val);
    }

    private void insertValueAtPos(int i, double val) {
        int insertPos = -1;
        int low = 0;
        int high = this.realSize - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >> 1;
            int midVal = this.positions[mid];
            if (midVal < i) {
                low = mid + 1;
                continue;
            }
            if (midVal > i) {
                high = mid - 1;
                continue;
            }
            this.values[mid] = val;
            return;
        }
        insertPos = i < this.positions[mid] ? mid : mid + 1;
        if (this.positions[insertPos] != this.upperDelimiter) {
            this.moveOneBack(insertPos);
        }
        this.positions[insertPos] = i;
        this.values[insertPos] = val;
        ++this.realSize;
    }

    public double getQuick(int i) {
        int index = Arrays.binarySearch(this.positions, i);
        if (index < 0) {
            return 0.0;
        }
        return this.values[index];
    }

    public OptimizedMatrix1D viewPart(int from, int length) {
        int end = from + length - 1;
        if (end > this.size - 1) {
            end = this.size - 1;
        }
        if (from < 0) {
            from = 0;
        }
        length = end - from + 1;
        int countSelection = 0;
        for (int i = 0; i < this.realSize; ++i) {
            if (this.positions[i] < from || this.positions[i] > end) continue;
            ++countSelection;
        }
        int[] tempPos = new int[countSelection];
        double[] tempVal = new double[countSelection];
        int j = 0;
        for (int i = 0; i < this.realSize; ++i) {
            if (this.positions[i] < from || this.positions[i] > end) continue;
            tempPos[j] = this.positions[i];
            tempVal[j] = this.values[i];
            ++j;
        }
        return new OptimizedMatrix1D(tempPos, tempVal, this.size, countSelection);
    }

    public double zSum() {
        double sum = 0.0;
        for (int i = 0; i < this.realSize; ++i) {
            sum += this.values[i];
        }
        return sum;
    }

    public double sumOfSquares() {
        double sum = 0.0;
        for (int i = 0; i < this.realSize; ++i) {
            sum += this.values[i] * this.values[i];
        }
        return sum;
    }

    public double zDotProduct(OptimizedMatrix1D other) {
        double product = 0.0;
        int j = 0;
        if (other.realSize > 0) {
            for (int i = 0; i < this.realSize; ++i) {
                while (j < other.realSize - 1 && other.positions[j] < this.positions[i]) {
                    ++j;
                }
                if (this.positions[i] != other.positions[j]) continue;
                product += this.values[i] * other.values[j];
            }
        }
        return product;
    }

    public int[] getNonZeroPositions() {
        this.trim();
        return this.positions;
    }

    public double[] getNonZeroValues() {
        this.trim();
        return this.values;
    }

    public void trim() {
        if (this.realSize < this.positions.length) {
            int[] tempPos = new int[this.realSize];
            double[] tempVal = new double[this.realSize];
            System.arraycopy(this.positions, 0, tempPos, 0, this.realSize);
            System.arraycopy(this.values, 0, tempVal, 0, this.realSize);
            this.positions = tempPos;
            this.values = tempVal;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.realSize; ++i) {
            buffer.append(this.positions[i] + ", " + this.values[i] + "\n");
        }
        return buffer.toString();
    }
}

