/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.graph;

import java.io.Serializable;
import java.util.TreeSet;
import simpack.accessor.string.StringAccessor;
import simpack.api.IGraphNode;
import simpack.measure.sequence.Levenshtein;
import simpack.util.graph.comparator.MappedVertexComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedVertex
implements Serializable {
    private static final long serialVersionUID = -111393192702009001L;
    private static final String DEFAULT_SIMILARITY_MEASURE = "Levenshtein";
    private String similarityMeasure = "Levenshtein";
    private IGraphNode left;
    private IGraphNode right;
    private int groupSize = 0;
    private boolean groupFlag = false;
    private double labelSimilarity = 0.0;
    private double groupSimilarity = 0.0;
    private TreeSet<MappedVertex> groupMembers = new TreeSet<MappedVertex>(new MappedVertexComparator());

    public MappedVertex(IGraphNode left, IGraphNode right) {
        this(left, right, DEFAULT_SIMILARITY_MEASURE);
    }

    public MappedVertex(IGraphNode left, IGraphNode right, String similarityMeasure) {
        this.left = left;
        this.right = right;
        this.similarityMeasure = similarityMeasure;
    }

    public IGraphNode getLeftNode() {
        return this.left;
    }

    public IGraphNode getRightNode() {
        return this.right;
    }

    public void setGroupSize(int size) {
        this.groupSize = size;
        this.groupFlag = true;
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public void setGroup() {
        this.groupFlag = true;
    }

    public boolean isGroup() {
        return this.groupFlag;
    }

    public void addGroupMember(MappedVertex mv) {
        this.groupMembers.add(mv);
    }

    public TreeSet<MappedVertex> getGroupMembers() {
        return this.groupMembers;
    }

    public void setLabelSimilarity(double similarity) {
        this.labelSimilarity = similarity;
    }

    public void setGroupSimilarity(double similarity) {
        this.groupSimilarity = similarity;
    }

    public double getGroupSimilarity() {
        return this.groupSimilarity;
    }

    public double getLabelSimilarity() {
        return this.labelSimilarity;
    }

    public double calculateLabelSimilarity() {
        double sim = 0.0;
        if (this.similarityMeasure.equals(DEFAULT_SIMILARITY_MEASURE)) {
            Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor(((Object)this.getLeftNode()).toString()), new StringAccessor(((Object)this.getRightNode()).toString()));
            sim = levenshtein.getSimilarity();
        }
        return sim;
    }

    public int smaller(MappedVertex mv) {
        return this.toString().compareTo(mv.toString());
    }

    public boolean equals(Object o) {
        MappedVertex mv = (MappedVertex)o;
        if (!this.isGroup() && !mv.isGroup()) {
            return this.getLeftNode().equals(mv.getLeftNode()) && this.getRightNode().equals(mv.getRightNode());
        }
        if (this.isGroup() && !mv.isGroup() || !this.isGroup() && mv.isGroup()) {
            return false;
        }
        TreeSet<MappedVertex> thisGroup = this.getGroupMembers();
        TreeSet<MappedVertex> otherGroup = mv.getGroupMembers();
        return thisGroup.equals(otherGroup);
    }

    public String toString() {
        if (!this.isGroup()) {
            return ((Object)this.getLeftNode()).toString() + ":" + ((Object)this.getRightNode()).toString();
        }
        String result = "<";
        TreeSet<MappedVertex> group = this.getGroupMembers();
        for (MappedVertex v : group) {
            result = result + " " + ((Object)v.getLeftNode()).toString() + ":" + ((Object)v.getRightNode()).toString();
        }
        result = result + " >";
        return result;
    }
}

