/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.graph;

import java.io.Serializable;
import java.util.TreeSet;
import simpack.api.IGraphNode;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphNode
implements IGraphNode,
Serializable {
    private static final long serialVersionUID = -7149340901405017775L;
    protected Object userObject;
    protected TreeSet<IGraphNode> predecessorSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
    protected TreeSet<IGraphNode> successorSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
    protected TreeSet<IGraphNode> adjacentSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
    protected boolean isGroup = false;
    protected int inDegree = 0;
    protected int outDegree = 0;
    private boolean hasGroup = false;

    public GraphNode() {
    }

    public GraphNode(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setHasGroup() {
        this.hasGroup = true;
    }

    @Override
    public boolean getHasGroup() {
        return this.hasGroup;
    }

    @Override
    public boolean getIsGroup() {
        return false;
    }

    @Override
    public TreeSet<IGraphNode> getGroupNodes() {
        return null;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public TreeSet<IGraphNode> getPredecessorSet() {
        return this.predecessorSet;
    }

    @Override
    public TreeSet<IGraphNode> getSuccessorSet() {
        return this.successorSet;
    }

    @Override
    public TreeSet<IGraphNode> getAdjacentSet() {
        return this.adjacentSet;
    }

    @Override
    public void addPredecessor(IGraphNode node) {
        this.predecessorSet.add(node);
        this.adjacentSet.add(node);
        ++this.inDegree;
    }

    @Override
    public void addSuccessor(IGraphNode node) {
        this.successorSet.add(node);
        this.adjacentSet.add(node);
        ++this.outDegree;
    }

    @Override
    public Integer getInDegree() {
        return this.inDegree;
    }

    @Override
    public Integer getOutDegree() {
        return this.outDegree;
    }

    @Override
    public String getLabel() {
        return this.toString();
    }

    @Override
    public int getGroupSize() {
        return 0;
    }

    @Override
    public String toString() {
        return this.userObject.toString();
    }

    public boolean equals(Object node) {
        GraphNode n = (GraphNode)node;
        return n.userObject.equals(this.userObject);
    }
}

