/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.corpus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class Indexer {
    public static Logger logger = Logger.getLogger(Indexer.class);
    public static Analyzer DEFAULT_ANALYZER = new SnowballAnalyzer("Porter", StopAnalyzer.ENGLISH_STOP_WORDS);
    public static final String DEFAULT_DOCUMENT_CONTENTS_FIELD_NAME = "contents";
    public static final String DEFAULT_DOCUMENT_TITLE_FIELD_NAME = "title";
    public static final String DEFAULT_DOCUMENT_URL_FIELD_NAME = "url";
    public static final String[] DEFAULT_FIELD_NAMES = new String[]{"contents"};

    public static void generateIndex(String indexDir, String dataDir) {
        try {
            FSDirectory directory = FSDirectory.getDirectory((String)indexDir, (boolean)true);
            IndexWriter writer = new IndexWriter((Directory)directory, DEFAULT_ANALYZER, true);
            Indexer.indexDirectory(writer, new File(dataDir));
            writer.optimize();
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void indexDirectory(IndexWriter writer, File dataDir) {
        File[] files = dataDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                Indexer.indexDirectory(writer, f);
                continue;
            }
            Indexer.indexFile(writer, f);
        }
    }

    private static void indexFile(IndexWriter writer, File f) {
        try {
            String docName = f.getName();
            Document doc = new Document();
            String content = "";
            BufferedReader br = new BufferedReader(new FileReader(f));
            content = br.readLine();
            String temp = "";
            while ((temp = br.readLine()) != null) {
                content = content + " " + temp;
            }
            br.close();
            doc.add(new Field(DEFAULT_DOCUMENT_CONTENTS_FIELD_NAME, content, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.YES));
            doc.add(new Field(DEFAULT_DOCUMENT_TITLE_FIELD_NAME, docName, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            doc.add(new Field(DEFAULT_DOCUMENT_URL_FIELD_NAME, f.getAbsolutePath(), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            logger.info((Object)("Indexing document " + docName));
            writer.addDocument(doc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Indexer.generateIndex("data/index", "data/corpus");
    }
}

