/*
 * Decompiled with CFR 0.152.
 */
package simpack.util;

import simpack.exception.InvalidVectorSizeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector<E extends Number>
extends java.util.Vector<E> {
    private static final long serialVersionUID = -6016841594387442712L;

    public Vector() {
    }

    public Vector(int size) {
        super(size);
    }

    public Vector(E[] values) {
        this(values.length);
        for (E d : values) {
            this.add(d);
        }
    }

    public double getDotProduct(Vector<? extends Number> vector) throws InvalidVectorSizeException {
        if (this.size() != vector.size()) {
            throw new InvalidVectorSizeException();
        }
        int pos = 0;
        double dotProduct = 0.0;
        for (Number number : vector) {
            dotProduct += number.doubleValue() * ((Number)this.elementAt(pos++)).doubleValue();
        }
        return dotProduct;
    }

    public Vector<? extends Number> getVectorAddition(Vector<? extends Number> vector) throws InvalidVectorSizeException {
        if (this.size() != vector.size()) {
            throw new InvalidVectorSizeException();
        }
        int pos = 0;
        Vector<Double> result = new Vector<Double>(this.size());
        for (Number v : this) {
            Double d = new Double(v.doubleValue() + ((Number)vector.elementAt(pos)).doubleValue());
            result.add(d);
        }
        return result;
    }

    public double getMinkowskiDistance(Vector<? extends Number> vector, double p) throws InvalidVectorSizeException {
        if (this.size() != vector.size()) {
            throw new InvalidVectorSizeException();
        }
        int pos = 0;
        double sum = 0.0;
        for (Number v : this) {
            double abs = Math.abs(v.doubleValue() - ((Number)vector.elementAt(pos++)).doubleValue());
            sum += Math.pow(abs, p);
        }
        return Math.pow(sum, 1.0 / p);
    }

    public double getEuclideanDistance(Vector<? extends Number> vector) throws InvalidVectorSizeException {
        return this.getMinkowskiDistance(vector, 2.0);
    }

    public double getManhattanDistance(Vector<? extends Number> vector) throws InvalidVectorSizeException {
        return this.getMinkowskiDistance(vector, 1.0);
    }

    public double getNorm(double p) {
        double d = 0.0;
        for (Number v : this) {
            d += Math.pow(v.doubleValue(), p);
        }
        d = Math.pow(d, 1.0 / p);
        return d;
    }

    public double getMean() {
        double d = 0.0;
        for (Number v : this) {
            d += v.doubleValue();
        }
        return d / (double)this.size();
    }

    public double getVariance() {
        double d = 0.0;
        double mean = this.getMean();
        for (Number v : this) {
            d += Math.pow(v.doubleValue() - mean, 2.0);
        }
        return d / (double)this.size();
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public Vector<? extends Number> convertToZScore() {
        double mean = this.getMean();
        double std = this.getStandardDeviation();
        System.out.println(mean + " " + std);
        Vector<Double> toZScore = new Vector<Double>(this.size());
        for (Number v : this) {
            toZScore.add((v.doubleValue() - mean) / std);
        }
        return toZScore;
    }
}

