/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.util.tree.comparator;

import java.util.TreeSet;
import junit.framework.TestCase;
import simpack.api.ITreeNode;
import simpack.util.tree.NodePriority;
import simpack.util.tree.TreeNode;
import simpack.util.tree.TreeNodePriorityTuple;
import simpack.util.tree.comparator.NodeComparator;

public class NodeComparatorTest
extends TestCase {
    private NodeComparator nc;
    private ITreeNode node;
    private TreeNodePriorityTuple t1;
    private TreeNodePriorityTuple t2;
    private TreeNodePriorityTuple t3;
    private TreeNodePriorityTuple t4;
    private TreeNodePriorityTuple t5;
    private NodePriority np1;
    private NodePriority np2;
    private NodePriority np3;
    private NodePriority np4;
    private NodePriority np5;
    private TreeSet<TreeNodePriorityTuple> queue;

    protected void setUp() throws Exception {
        super.setUp();
        this.nc = new NodeComparator();
        this.node = new TreeNode();
        this.np1 = new NodePriority(1, 1);
        this.np2 = new NodePriority(4, 8);
        this.np3 = new NodePriority(4, 3);
        this.np4 = new NodePriority(8, 5);
        this.np5 = new NodePriority(17, 10);
        this.t1 = new TreeNodePriorityTuple(this.node, this.np1);
        this.t2 = new TreeNodePriorityTuple(this.node, this.np2);
        this.t3 = new TreeNodePriorityTuple(this.node, this.np3);
        this.t4 = new TreeNodePriorityTuple(this.node, this.np4);
        this.t5 = new TreeNodePriorityTuple(this.node, this.np5);
        this.queue = new TreeSet<TreeNodePriorityTuple>(this.nc);
        this.queue.add(this.t1);
        this.queue.add(this.t2);
        this.queue.add(this.t3);
        this.queue.add(this.t4);
        this.queue.add(this.t5);
    }

    public void testQueueing() {
        NodeComparatorTest.assertTrue((this.queue.size() == 5 ? 1 : 0) != 0);
        NodeComparatorTest.assertSame((Object)this.queue.first(), (Object)this.t5);
        NodeComparatorTest.assertTrue((boolean)this.queue.remove(this.t5));
        NodeComparatorTest.assertSame((Object)this.queue.first(), (Object)this.t4);
        NodeComparatorTest.assertTrue((boolean)this.queue.remove(this.t4));
        NodeComparatorTest.assertSame((Object)this.queue.first(), (Object)this.t3);
        NodeComparatorTest.assertTrue((boolean)this.queue.remove(this.t3));
        NodeComparatorTest.assertSame((Object)this.queue.first(), (Object)this.t2);
        NodeComparatorTest.assertTrue((boolean)this.queue.remove(this.t2));
        NodeComparatorTest.assertSame((Object)this.queue.first(), (Object)this.t1);
        NodeComparatorTest.assertTrue((boolean)this.queue.remove(this.t1));
        NodeComparatorTest.assertTrue((this.queue.size() == 0 ? 1 : 0) != 0);
    }

    public void testCompareTreeNodePriorityTupleTreeNodePriorityTuple() {
        NodeComparatorTest.assertTrue((this.nc.compare(this.t1, this.t1) == 0 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((this.nc.compare(this.t2, this.t2) == 0 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((this.nc.compare(this.t3, this.t3) == 0 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((this.nc.compare(this.t4, this.t4) == 0 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((this.nc.compare(this.t5, this.t5) == 0 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((this.nc.compare(this.t1, this.t2) == 1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((this.nc.compare(this.t2, this.t1) == -1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((this.nc.compare(this.t2, this.t3) == 1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((this.nc.compare(this.t3, this.t2) == -1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((this.nc.compare(this.t3, this.t4) == 1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((this.nc.compare(this.t4, this.t3) == -1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((this.nc.compare(this.t4, this.t5) == 1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((this.nc.compare(this.t5, this.t4) == -1 ? 1 : 0) != 0);
    }

    public void testCompareNodePriorityNodePriority() {
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np1, this.np1) == 0 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np2, this.np2) == 0 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np3, this.np3) == 0 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np4, this.np4) == 0 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np5, this.np5) == 0 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np1, this.np2) == 1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np2, this.np1) == -1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np2, this.np3) == 1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np3, this.np2) == -1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np3, this.np4) == 1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np4, this.np3) == -1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np4, this.np5) == 1 ? 1 : 0) != 0);
        NodeComparatorTest.assertTrue((NodePriority.compare(this.np5, this.np4) == -1 ? 1 : 0) != 0);
    }
}

