/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.tree;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import simpack.accessor.tree.SimpleTreeAccessor;
import simpack.api.ITreeNode;
import simpack.util.tree.TreeNode;

public class TreeOrderingTest
extends TestCase {
    private ITreeNode tree1;
    private ITreeNode t1n1;
    private ITreeNode t1n2;
    private ITreeNode t1n3;
    private ITreeNode t1n4;
    private ITreeNode t1n5;
    private ITreeNode t1n6;
    private ITreeNode t1n7;
    private ArrayList<TreeNode> preorderTree1;
    private ArrayList<TreeNode> wrongPreorderTree1;
    private ArrayList<TreeNode> postorderTree1;
    private ArrayList<TreeNode> wrongPostorderTree1;

    protected void setUp() throws Exception {
        super.setUp();
        this.tree1 = this.generateSampleT1();
        this.generatePreorderSequenceT1();
        this.generateWrongPreorderSequenceT1();
        this.generatePostorderSequenceT1();
        this.generateWrongPostorderSequenceT1();
    }

    public void testPreorderSampleTreeT1() {
        TreeOrderingTest.assertNotNull((Object)this.tree1);
        TreeOrderingTest.assertNotNull(this.preorderTree1);
        List<Object> list = new SimpleTreeAccessor(this.tree1).getPreorderSequence();
        TreeOrderingTest.assertEquals((int)this.preorderTree1.size(), (int)list.size());
        int n = 0;
        for (TreeNode treeNode : this.preorderTree1) {
            TreeNode treeNode2 = (TreeNode)list.get(n++);
            TreeOrderingTest.assertEquals((Object)treeNode.getUserObject(), (Object)treeNode2.getUserObject());
        }
    }

    public void testWrongPreorderSampleTreeT1() {
        TreeOrderingTest.assertNotNull((Object)this.tree1);
        TreeOrderingTest.assertNotNull(this.wrongPreorderTree1);
        List<Object> list = new SimpleTreeAccessor(this.tree1).getPreorderSequence();
        TreeOrderingTest.assertEquals((int)this.wrongPreorderTree1.size(), (int)list.size());
        int n = 0;
        for (TreeNode treeNode : this.wrongPreorderTree1) {
            TreeNode treeNode2 = (TreeNode)list.get(n);
            if (n < 4) {
                TreeOrderingTest.assertEquals((Object)treeNode.getUserObject(), (Object)treeNode2.getUserObject());
            } else {
                TreeOrderingTest.assertNotSame((Object)treeNode.getUserObject().toString(), (Object)treeNode2.getUserObject().toString());
            }
            ++n;
        }
    }

    public void testPostorderSampleTreeT1() {
        TreeOrderingTest.assertNotNull((Object)this.tree1);
        TreeOrderingTest.assertNotNull(this.postorderTree1);
        List<Object> list = new SimpleTreeAccessor(this.tree1).getPostorderSequence();
        TreeOrderingTest.assertEquals((int)list.size(), (int)this.postorderTree1.size());
        int n = 0;
        for (TreeNode treeNode : this.postorderTree1) {
            TreeNode treeNode2 = (TreeNode)list.get(n++);
            TreeOrderingTest.assertEquals((Object)treeNode.getUserObject(), (Object)treeNode2.getUserObject());
        }
    }

    public void testWrongPostorderSampleTreeT1() {
        TreeOrderingTest.assertNotNull((Object)this.tree1);
        TreeOrderingTest.assertNotNull(this.wrongPostorderTree1);
        List<Object> list = new SimpleTreeAccessor(this.tree1).getPostorderSequence();
        TreeOrderingTest.assertEquals((int)this.wrongPostorderTree1.size(), (int)list.size());
        int n = 0;
        for (TreeNode treeNode : this.wrongPostorderTree1) {
            TreeNode treeNode2 = (TreeNode)list.get(n);
            if (n < 4) {
                TreeOrderingTest.assertEquals((Object)treeNode.getUserObject(), (Object)treeNode2.getUserObject());
            } else {
                TreeOrderingTest.assertNotSame((Object)treeNode.getUserObject().toString(), (Object)treeNode2.getUserObject().toString());
            }
            ++n;
        }
    }

    private ITreeNode generateSampleT1() {
        this.t1n1 = new TreeNode(new String("t1n1"));
        this.t1n2 = new TreeNode(new String("t1n2"));
        this.t1n3 = new TreeNode(new String("t1n3"));
        this.t1n4 = new TreeNode(new String("t1n4"));
        this.t1n5 = new TreeNode(new String("t1n5"));
        this.t1n6 = new TreeNode(new String("t1n6"));
        this.t1n7 = new TreeNode(new String("t1n7"));
        this.t1n4.add(this.t1n5);
        this.t1n4.add(this.t1n6);
        this.t1n3.add(this.t1n4);
        this.t1n3.add(this.t1n7);
        this.t1n1.add(this.t1n2);
        this.t1n1.add(this.t1n3);
        return this.t1n1;
    }

    private void generatePreorderSequenceT1() {
        this.preorderTree1 = new ArrayList();
        this.preorderTree1.add(new TreeNode(new String("t1n1")));
        this.preorderTree1.add(new TreeNode(new String("t1n2")));
        this.preorderTree1.add(new TreeNode(new String("t1n3")));
        this.preorderTree1.add(new TreeNode(new String("t1n4")));
        this.preorderTree1.add(new TreeNode(new String("t1n5")));
        this.preorderTree1.add(new TreeNode(new String("t1n6")));
        this.preorderTree1.add(new TreeNode(new String("t1n7")));
    }

    private void generateWrongPreorderSequenceT1() {
        this.wrongPreorderTree1 = new ArrayList();
        this.wrongPreorderTree1.add(new TreeNode(new String("t1n1")));
        this.wrongPreorderTree1.add(new TreeNode(new String("t1n2")));
        this.wrongPreorderTree1.add(new TreeNode(new String("t1n3")));
        this.wrongPreorderTree1.add(new TreeNode(new String("t1n4")));
        this.wrongPreorderTree1.add(new TreeNode(new String("t1n5")));
        this.wrongPreorderTree1.add(new TreeNode(new String("t1n7")));
        this.wrongPreorderTree1.add(new TreeNode(new String("t1n6")));
    }

    private void generatePostorderSequenceT1() {
        this.postorderTree1 = new ArrayList();
        this.postorderTree1.add(new TreeNode(new String("t1n2")));
        this.postorderTree1.add(new TreeNode(new String("t1n5")));
        this.postorderTree1.add(new TreeNode(new String("t1n6")));
        this.postorderTree1.add(new TreeNode(new String("t1n4")));
        this.postorderTree1.add(new TreeNode(new String("t1n7")));
        this.postorderTree1.add(new TreeNode(new String("t1n3")));
        this.postorderTree1.add(new TreeNode(new String("t1n1")));
    }

    private void generateWrongPostorderSequenceT1() {
        this.wrongPostorderTree1 = new ArrayList();
        this.wrongPostorderTree1.add(new TreeNode(new String("t1n2")));
        this.wrongPostorderTree1.add(new TreeNode(new String("t1n5")));
        this.wrongPostorderTree1.add(new TreeNode(new String("t1n6")));
        this.wrongPostorderTree1.add(new TreeNode(new String("t1n4")));
        this.wrongPostorderTree1.add(new TreeNode(new String("t1n7")));
        this.wrongPostorderTree1.add(new TreeNode(new String("t1n1")));
        this.wrongPostorderTree1.add(new TreeNode(new String("t1n3")));
    }
}

