/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.tree;

import junit.framework.TestCase;
import simpack.accessor.tree.SimpleTreeAccessor;
import simpack.api.ITreeNode;
import simpack.exception.InvalidElementException;
import simpack.measure.tree.TreeEditDistance;
import simpack.util.conversion.CommonDistanceConversion;
import simpack.util.conversion.LogarithmicDistanceConversion;
import simpack.util.conversion.WorstCaseDistanceConversion;
import simpack.util.tree.TreeNode;
import simpack.util.tree.comparator.AlwaysTrueTreeNodeComparator;

public class TreeEditDistanceTest
extends TestCase {
    private ITreeNode tree1;
    private ITreeNode tree2;
    private ITreeNode t1n1;
    private ITreeNode t1n2;
    private ITreeNode t1n3;
    private ITreeNode t1n4;
    private ITreeNode t1n5;
    private ITreeNode t2n1;
    private ITreeNode t2n2;
    private ITreeNode t2n3;
    private ITreeNode t2n4;
    private ITreeNode t2n5;
    private ITreeNode t2n6;
    private ITreeNode t2n7;
    private TreeEditDistance calc;
    private TreeEditDistance calc1;

    protected void setUp() throws Exception {
        super.setUp();
        this.tree1 = this.generateSampleT1();
        this.tree2 = this.generateSampleT2();
        this.calc = new TreeEditDistance(new SimpleTreeAccessor(this.tree1), new SimpleTreeAccessor(this.tree2), null, null, null, 0.0);
        this.calc1 = new TreeEditDistance(new SimpleTreeAccessor(this.tree1), new SimpleTreeAccessor(this.tree1), null, null, null, 0.0);
        TreeEditDistanceTest.assertTrue((boolean)this.calc.calculate());
        TreeEditDistanceTest.assertTrue((boolean)this.calc.isCalculated());
        TreeEditDistanceTest.assertTrue((boolean)this.calc1.calculate());
        TreeEditDistanceTest.assertTrue((boolean)this.calc1.isCalculated());
    }

    public void testSampleTree() {
        TreeEditDistanceTest.assertNotNull((Object)this.tree1);
        TreeEditDistanceTest.assertNotNull((Object)this.tree2);
        TreeEditDistanceTest.assertNotNull((Object)this.calc);
        TreeEditDistanceTest.assertTrue((boolean)this.calc.calculate());
        TreeEditDistanceTest.assertTrue((boolean)this.calc.isCalculated());
        TreeEditDistanceTest.assertEquals((Object)this.calc.getTreeEditDistance(), (Object)4.0);
    }

    public void testZeroDistance() {
        TreeEditDistanceTest.assertTrue((boolean)this.calc1.isCalculated());
        TreeEditDistanceTest.assertEquals((Object)this.calc1.getTreeEditDistance(), (Object)0.0);
    }

    public void testEditDistance() {
        TreeEditDistanceTest.assertNotNull((Object)this.tree1);
        TreeEditDistanceTest.assertNotNull((Object)this.tree2);
        try {
            this.calc = new TreeEditDistance(new SimpleTreeAccessor(this.tree1), new SimpleTreeAccessor(this.tree2), new AlwaysTrueTreeNodeComparator(), new WorstCaseDistanceConversion());
            TreeEditDistanceTest.assertNotNull((Object)this.calc);
            TreeEditDistanceTest.assertTrue((boolean)this.calc.calculate());
            TreeEditDistanceTest.assertTrue((boolean)this.calc.isCalculated());
            TreeEditDistanceTest.assertEquals((Object)this.calc.getTreeEditDistance(), (Object)4.0);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
    }

    public void testWorstCaseDistanceConversion() {
        TreeEditDistanceTest.assertNotNull((Object)this.tree1);
        TreeEditDistanceTest.assertNotNull((Object)this.tree2);
        try {
            this.calc = new TreeEditDistance(new SimpleTreeAccessor(this.tree1), new SimpleTreeAccessor(this.tree2), new AlwaysTrueTreeNodeComparator(), new WorstCaseDistanceConversion());
            TreeEditDistanceTest.assertNotNull((Object)this.calc);
            TreeEditDistanceTest.assertTrue((boolean)this.calc.calculate());
            TreeEditDistanceTest.assertTrue((boolean)this.calc.isCalculated());
            TreeEditDistanceTest.assertEquals((Object)this.calc.getSimilarity(), (Object)0.6666666666666666);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
    }

    public void testCommonDistanceConversion() {
        TreeEditDistanceTest.assertNotNull((Object)this.tree1);
        TreeEditDistanceTest.assertNotNull((Object)this.tree2);
        try {
            this.calc = new TreeEditDistance(new SimpleTreeAccessor(this.tree1), new SimpleTreeAccessor(this.tree2), new AlwaysTrueTreeNodeComparator(), new CommonDistanceConversion());
            TreeEditDistanceTest.assertNotNull((Object)this.calc);
            TreeEditDistanceTest.assertTrue((boolean)this.calc.calculate());
            TreeEditDistanceTest.assertTrue((boolean)this.calc.isCalculated());
            TreeEditDistanceTest.assertEquals((Object)this.calc.getSimilarity(), (Object)0.2);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
    }

    public void testLogarithmicDistanceConversion() {
        TreeEditDistanceTest.assertNotNull((Object)this.tree1);
        TreeEditDistanceTest.assertNotNull((Object)this.tree2);
        try {
            this.calc = new TreeEditDistance(new SimpleTreeAccessor(this.tree1), new SimpleTreeAccessor(this.tree2), new AlwaysTrueTreeNodeComparator(), new LogarithmicDistanceConversion());
            TreeEditDistanceTest.assertNotNull((Object)this.calc);
            TreeEditDistanceTest.assertTrue((boolean)this.calc.calculate());
            TreeEditDistanceTest.assertTrue((boolean)this.calc.isCalculated());
            TreeEditDistanceTest.assertEquals((Object)this.calc.getSimilarity(), (Object)Math.exp(-16.0));
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
    }

    private ITreeNode generateSampleT1() {
        this.t1n1 = new TreeNode(new String("t1n1"));
        this.t1n2 = new TreeNode(new String("t1n2"));
        this.t1n3 = new TreeNode(new String("t1n3"));
        this.t1n4 = new TreeNode(new String("t1n4"));
        this.t1n5 = new TreeNode(new String("t1n5"));
        this.t1n2.add(this.t1n3);
        this.t1n2.add(this.t1n4);
        this.t1n1.add(this.t1n2);
        this.t1n1.add(this.t1n5);
        return this.t1n1;
    }

    private ITreeNode generateSampleT2() {
        this.t2n1 = new TreeNode(new String("t2n1"));
        this.t2n2 = new TreeNode(new String("t2n2"));
        this.t2n3 = new TreeNode(new String("t2n3"));
        this.t2n4 = new TreeNode(new String("t2n4"));
        this.t2n5 = new TreeNode(new String("t2n5"));
        this.t2n6 = new TreeNode(new String("t2n6"));
        this.t2n7 = new TreeNode(new String("t2n7"));
        this.t2n4.add(this.t2n5);
        this.t2n4.add(this.t2n6);
        this.t2n3.add(this.t2n4);
        this.t2n3.add(this.t2n7);
        this.t2n1.add(this.t2n2);
        this.t2n1.add(this.t2n3);
        return this.t2n1;
    }
}

