/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.tree;

import java.util.Enumeration;
import java.util.HashMap;
import junit.framework.TestCase;
import simpack.accessor.tree.SimpleTreeAccessor;
import simpack.api.ITreeNode;
import simpack.exception.InvalidElementException;
import simpack.measure.tree.TopDownOrderedMaximumSubtree;
import simpack.util.tree.TreeNode;
import simpack.util.tree.comparator.NamedTreeNodeComparator;

public class TopDownOrderedMaximumSubtreeTest
extends TestCase {
    private ITreeNode tree1;
    private ITreeNode tree2;
    private ITreeNode t1n1;
    private ITreeNode t1n2;
    private ITreeNode t1n3;
    private ITreeNode t1n4;
    private ITreeNode t1n5;
    private ITreeNode t1n6;
    private ITreeNode t1n7;
    private ITreeNode t1n8;
    private ITreeNode t1n9;
    private ITreeNode t1n10;
    private ITreeNode t1n11;
    private ITreeNode t1n12;
    private ITreeNode t2n1;
    private ITreeNode t2n2;
    private ITreeNode t2n3;
    private ITreeNode t2n4;
    private ITreeNode t2n5;
    private ITreeNode t2n6;
    private ITreeNode t2n7;
    private ITreeNode t2n8;
    private ITreeNode t2n9;
    private ITreeNode t2n10;
    private ITreeNode t2n11;
    private ITreeNode t2n12;
    private ITreeNode t2n13;
    private ITreeNode t2n14;
    private ITreeNode t2n15;
    private ITreeNode t2n16;
    private ITreeNode t2n17;
    private ITreeNode t2n18;
    private TopDownOrderedMaximumSubtree cstree1;

    protected void setUp() throws Exception {
        super.setUp();
        this.tree1 = this.generateSampleT1();
        this.tree2 = this.generateSampleT2();
        this.cstree1 = new TopDownOrderedMaximumSubtree(new SimpleTreeAccessor(this.tree1), new SimpleTreeAccessor(this.tree2));
        TopDownOrderedMaximumSubtreeTest.assertTrue((boolean)this.cstree1.calculate());
        TopDownOrderedMaximumSubtreeTest.assertTrue((boolean)this.cstree1.isCalculated());
    }

    public void testCalculation() {
        TopDownOrderedMaximumSubtreeTest.assertNotNull((Object)this.tree1);
        TopDownOrderedMaximumSubtreeTest.assertNotNull((Object)this.tree2);
        TopDownOrderedMaximumSubtreeTest.assertNotNull((Object)this.cstree1);
        HashMap<ITreeNode, ITreeNode> hashMap = this.cstree1.getMappedTrees();
        TopDownOrderedMaximumSubtreeTest.assertNotNull(hashMap);
        TopDownOrderedMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n12), (Object)this.t2n18);
        TopDownOrderedMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n6), (Object)this.t2n4);
        TopDownOrderedMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n5), (Object)this.t2n1);
        TopDownOrderedMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n11), (Object)this.t2n12);
        TopDownOrderedMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n9), (Object)this.t2n5);
        TopDownOrderedMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n10), (Object)this.t2n11);
        NamedTreeNodeComparator namedTreeNodeComparator = new NamedTreeNodeComparator();
        ITreeNode iTreeNode = this.cstree1.getMatchedTree1();
        Enumeration enumeration = iTreeNode.postorderEnumeration();
        TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), this.t1n5), (int)0);
        TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), this.t1n6), (int)0);
        TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), this.t1n9), (int)0);
        TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), this.t1n10), (int)0);
        TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), this.t1n11), (int)0);
        TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), this.t1n12), (int)0);
        ITreeNode iTreeNode2 = this.cstree1.getMatchedTree2();
        enumeration = iTreeNode2.postorderEnumeration();
        TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), this.t2n1), (int)0);
        TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), this.t2n4), (int)0);
        TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), this.t2n5), (int)0);
        TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), this.t2n11), (int)0);
        TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), this.t2n12), (int)0);
        TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), this.t2n18), (int)0);
    }

    public void testOwnComparator() {
        NamedTreeNodeComparator namedTreeNodeComparator = new NamedTreeNodeComparator();
        TopDownOrderedMaximumSubtree topDownOrderedMaximumSubtree = null;
        try {
            topDownOrderedMaximumSubtree = new TopDownOrderedMaximumSubtree(new SimpleTreeAccessor(this.tree1), new SimpleTreeAccessor(this.tree2), namedTreeNodeComparator);
        }
        catch (NullPointerException nullPointerException) {
            TopDownOrderedMaximumSubtreeTest.fail();
        }
        catch (InvalidElementException invalidElementException) {
            TopDownOrderedMaximumSubtreeTest.fail();
        }
        TopDownOrderedMaximumSubtreeTest.assertNotNull(topDownOrderedMaximumSubtree);
        TopDownOrderedMaximumSubtreeTest.assertTrue((boolean)topDownOrderedMaximumSubtree.calculate());
        TopDownOrderedMaximumSubtreeTest.assertTrue((boolean)topDownOrderedMaximumSubtree.isCalculated());
        this.checkSameCalc(topDownOrderedMaximumSubtree);
    }

    public void testRecalc() {
        TopDownOrderedMaximumSubtree topDownOrderedMaximumSubtree = null;
        try {
            topDownOrderedMaximumSubtree = new TopDownOrderedMaximumSubtree(new SimpleTreeAccessor(this.tree1), new SimpleTreeAccessor(this.tree2));
        }
        catch (NullPointerException nullPointerException) {
            TopDownOrderedMaximumSubtreeTest.fail();
        }
        catch (InvalidElementException invalidElementException) {
            TopDownOrderedMaximumSubtreeTest.fail();
        }
        TopDownOrderedMaximumSubtreeTest.assertNotNull(topDownOrderedMaximumSubtree);
        TopDownOrderedMaximumSubtreeTest.assertTrue((boolean)topDownOrderedMaximumSubtree.calculate());
        TopDownOrderedMaximumSubtreeTest.assertTrue((boolean)topDownOrderedMaximumSubtree.isCalculated());
        this.checkSameCalc(topDownOrderedMaximumSubtree);
    }

    private void checkSameCalc(TopDownOrderedMaximumSubtree topDownOrderedMaximumSubtree) {
        TopDownOrderedMaximumSubtreeTest.assertEquals(this.cstree1.getMappedTrees(), topDownOrderedMaximumSubtree.getMappedTrees());
        Enumeration enumeration = this.cstree1.getMatchedTree1().postorderEnumeration();
        Enumeration enumeration2 = topDownOrderedMaximumSubtree.getMatchedTree1().postorderEnumeration();
        TopDownOrderedMaximumSubtreeTest.assertTrue((boolean)this.checkSameEnum(enumeration, enumeration2));
        enumeration = this.cstree1.getMatchedTree2().postorderEnumeration();
        enumeration2 = topDownOrderedMaximumSubtree.getMatchedTree2().postorderEnumeration();
        TopDownOrderedMaximumSubtreeTest.assertTrue((boolean)this.checkSameEnum(enumeration, enumeration2));
    }

    private boolean checkSameEnum(Enumeration enumeration, Enumeration enumeration2) {
        NamedTreeNodeComparator namedTreeNodeComparator = new NamedTreeNodeComparator();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            TopDownOrderedMaximumSubtreeTest.assertEquals((int)namedTreeNodeComparator.compare((ITreeNode)enumeration.nextElement(), (ITreeNode)enumeration2.nextElement()), (int)0);
        }
        TopDownOrderedMaximumSubtreeTest.assertFalse((boolean)enumeration.hasMoreElements());
        TopDownOrderedMaximumSubtreeTest.assertFalse((boolean)enumeration2.hasMoreElements());
        return true;
    }

    private ITreeNode generateSampleT1() {
        this.t1n1 = new TreeNode(new String("t1n1"));
        this.t1n2 = new TreeNode(new String("t1n2"));
        this.t1n3 = new TreeNode(new String("t1n3"));
        this.t1n4 = new TreeNode(new String("t1n4"));
        this.t1n5 = new TreeNode(new String("C"));
        this.t1n6 = new TreeNode(new String("B"));
        this.t1n7 = new TreeNode(new String("t1n7"));
        this.t1n8 = new TreeNode(new String("t1n8"));
        this.t1n9 = new TreeNode(new String("E"));
        this.t1n10 = new TreeNode(new String("F"));
        this.t1n11 = new TreeNode(new String("D"));
        this.t1n12 = new TreeNode(new String("A"));
        this.t1n4.add(this.t1n2);
        this.t1n4.add(this.t1n3);
        this.t1n5.add(this.t1n1);
        this.t1n5.add(this.t1n4);
        this.t1n6.add(this.t1n5);
        this.t1n9.add(this.t1n7);
        this.t1n9.add(this.t1n8);
        this.t1n11.add(this.t1n9);
        this.t1n11.add(this.t1n10);
        this.t1n12.add(this.t1n6);
        this.t1n12.add(this.t1n11);
        return this.t1n12;
    }

    private ITreeNode generateSampleT2() {
        this.t2n1 = new TreeNode(new String("C"));
        this.t2n2 = new TreeNode(new String("t2n2"));
        this.t2n3 = new TreeNode(new String("t2n3"));
        this.t2n4 = new TreeNode(new String("B"));
        this.t2n5 = new TreeNode(new String("E"));
        this.t2n6 = new TreeNode(new String("t2n6"));
        this.t2n7 = new TreeNode(new String("t2n7"));
        this.t2n8 = new TreeNode(new String("t2n8"));
        this.t2n9 = new TreeNode(new String("t2n9"));
        this.t2n10 = new TreeNode(new String("t2n10"));
        this.t2n11 = new TreeNode(new String("F"));
        this.t2n12 = new TreeNode(new String("D"));
        this.t2n13 = new TreeNode(new String("t2n13"));
        this.t2n14 = new TreeNode(new String("t2n14"));
        this.t2n15 = new TreeNode(new String("t2n15"));
        this.t2n16 = new TreeNode(new String("t2n16"));
        this.t2n17 = new TreeNode(new String("t2n17"));
        this.t2n18 = new TreeNode(new String("A"));
        this.t2n3.add(this.t2n2);
        this.t2n4.add(this.t2n1);
        this.t2n4.add(this.t2n3);
        this.t2n8.add(this.t2n6);
        this.t2n8.add(this.t2n7);
        this.t2n9.add(this.t2n8);
        this.t2n11.add(this.t2n9);
        this.t2n11.add(this.t2n10);
        this.t2n12.add(this.t2n5);
        this.t2n12.add(this.t2n11);
        this.t2n16.add(this.t2n15);
        this.t2n17.add(this.t2n13);
        this.t2n17.add(this.t2n14);
        this.t2n17.add(this.t2n16);
        this.t2n18.add(this.t2n4);
        this.t2n18.add(this.t2n12);
        this.t2n18.add(this.t2n17);
        return this.t2n18;
    }
}

