/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.tree;

import java.util.LinkedHashMap;
import java.util.List;
import simpack.api.ITreeNode;
import simpack.exception.InvalidElementException;
import simpack.tests.measure.tree.DefaultTreeTestCase;
import simpack.util.tree.EquivalenceClassCalculator;
import simpack.util.tree.TreeUtil;

public class EquivalenceClassCalculatorTest
extends DefaultTreeTestCase {
    private List<ITreeNode> list1;
    private List<ITreeNode> list2;
    private EquivalenceClassCalculator cec;

    protected void setUp() throws Exception {
        super.setUp();
        this.list1 = TreeUtil.enumerationToList(this.tree1.postorderEnumeration());
        this.list2 = TreeUtil.enumerationToList(this.tree2.postorderEnumeration());
        this.cec = new EquivalenceClassCalculator(this.tree1, this.list1, this.tree2, this.list2);
        EquivalenceClassCalculatorTest.assertTrue((boolean)this.cec.calculate());
    }

    public void testCalculateEquivalenceClasses() {
        try {
            new EquivalenceClassCalculator(null, this.list1, this.tree2, this.list2);
            EquivalenceClassCalculatorTest.fail((String)"Should throw NPE");
        }
        catch (InvalidElementException invalidElementException) {
            EquivalenceClassCalculatorTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new EquivalenceClassCalculator(this.tree1, null, this.tree2, this.list2);
            EquivalenceClassCalculatorTest.fail((String)"Should throw NPE");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (InvalidElementException invalidElementException) {
            EquivalenceClassCalculatorTest.fail();
        }
        try {
            new EquivalenceClassCalculator(this.tree1, this.list1, null, this.list2);
            EquivalenceClassCalculatorTest.fail((String)"Should throw NPE");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (InvalidElementException invalidElementException) {
            EquivalenceClassCalculatorTest.fail();
        }
        try {
            new EquivalenceClassCalculator(this.tree1, this.list1, this.tree2, null);
            EquivalenceClassCalculatorTest.fail((String)"Should throw NPE");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (InvalidElementException invalidElementException) {
            EquivalenceClassCalculatorTest.fail();
        }
    }

    public void testReuse() {
        EquivalenceClassCalculator equivalenceClassCalculator = null;
        try {
            equivalenceClassCalculator = new EquivalenceClassCalculator(this.tree1, this.list1, this.tree2, this.list2);
        }
        catch (NullPointerException nullPointerException) {
            EquivalenceClassCalculatorTest.fail();
        }
        catch (InvalidElementException invalidElementException) {
            EquivalenceClassCalculatorTest.fail();
        }
        EquivalenceClassCalculatorTest.assertNotNull(equivalenceClassCalculator);
        EquivalenceClassCalculatorTest.assertTrue((boolean)equivalenceClassCalculator.calculate());
        EquivalenceClassCalculatorTest.assertTrue((boolean)equivalenceClassCalculator.isCalculated());
        LinkedHashMap<ITreeNode, Integer> linkedHashMap = equivalenceClassCalculator.getEquivalenceClassesTree1();
        EquivalenceClassCalculatorTest.assertNotNull(linkedHashMap);
        LinkedHashMap<ITreeNode, Integer> linkedHashMap2 = equivalenceClassCalculator.getEquivalenceClassesTree2();
        EquivalenceClassCalculatorTest.assertNotNull(linkedHashMap2);
        LinkedHashMap<ITreeNode, Integer> linkedHashMap3 = equivalenceClassCalculator.getEquivalenceClassesTree1();
        EquivalenceClassCalculatorTest.assertNotNull(linkedHashMap3);
        LinkedHashMap<ITreeNode, Integer> linkedHashMap4 = equivalenceClassCalculator.getEquivalenceClassesTree2();
        EquivalenceClassCalculatorTest.assertNotNull(linkedHashMap4);
        EquivalenceClassCalculatorTest.assertSame(linkedHashMap, linkedHashMap3);
        EquivalenceClassCalculatorTest.assertSame(linkedHashMap2, linkedHashMap4);
    }

    public void testGetEquivalenceClassesTree1() {
        EquivalenceClassCalculatorTest.assertTrue((boolean)this.cec.isCalculated());
        LinkedHashMap<ITreeNode, Integer> linkedHashMap = this.cec.getEquivalenceClassesTree1();
        EquivalenceClassCalculatorTest.assertNotNull(linkedHashMap);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n1), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n2), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n3), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n4), (int)2);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n5), (int)3);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n6), (int)4);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n7), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n8), (int)5);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n9), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n10), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n11), (int)2);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n12), (int)3);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n13), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n14), (int)4);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t1n15), (int)6);
    }

    public void testGetEquivalenceClassesTree2() {
        EquivalenceClassCalculatorTest.assertTrue((boolean)this.cec.isCalculated());
        LinkedHashMap<ITreeNode, Integer> linkedHashMap = this.cec.getEquivalenceClassesTree2();
        EquivalenceClassCalculatorTest.assertNotNull(linkedHashMap);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n1), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n2), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n3), (int)7);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n4), (int)8);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n5), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n6), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n7), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n8), (int)2);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n9), (int)3);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n10), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n11), (int)4);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n12), (int)5);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n13), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n14), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n15), (int)1);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n16), (int)7);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n17), (int)9);
        EquivalenceClassCalculatorTest.assertEquals((int)linkedHashMap.get(this.t2n18), (int)10);
    }
}

