/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.tree;

import ch.toe.famix.FAMIXInstance;
import ch.toe.famix.model.Attribute;
import ch.toe.famix.model.BehaviouralEntity;
import ch.toe.famix.model.Class;
import ch.toe.famix.model.Context;
import ch.toe.famix.model.FormalParameter;
import ch.toe.famix.model.Method;
import ch.toe.famix.model.Model;
import ch.toe.famix.model.Package;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.TestCase;
import simpack.accessor.tree.FamixTreeAccessor;
import simpack.api.ITreeNode;
import simpack.exception.InvalidElementException;
import simpack.util.tree.TreeNode;
import simpack.util.tree.comparator.NamedTreeNodeComparator;

public class CommonTreeOperationsTest
extends TestCase {
    private ITreeNode tree2;
    private FAMIXInstance famixInstance;
    private FamixTreeAccessor accessor;
    private ITreeNode t2n1;
    private ITreeNode t2n2;
    private ITreeNode t2n3;
    private ITreeNode t2n4;
    private ITreeNode t2n5;
    private ITreeNode t2n6;
    private ITreeNode t2n7;

    protected void setUp() throws Exception {
        super.setUp();
        this.tree2 = this.generateSampleT2();
        CommonTreeOperationsTest.assertNotNull((Object)this.tree2);
        this.famixInstance = this.generateFamixInstance();
        CommonTreeOperationsTest.assertNotNull((Object)this.famixInstance);
        this.accessor = new FamixTreeAccessor(this.famixInstance);
        CommonTreeOperationsTest.assertNotNull((Object)this.accessor);
        ITreeNode iTreeNode = this.accessor.getRoot();
        CommonTreeOperationsTest.assertNotNull((Object)iTreeNode);
        CommonTreeOperationsTest.assertEquals((String)iTreeNode.toString(), (String)"FAMIXInstance");
    }

    public void testFAMIXTreeMRCAOfNodes() {
        String string = new String("HelloWorld.printText(String).output");
        String string2 = new String("HelloUnderWorld.input");
        Object object = null;
        try {
            object = this.accessor.getMostRecentCommonAncestor(new TreeNode(string), new TreeNode(string2));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        CommonTreeOperationsTest.assertNotNull(object);
        CommonTreeOperationsTest.assertEquals((String)object.toString(), (String)"base.test");
    }

    public void testFAMIXTreeDescendantsOfNode() {
        Set<ITreeNode> set = null;
        try {
            set = this.accessor.getDescendants(new TreeNode("base"));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        TreeSet<ITreeNode> treeSet = new TreeSet<ITreeNode>(new NamedTreeNodeComparator());
        treeSet.add(new TreeNode("base.test"));
        treeSet.add(new TreeNode("HelloWorld"));
        treeSet.add(new TreeNode("HelloWorld.output"));
        treeSet.add(new TreeNode("HelloWorld.printText(String)"));
        treeSet.add(new TreeNode("HelloWorld.printText(String).output"));
        treeSet.add(new TreeNode("HelloUnderWorld"));
        treeSet.add(new TreeNode("HelloUnderWorld.input"));
        CommonTreeOperationsTest.assertEquals(set, treeSet);
    }

    public void testFAMIXTreeAncestorsOfNode() {
        Set<ITreeNode> set = null;
        try {
            set = this.accessor.getAncestors(new TreeNode("HelloWorld.printText(String).output"));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        TreeSet<ITreeNode> treeSet = new TreeSet<ITreeNode>(new NamedTreeNodeComparator());
        treeSet.add(new TreeNode("FAMIXInstance"));
        treeSet.add(new TreeNode("base"));
        treeSet.add(new TreeNode("base.test"));
        treeSet.add(new TreeNode("HelloWorld"));
        treeSet.add(new TreeNode("HelloWorld.printText(String)"));
        CommonTreeOperationsTest.assertEquals(set, treeSet);
    }

    public void testFAMIXTreeChildrenOfNode() {
        Set<ITreeNode> set = null;
        try {
            set = this.accessor.getChildren(new TreeNode("HelloWorld"));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        TreeSet<ITreeNode> treeSet = new TreeSet<ITreeNode>(new NamedTreeNodeComparator());
        treeSet.add(new TreeNode("HelloWorld.output"));
        treeSet.add(new TreeNode("HelloWorld.printText(String)"));
        CommonTreeOperationsTest.assertEquals(set, treeSet);
    }

    public void testFAMIXTreeParentsOfNode() {
        Set<ITreeNode> set = null;
        try {
            set = this.accessor.getParents(new TreeNode("HelloWorld"));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        TreeSet<ITreeNode> treeSet = new TreeSet<ITreeNode>(new NamedTreeNodeComparator());
        treeSet.add(new TreeNode("base.test"));
        CommonTreeOperationsTest.assertEquals(set, treeSet);
    }

    public void testFAMIXContainsNode() {
        CommonTreeOperationsTest.assertTrue((boolean)this.accessor.contains(new TreeNode("HelloWorld")));
        CommonTreeOperationsTest.assertFalse((boolean)this.accessor.contains(new TreeNode("HelloMyWorld")));
    }

    public void testFAMIXTreeSize() {
        CommonTreeOperationsTest.assertEquals((int)this.accessor.size(), (int)10);
    }

    public void testFAMIXTreeException() {
        Object object;
        try {
            object = this.accessor.getChildren(new TreeNode("HelloMyWorld"));
            CommonTreeOperationsTest.fail((String)"This should throw an InvalidNodeException");
        }
        catch (InvalidElementException invalidElementException) {
            CommonTreeOperationsTest.assertTrue((boolean)true);
        }
        try {
            object = this.accessor.getDescendants(new TreeNode("HelloMyWorld"));
            CommonTreeOperationsTest.fail((String)"This should throw an InvalidNodeException");
        }
        catch (InvalidElementException invalidElementException) {
            CommonTreeOperationsTest.assertTrue((boolean)true);
        }
        try {
            object = this.accessor.getMostRecentCommonAncestor(new TreeNode("HelloMyWorld"), new TreeNode("HelloUnderWorld"));
            CommonTreeOperationsTest.fail((String)"This should throw an InvalidNodeException");
        }
        catch (InvalidElementException invalidElementException) {
            CommonTreeOperationsTest.assertTrue((boolean)true);
        }
        try {
            object = this.accessor.getMostRecentCommonAncestor(new TreeNode("HelloWorld"), new TreeNode("HelloMyUnderWorld"));
            CommonTreeOperationsTest.fail((String)"This should throw an InvalidNodeException");
        }
        catch (InvalidElementException invalidElementException) {
            CommonTreeOperationsTest.assertTrue((boolean)true);
        }
    }

    private FAMIXInstance generateFamixInstance() {
        Model model = new Model("TestSuite", "n/a", "3", "Java");
        FAMIXInstance fAMIXInstance = new FAMIXInstance(model);
        Package package_ = fAMIXInstance.addPackage("base", null);
        Package package_2 = new Package("test", package_);
        package_2.setBelongsTo((Context)package_);
        Class clazz = new Class("HelloWorld");
        package_2.getClasses().add(clazz);
        clazz.getAttributes().add(new Attribute("output", clazz));
        Class clazz2 = new Class("HelloUnderWorld");
        package_2.getClasses().add(clazz2);
        clazz2.getAttributes().add(new Attribute("input", clazz2));
        Method method = new Method("printText", "printText(String)", clazz);
        clazz.getMethods().add(method);
        method.getFormalParameters().add(new FormalParameter("output", (BehaviouralEntity)method, new Integer(1)));
        return fAMIXInstance;
    }

    private ITreeNode generateSampleT2() {
        this.t2n1 = new TreeNode(new String("t2n1"));
        this.t2n2 = new TreeNode(new String("t2n2"));
        this.t2n3 = new TreeNode(new String("t2n3"));
        this.t2n4 = new TreeNode(new String("t2n4"));
        this.t2n5 = new TreeNode(new String("t2n5"));
        this.t2n6 = new TreeNode(new String("t2n6"));
        this.t2n7 = new TreeNode(new String("t2n7"));
        this.t2n4.add(this.t2n5);
        this.t2n4.add(this.t2n6);
        this.t2n3.add(this.t2n4);
        this.t2n3.add(this.t2n7);
        this.t2n1.add(this.t2n2);
        this.t2n1.add(this.t2n3);
        return this.t2n1;
    }
}

