/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.tree;

import ch.toe.famix.FAMIXInstance;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import simpack.accessor.tree.FamixTreeAccessor;
import simpack.accessor.tree.SimpleTreeAccessor;
import simpack.api.ITreeNode;
import simpack.exception.InvalidElementException;
import simpack.measure.tree.BottomUpMaximumSubtree;
import simpack.tests.accessor.tree.TreeAccessorTest;
import simpack.tests.measure.tree.DefaultTreeTestCase;
import simpack.util.tree.TreeNode;
import simpack.util.tree.TreeUtil;
import simpack.util.tree.comparator.AlwaysTrueTreeNodeComparator;

public class BottomUpMaximumSubtreeTest
extends DefaultTreeTestCase {
    private TreeNode tree3;
    private TreeNode tree4;
    private TreeNode t3n1;
    private TreeNode t3n2;
    private TreeNode t3n3;
    private TreeNode t4n1;
    private TreeNode t4n2;
    private TreeNode t4n3;
    private TreeNode t4n4;
    private TreeNode t4n5;
    private TreeNode t4n6;
    private TreeNode t4n7;
    private TreeNode t4n8;
    private TreeNode t4n9;
    private TreeNode t4n10;
    private TreeNode t4n11;
    private TreeNode t4n12;
    private TreeNode t4n13;
    private BottomUpMaximumSubtree cstree1;
    private BottomUpMaximumSubtree cstree2;

    protected void setUp() throws Exception {
        super.setUp();
        this.cstree1 = new BottomUpMaximumSubtree(new SimpleTreeAccessor(this.tree1), new SimpleTreeAccessor(this.tree2));
        BottomUpMaximumSubtreeTest.assertTrue((boolean)this.cstree1.calculate());
        this.tree3 = this.generateSampleT3();
        this.tree4 = this.generateSampleT4();
        this.cstree2 = new BottomUpMaximumSubtree(new SimpleTreeAccessor(this.tree3), new SimpleTreeAccessor(this.tree4));
        BottomUpMaximumSubtreeTest.assertTrue((boolean)this.cstree2.calculate());
    }

    public void testRecalculation() {
        BottomUpMaximumSubtreeTest.assertTrue((boolean)this.cstree1.calculate());
        BottomUpMaximumSubtreeTest.assertTrue((boolean)this.cstree2.calculate());
    }

    public void testMatchingSubtree1() {
        BottomUpMaximumSubtreeTest.assertNotNull((Object)this.tree1);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)this.tree2);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)this.cstree1);
        BottomUpMaximumSubtreeTest.assertTrue((boolean)this.cstree1.isCalculated());
        BottomUpMaximumSubtreeTest.assertTrue((this.cstree1.getSubtreeRootNodesTree1().size() == 1 ? 1 : 0) != 0);
        BottomUpMaximumSubtreeTest.assertTrue((this.cstree1.getSubtreeRootNodesTree2().size() == 1 ? 1 : 0) != 0);
        BottomUpMaximumSubtreeTest.assertSame((Object)this.cstree1.getSubtreeRootNodesTree1().get(0), (Object)this.t1n8);
        BottomUpMaximumSubtreeTest.assertSame((Object)this.cstree1.getSubtreeRootNodesTree2().get(0), (Object)this.t2n12);
        HashMap<TreeNode, TreeNode> hashMap = null;
        try {
            hashMap = this.cstree1.mapTrees(this.cstree1.getSubtreeRootNodesTree1().get(0), this.cstree1.getSubtreeRootNodesTree2().get(0));
        }
        catch (InvalidElementException invalidElementException) {
            BottomUpMaximumSubtreeTest.fail();
        }
        BottomUpMaximumSubtreeTest.assertNotNull(hashMap);
        BottomUpMaximumSubtreeTest.assertNotNull(hashMap.get(this.t1n8));
        BottomUpMaximumSubtreeTest.assertSame(hashMap.get(this.t1n8), (Object)this.t2n12);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t1n6));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n6), (Object)this.t2n11);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t1n7));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n7), (Object)this.t2n5);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t1n1));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n1), (Object)this.t2n10);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t1n5));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n5), (Object)this.t2n9);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t1n4));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n4), (Object)this.t2n8);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t1n2));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n2), (Object)this.t2n6);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t1n3));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t1n3), (Object)this.t2n7);
    }

    public void testMatchingSubtree2() {
        BottomUpMaximumSubtreeTest.assertNotNull((Object)this.tree3);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)this.tree4);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)this.cstree2);
        BottomUpMaximumSubtreeTest.assertTrue((boolean)this.cstree2.isCalculated());
        BottomUpMaximumSubtreeTest.assertTrue((this.cstree2.getSubtreeRootNodesTree1().size() == 1 ? 1 : 0) != 0);
        BottomUpMaximumSubtreeTest.assertTrue((this.cstree2.getSubtreeRootNodesTree2().size() == 3 ? 1 : 0) != 0);
        BottomUpMaximumSubtreeTest.assertSame((Object)this.cstree2.getSubtreeRootNodesTree1().get(0), (Object)this.t3n3);
        BottomUpMaximumSubtreeTest.assertSame((Object)this.cstree2.getSubtreeRootNodesTree2().get(0), (Object)this.t4n3);
        BottomUpMaximumSubtreeTest.assertSame((Object)this.cstree2.getSubtreeRootNodesTree2().get(1), (Object)this.t4n10);
        BottomUpMaximumSubtreeTest.assertSame((Object)this.cstree2.getSubtreeRootNodesTree2().get(2), (Object)this.t4n7);
        HashMap<TreeNode, TreeNode> hashMap = null;
        try {
            hashMap = this.cstree2.mapTrees(this.cstree2.getSubtreeRootNodesTree1().get(0), this.cstree2.getSubtreeRootNodesTree2().get(0));
        }
        catch (InvalidElementException invalidElementException) {
            BottomUpMaximumSubtreeTest.fail();
        }
        BottomUpMaximumSubtreeTest.assertNotNull(hashMap);
        BottomUpMaximumSubtreeTest.assertNotNull(hashMap.get(this.t3n3));
        BottomUpMaximumSubtreeTest.assertSame(hashMap.get(this.t3n3), (Object)this.t4n3);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t3n1));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t3n1), (Object)this.t4n1);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t3n2));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t3n2), (Object)this.t4n2);
        hashMap = null;
        try {
            hashMap = this.cstree2.mapTrees(this.cstree2.getSubtreeRootNodesTree1().get(0), this.cstree2.getSubtreeRootNodesTree2().get(1));
        }
        catch (InvalidElementException invalidElementException) {
            BottomUpMaximumSubtreeTest.fail();
        }
        BottomUpMaximumSubtreeTest.assertNotNull(hashMap);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t3n3));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t3n3), (Object)this.t4n10);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t3n1));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t3n1), (Object)this.t4n8);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t3n2));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t3n2), (Object)this.t4n9);
        hashMap = null;
        try {
            hashMap = this.cstree2.mapTrees(this.cstree2.getSubtreeRootNodesTree1().get(0), this.cstree2.getSubtreeRootNodesTree2().get(2));
        }
        catch (InvalidElementException invalidElementException) {
            BottomUpMaximumSubtreeTest.fail();
        }
        BottomUpMaximumSubtreeTest.assertNotNull(hashMap);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t3n3));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t3n3), (Object)this.t4n7);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t3n1));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t3n1), (Object)this.t4n5);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)hashMap.get(this.t3n2));
        BottomUpMaximumSubtreeTest.assertSame((Object)hashMap.get(this.t3n2), (Object)this.t4n6);
    }

    public void testReuse() {
        BottomUpMaximumSubtree bottomUpMaximumSubtree = null;
        try {
            bottomUpMaximumSubtree = new BottomUpMaximumSubtree(new SimpleTreeAccessor(this.tree1), new SimpleTreeAccessor(this.tree2));
        }
        catch (NullPointerException nullPointerException) {
            BottomUpMaximumSubtreeTest.fail((String)"NullPointerException");
        }
        catch (InvalidElementException invalidElementException) {
            BottomUpMaximumSubtreeTest.fail((String)"TreeNodeTypeException");
        }
        BottomUpMaximumSubtreeTest.assertNotNull(bottomUpMaximumSubtree);
        BottomUpMaximumSubtreeTest.assertTrue((boolean)bottomUpMaximumSubtree.calculate());
        BottomUpMaximumSubtreeTest.assertTrue((boolean)bottomUpMaximumSubtree.isCalculated());
        BottomUpMaximumSubtreeTest.assertEquals((int)bottomUpMaximumSubtree.getSubtreeRootNodesTree1().size(), (int)this.cstree1.getSubtreeRootNodesTree1().size());
        BottomUpMaximumSubtreeTest.assertEquals((int)bottomUpMaximumSubtree.getSubtreeRootNodesTree2().size(), (int)this.cstree1.getSubtreeRootNodesTree2().size());
        for (ITreeNode iTreeNode : bottomUpMaximumSubtree.getSubtreeRootNodesTree1()) {
            BottomUpMaximumSubtreeTest.assertTrue((boolean)this.cstree1.getSubtreeRootNodesTree1().contains(iTreeNode));
            for (ITreeNode iTreeNode2 : bottomUpMaximumSubtree.getSubtreeRootNodesTree2()) {
                BottomUpMaximumSubtreeTest.assertTrue((boolean)this.cstree1.getSubtreeRootNodesTree2().contains(iTreeNode2));
                HashMap<TreeNode, TreeNode> hashMap = null;
                try {
                    hashMap = bottomUpMaximumSubtree.mapTrees(iTreeNode, iTreeNode2);
                }
                catch (InvalidElementException invalidElementException) {
                    BottomUpMaximumSubtreeTest.fail();
                }
                BottomUpMaximumSubtreeTest.assertNotNull(hashMap);
                HashMap<TreeNode, TreeNode> hashMap2 = null;
                try {
                    hashMap2 = this.cstree1.mapTrees(iTreeNode, iTreeNode2);
                }
                catch (InvalidElementException invalidElementException) {
                    BottomUpMaximumSubtreeTest.fail();
                }
                BottomUpMaximumSubtreeTest.assertNotNull(hashMap2);
                BottomUpMaximumSubtreeTest.assertEquals(hashMap, hashMap2);
            }
        }
    }

    public void testValiente() {
        Object object;
        Object object2;
        ListIterator<ITreeNode> listIterator;
        ITreeNode iTreeNode;
        BottomUpMaximumSubtreeTest.assertNotNull((Object)this.tree1);
        BottomUpMaximumSubtreeTest.assertNotNull((Object)this.tree2);
        HashMap<TreeNode, TreeNode> hashMap = null;
        try {
            hashMap = this.cstree1.mapTrees(this.cstree1.getSubtreeRootNodesTree1().get(0), this.cstree1.getSubtreeRootNodesTree2().get(0));
        }
        catch (InvalidElementException invalidElementException) {
            BottomUpMaximumSubtreeTest.fail();
        }
        BottomUpMaximumSubtreeTest.assertNotNull(hashMap);
        boolean bl = false;
        List<ITreeNode> list = null;
        try {
            list = TreeUtil.enumerationToList(this.tree1.postorderEnumeration());
        }
        catch (InvalidElementException invalidElementException) {
            BottomUpMaximumSubtreeTest.fail((String)"TreeNodeTypeException");
        }
        BottomUpMaximumSubtreeTest.assertNotNull(list);
        List<ITreeNode> list2 = null;
        try {
            list2 = TreeUtil.enumerationToList(this.tree2.postorderEnumeration());
        }
        catch (InvalidElementException invalidElementException) {
            BottomUpMaximumSubtreeTest.fail((String)"TreeNodeTypeException");
        }
        BottomUpMaximumSubtreeTest.assertNotNull(list2);
        ListIterator<ITreeNode> listIterator2 = list.listIterator();
        while (listIterator2.hasNext()) {
            iTreeNode = listIterator2.next();
            BottomUpMaximumSubtreeTest.assertNotNull((Object)iTreeNode);
            if (hashMap.get(iTreeNode) == null) continue;
            listIterator = list2.listIterator();
            while (listIterator.hasNext()) {
                object2 = listIterator.next();
                BottomUpMaximumSubtreeTest.assertNotNull((Object)object2);
                if (iTreeNode.equals(object2) || !hashMap.get(iTreeNode).equals(hashMap.get(object2))) continue;
                BottomUpMaximumSubtreeTest.fail((String)"Error in subtree isomorphism matching");
            }
            listIterator = list2.listIterator();
            while (listIterator.hasNext()) {
                object2 = listIterator.next();
                BottomUpMaximumSubtreeTest.assertNotNull((Object)object2);
                if (iTreeNode.isRoot() || object2.isRoot()) continue;
                BottomUpMaximumSubtreeTest.assertNotNull((Object)iTreeNode.getParent());
                BottomUpMaximumSubtreeTest.assertNotNull((Object)object2.getParent());
                if (hashMap.get(iTreeNode.getParent()) == null || !hashMap.get(iTreeNode.getParent()).equals(object2.getParent())) continue;
                bl = false;
                object = null;
                try {
                    object = TreeUtil.enumerationToList(object2.getParent().children());
                }
                catch (InvalidElementException invalidElementException) {
                    BottomUpMaximumSubtreeTest.fail((String)"TreeNodeTypeException");
                }
                BottomUpMaximumSubtreeTest.assertNotNull((Object)object);
                ListIterator listIterator3 = object.listIterator();
                while (listIterator3.hasNext()) {
                    ITreeNode iTreeNode2 = (ITreeNode)listIterator3.next();
                    if (!hashMap.get(iTreeNode).equals(iTreeNode2)) continue;
                    bl = true;
                }
                if (bl) continue;
                BottomUpMaximumSubtreeTest.fail((String)"Error in subtree isomorphism matching");
            }
        }
        listIterator2 = list.listIterator();
        iTreeNode = this.cstree1.getSubtreeRootNodesTree1().get(0);
        while (listIterator2.hasNext()) {
            listIterator = listIterator2.next();
            object2 = list2.listIterator();
            while (object2.hasNext()) {
                object = (ITreeNode)object2.next();
                if (!this.cstree1.getEquivalenceClassTree1().get(listIterator).equals(this.cstree1.getEquivalenceClassTree2().get(object)) || this.cstree1.getSizeTree1().get(listIterator) <= this.cstree1.getSizeTree1().get(iTreeNode)) continue;
                BottomUpMaximumSubtreeTest.fail((String)"Error in subtree isomorphism matching");
            }
        }
    }

    public void testBottomUpFamixAccessor() {
        FAMIXInstance fAMIXInstance = TreeAccessorTest.generateFamixModel();
        FamixTreeAccessor famixTreeAccessor = new FamixTreeAccessor(fAMIXInstance);
        FAMIXInstance fAMIXInstance2 = TreeAccessorTest.generateFamixModel();
        FamixTreeAccessor famixTreeAccessor2 = new FamixTreeAccessor(fAMIXInstance2);
        BottomUpMaximumSubtree bottomUpMaximumSubtree = null;
        try {
            bottomUpMaximumSubtree = new BottomUpMaximumSubtree(famixTreeAccessor, famixTreeAccessor2, new AlwaysTrueTreeNodeComparator(), true, false);
        }
        catch (NullPointerException nullPointerException) {
            BottomUpMaximumSubtreeTest.fail();
        }
        catch (InvalidElementException invalidElementException) {
            BottomUpMaximumSubtreeTest.fail();
        }
        BottomUpMaximumSubtreeTest.assertNotNull(bottomUpMaximumSubtree);
        BottomUpMaximumSubtreeTest.assertTrue((boolean)bottomUpMaximumSubtree.calculate());
        BottomUpMaximumSubtreeTest.assertTrue((boolean)bottomUpMaximumSubtree.isCalculated());
        BottomUpMaximumSubtreeTest.assertEquals((Object)bottomUpMaximumSubtree.getSimilarity(), (Object)new Double(1.0));
    }

    private TreeNode generateSampleT3() {
        this.t3n1 = new TreeNode(new String("t3n1"));
        this.t3n2 = new TreeNode(new String("t3n2"));
        this.t3n3 = new TreeNode(new String("t3n3"));
        this.t3n3.add(this.t3n1);
        this.t3n3.add(this.t3n2);
        return this.t3n3;
    }

    private TreeNode generateSampleT4() {
        this.t4n1 = new TreeNode(new String("t4n1"));
        this.t4n2 = new TreeNode(new String("t4n2"));
        this.t4n3 = new TreeNode(new String("t4n3"));
        this.t4n4 = new TreeNode(new String("t4n4"));
        this.t4n5 = new TreeNode(new String("t4n5"));
        this.t4n6 = new TreeNode(new String("t4n6"));
        this.t4n7 = new TreeNode(new String("t4n7"));
        this.t4n8 = new TreeNode(new String("t4n8"));
        this.t4n9 = new TreeNode(new String("t4n9"));
        this.t4n10 = new TreeNode(new String("t4n10"));
        this.t4n11 = new TreeNode(new String("t4n11"));
        this.t4n12 = new TreeNode(new String("t4n12"));
        this.t4n13 = new TreeNode(new String("t4n13"));
        this.t4n3.add(this.t4n1);
        this.t4n3.add(this.t4n2);
        this.t4n4.add(this.t4n3);
        this.t4n7.add(this.t4n5);
        this.t4n7.add(this.t4n6);
        this.t4n10.add(this.t4n8);
        this.t4n10.add(this.t4n9);
        this.t4n12.add(this.t4n7);
        this.t4n12.add(this.t4n10);
        this.t4n12.add(this.t4n11);
        this.t4n13.add(this.t4n4);
        this.t4n13.add(this.t4n12);
        return this.t4n13;
    }
}

