/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.it;

import com.hp.hpl.jena.ontology.OntModelSpec;
import java.io.File;
import junit.framework.TestCase;
import simpack.accessor.graph.JenaOntologyAccessor;
import simpack.exception.InvalidElementException;
import simpack.measure.it.Resnik;
import simpack.util.graph.GraphNode;

public class ResnikOntologyTest
extends TestCase {
    private String SUMO_OntologyURI = "http://127.0.0.1/ontology/simplified_sumo.owl";
    private String SUMO_OntologyBaseURI = "http://127.0.0.1/ontology/simplified_sumo.owl#";
    private String SUMO_OntologyRootURI = "http://127.0.0.1/ontology/simplified_sumo.owl#SUMORoot";
    private String altOntologyURL = "file:ontology" + File.separator + "simplified_sumo.owl";
    private String ontClassA = "http://127.0.0.1/ontology/simplified_sumo.owl#Shrimp";
    private String ontClassB = "http://127.0.0.1/ontology/simplified_sumo.owl#Wine";
    private String ontClassC = "http://lsdis.cs.uga.edu/proj/semdis/testbed/#Politician";
    private String ontClassD = "http://127.0.0.1/ontology/simplified_sumo.owl#Shellfish";
    private String ontClassE = "http://127.0.0.1/ontology/simplified_sumo.owl#Entity";
    private String ontClassF = "http://127.0.0.1/ontology/simplified_sumo.owl#DualObjectProcess";
    private String ontClassG = "http://127.0.0.1/ontology/simplified_sumo.owl#Meat";
    private OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM_RDFS_INF;

    public void testCalculateSimilarity() {
        Resnik resnik = null;
        try {
            resnik = new Resnik(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassB));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ResnikOntologyTest.assertNotNull(resnik);
        ResnikOntologyTest.assertTrue((boolean)resnik.calculate());
        ResnikOntologyTest.assertTrue((boolean)resnik.isCalculated());
        Double d = new Double(-1.0 * Math.log(0.15702479338842976));
        ResnikOntologyTest.assertEquals((Object)resnik.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityInvalidClassName() {
        Resnik resnik = null;
        try {
            resnik = new Resnik(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassC));
            ResnikOntologyTest.fail((String)"Should raise an InvalidNodException");
        }
        catch (InvalidElementException invalidElementException) {
            ResnikOntologyTest.assertTrue((boolean)true);
        }
    }

    public void testCalculateSimilaritySameClass() {
        Resnik resnik = null;
        try {
            resnik = new Resnik(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassA));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ResnikOntologyTest.assertNotNull(resnik);
        ResnikOntologyTest.assertTrue((boolean)resnik.calculate());
        ResnikOntologyTest.assertTrue((boolean)resnik.isCalculated());
        Double d = new Double(-1.0 * Math.log(0.024793388429752067));
        ResnikOntologyTest.assertEquals((Object)resnik.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityOneIsParentOfOther() {
        Resnik resnik = null;
        try {
            resnik = new Resnik(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassD));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ResnikOntologyTest.assertNotNull(resnik);
        ResnikOntologyTest.assertTrue((boolean)resnik.calculate());
        ResnikOntologyTest.assertTrue((boolean)resnik.isCalculated());
        Double d = new Double(-1.0 * Math.log(0.024793388429752067));
        ResnikOntologyTest.assertEquals((Object)resnik.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityOneIsAncestorOfOther() {
        Resnik resnik = null;
        try {
            resnik = new Resnik(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassG));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ResnikOntologyTest.assertNotNull(resnik);
        ResnikOntologyTest.assertTrue((boolean)resnik.calculate());
        ResnikOntologyTest.assertTrue((boolean)resnik.isCalculated());
        Double d = new Double(-1.0 * Math.log(0.11570247933884298));
        ResnikOntologyTest.assertEquals((Object)resnik.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityMRCAIsRootOfOntology() {
        Resnik resnik = null;
        try {
            resnik = new Resnik(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassE), new GraphNode(this.ontClassF));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ResnikOntologyTest.assertNotNull(resnik);
        ResnikOntologyTest.assertTrue((boolean)resnik.calculate());
        ResnikOntologyTest.assertTrue((boolean)resnik.isCalculated());
        Double d = new Double(-1.0 * Math.log(1.0));
        ResnikOntologyTest.assertEquals((Object)resnik.getSimilarity(), (Object)d);
    }
}

