/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.graph;

import junit.framework.TestCase;
import org.apache.log4j.Logger;
import simpack.accessor.graph.SimpleGraphAccessor;
import simpack.api.IGraphAccessor;
import simpack.measure.graph.MaxGraphIsoCoveringValiente;
import simpack.util.graph.Clique;
import simpack.util.graph.GraphNode;

public class MaxGraphIsoCoveringValienteTest
extends TestCase {
    public static Logger logger = Logger.getLogger(MaxGraphIsoCoveringValienteTest.class);
    private IGraphAccessor graph1;
    private IGraphAccessor graph2;
    private MaxGraphIsoCoveringValiente calc1;

    protected void setUp() throws Exception {
        this.graph1 = this.generateSampleG1();
        this.graph2 = this.generateSampleG2();
        MaxGraphIsoCoveringValienteTest.assertNotNull((Object)this.graph1);
        MaxGraphIsoCoveringValienteTest.assertNotNull((Object)this.graph2);
    }

    public void testSampleGraph() {
        this.calc1 = new MaxGraphIsoCoveringValiente(this.graph1, this.graph2, 1, MaxGraphIsoCoveringValiente.DEFAULT_STRUCTURE_WEIGHT, MaxGraphIsoCoveringValiente.DEFAULT_LABEL_WEIGHT, MaxGraphIsoCoveringValiente.DEFAULT_DENOMINATOR, MaxGraphIsoCoveringValiente.DEFAULT_GRAPH_TO_COVER, MaxGraphIsoCoveringValiente.DEFAULT_COVERAGE_STYLE);
        MaxGraphIsoCoveringValienteTest.assertTrue((boolean)this.calc1.calculate());
        MaxGraphIsoCoveringValienteTest.assertTrue((boolean)this.calc1.isCalculated());
        if (logger.isDebugEnabled()) {
            for (Clique clique : this.calc1.getCovering()) {
                System.out.println("Covering " + clique.getClique().toString() + " " + clique.getSimilarity());
            }
        }
        MaxGraphIsoCoveringValienteTest.assertEquals((Object)this.calc1.getSimilarity(), (Object)(-3.0 / (double)this.graph1.size() + 1.0));
    }

    public void test2SampleGraph() {
        this.calc1 = new MaxGraphIsoCoveringValiente(this.graph1, this.graph2, 1, MaxGraphIsoCoveringValiente.DEFAULT_STRUCTURE_WEIGHT, MaxGraphIsoCoveringValiente.DEFAULT_LABEL_WEIGHT, MaxGraphIsoCoveringValiente.DEFAULT_DENOMINATOR, MaxGraphIsoCoveringValiente.DEFAULT_GRAPH_TO_COVER, true);
        MaxGraphIsoCoveringValienteTest.assertTrue((boolean)this.calc1.calculate());
        MaxGraphIsoCoveringValienteTest.assertTrue((boolean)this.calc1.isCalculated());
        if (logger.isDebugEnabled()) {
            for (Clique clique : this.calc1.getCovering()) {
                System.out.println("Both Covering " + clique.getClique().toString() + " " + clique.getSimilarity());
            }
        }
        MaxGraphIsoCoveringValienteTest.assertEquals((Object)this.calc1.getSimilarity(), (Object)(-2.0 / (double)this.graph1.size() + 1.0));
    }

    private IGraphAccessor generateSampleG1() {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        GraphNode graphNode = new GraphNode("1");
        GraphNode graphNode2 = new GraphNode("2");
        GraphNode graphNode3 = new GraphNode("3");
        GraphNode graphNode4 = new GraphNode("4");
        GraphNode graphNode5 = new GraphNode("5");
        GraphNode graphNode6 = new GraphNode("6");
        simpleGraphAccessor.setEdge(graphNode, graphNode2);
        simpleGraphAccessor.setEdge(graphNode, graphNode3);
        simpleGraphAccessor.setEdge(graphNode2, graphNode4);
        simpleGraphAccessor.setEdge(graphNode3, graphNode4);
        simpleGraphAccessor.setEdge(graphNode4, graphNode5);
        simpleGraphAccessor.setEdge(graphNode4, graphNode6);
        simpleGraphAccessor.setEdge(graphNode5, graphNode6);
        return simpleGraphAccessor;
    }

    private IGraphAccessor generateSampleG2() {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        GraphNode graphNode = new GraphNode("1");
        GraphNode graphNode2 = new GraphNode("2");
        GraphNode graphNode3 = new GraphNode("3");
        GraphNode graphNode4 = new GraphNode("4");
        simpleGraphAccessor.setEdge(graphNode, graphNode2);
        simpleGraphAccessor.setEdge(graphNode, graphNode3);
        simpleGraphAccessor.setEdge(graphNode3, graphNode4);
        return simpleGraphAccessor;
    }
}

