/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.graph;

import junit.framework.TestCase;
import simpack.accessor.graph.SimpleGraphAccessor;
import simpack.api.IGraphAccessor;
import simpack.measure.graph.SubgraphIsomorphism;
import simpack.util.graph.GraphNode;

public class ConstructedSubgraphIsomorphismTest
extends TestCase {
    private IGraphAccessor graph1;
    private IGraphAccessor graph2a;
    private IGraphAccessor graph2b;
    private IGraphAccessor graph2c;
    private IGraphAccessor graph2d;
    private IGraphAccessor graph3a;
    private IGraphAccessor graph3b;
    private IGraphAccessor graph3c;
    private IGraphAccessor graph3d;
    private IGraphAccessor graph4;
    private IGraphAccessor graph5;
    private SubgraphIsomorphism calc1;
    private SubgraphIsomorphism calc2;
    private SubgraphIsomorphism calc3;
    private SubgraphIsomorphism calc4;
    private SubgraphIsomorphism calc5;
    private SubgraphIsomorphism calc6;
    private SubgraphIsomorphism calc7;
    private SubgraphIsomorphism calc8;
    private SubgraphIsomorphism calc9;

    protected void setUp() throws Exception {
        this.graph1 = this.generateSampleG1();
        this.graph2a = this.generateSampleG2("normal");
        this.graph2b = this.generateSampleG2("rename");
        this.graph2c = this.generateSampleG2("remove_node");
        this.graph2d = this.generateSampleG2("remove_edge");
        this.graph3a = this.generateSampleG3("normal");
        this.graph3b = this.generateSampleG3("rename");
        this.graph3c = this.generateSampleG3("remove_node");
        this.graph3d = this.generateSampleG3("remove_edge");
        this.graph4 = this.generateSampleG4();
        this.graph5 = this.generateSampleG5();
        ConstructedSubgraphIsomorphismTest.assertNotNull((Object)this.graph1);
        ConstructedSubgraphIsomorphismTest.assertNotNull((Object)this.graph2a);
        ConstructedSubgraphIsomorphismTest.assertNotNull((Object)this.graph2b);
        ConstructedSubgraphIsomorphismTest.assertNotNull((Object)this.graph2c);
        ConstructedSubgraphIsomorphismTest.assertNotNull((Object)this.graph2d);
        ConstructedSubgraphIsomorphismTest.assertNotNull((Object)this.graph3a);
        ConstructedSubgraphIsomorphismTest.assertNotNull((Object)this.graph3b);
        ConstructedSubgraphIsomorphismTest.assertNotNull((Object)this.graph3c);
        ConstructedSubgraphIsomorphismTest.assertNotNull((Object)this.graph3d);
        ConstructedSubgraphIsomorphismTest.assertNotNull((Object)this.graph4);
        ConstructedSubgraphIsomorphismTest.assertNotNull((Object)this.graph5);
        this.calc1 = new SubgraphIsomorphism(this.graph1, this.graph2a);
        this.calc2 = new SubgraphIsomorphism(this.graph1, this.graph2b);
        this.calc3 = new SubgraphIsomorphism(this.graph1, this.graph2c);
        this.calc4 = new SubgraphIsomorphism(this.graph1, this.graph3a);
        this.calc5 = new SubgraphIsomorphism(this.graph1, this.graph3b);
        this.calc6 = new SubgraphIsomorphism(this.graph1, this.graph3c);
        this.calc7 = new SubgraphIsomorphism(this.graph1, this.graph2d);
        this.calc8 = new SubgraphIsomorphism(this.graph1, this.graph3d);
        this.calc9 = new SubgraphIsomorphism(this.graph4, this.graph5);
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc1.calculate());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc1.isCalculated());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc2.calculate());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc2.isCalculated());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc3.calculate());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc3.isCalculated());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc4.calculate());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc4.isCalculated());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc5.calculate());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc5.isCalculated());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc6.calculate());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc6.isCalculated());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc7.calculate());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc7.isCalculated());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc8.calculate());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc8.isCalculated());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc9.calculate());
        ConstructedSubgraphIsomorphismTest.assertTrue((boolean)this.calc9.isCalculated());
    }

    public void testSampleGraph() {
        ConstructedSubgraphIsomorphismTest.assertEquals((Object)this.calc1.getSimilarity(), (Object)0.4642857142857143);
        ConstructedSubgraphIsomorphismTest.assertEquals((Object)this.calc2.getSimilarity(), (Object)0.5);
        ConstructedSubgraphIsomorphismTest.assertEquals((Object)this.calc3.getSimilarity(), (Object)0.4629629629629629);
        ConstructedSubgraphIsomorphismTest.assertEquals((Object)this.calc4.getSimilarity(), (Object)1.0);
        ConstructedSubgraphIsomorphismTest.assertEquals((Object)this.calc5.getSimilarity(), (Object)0.9852941176470589);
        ConstructedSubgraphIsomorphismTest.assertEquals((Object)this.calc6.getSimilarity(), (Object)0.9545454545454546);
        ConstructedSubgraphIsomorphismTest.assertEquals((Object)this.calc7.getSimilarity(), (Object)0.42592592592592593);
        ConstructedSubgraphIsomorphismTest.assertEquals((Object)this.calc8.getSimilarity(), (Object)0.8939393939393939);
    }

    private IGraphAccessor generateSampleG1() {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        GraphNode graphNode = new GraphNode("1");
        GraphNode graphNode2 = new GraphNode("2");
        GraphNode graphNode3 = new GraphNode("3");
        GraphNode graphNode4 = new GraphNode("4");
        GraphNode graphNode5 = new GraphNode("5");
        GraphNode graphNode6 = new GraphNode("6");
        GraphNode graphNode7 = new GraphNode("7");
        GraphNode graphNode8 = new GraphNode("8");
        GraphNode graphNode9 = new GraphNode("9");
        GraphNode graphNode10 = new GraphNode("10");
        GraphNode graphNode11 = new GraphNode("11");
        GraphNode graphNode12 = new GraphNode("12");
        GraphNode graphNode13 = new GraphNode("13");
        GraphNode graphNode14 = new GraphNode("14");
        GraphNode graphNode15 = new GraphNode("15");
        GraphNode graphNode16 = new GraphNode("16");
        GraphNode graphNode17 = new GraphNode("17");
        simpleGraphAccessor.setEdge(graphNode, graphNode2);
        simpleGraphAccessor.setEdge(graphNode, graphNode3);
        simpleGraphAccessor.setEdge(graphNode2, graphNode4);
        simpleGraphAccessor.setEdge(graphNode2, graphNode5);
        simpleGraphAccessor.setEdge(graphNode2, graphNode6);
        simpleGraphAccessor.setEdge(graphNode3, graphNode6);
        simpleGraphAccessor.setEdge(graphNode3, graphNode7);
        simpleGraphAccessor.setEdge(graphNode4, graphNode8);
        simpleGraphAccessor.setEdge(graphNode6, graphNode9);
        simpleGraphAccessor.setEdge(graphNode7, graphNode10);
        simpleGraphAccessor.setEdge(graphNode7, graphNode11);
        simpleGraphAccessor.setEdge(graphNode7, graphNode12);
        simpleGraphAccessor.setEdge(graphNode8, graphNode13);
        simpleGraphAccessor.setEdge(graphNode9, graphNode13);
        simpleGraphAccessor.setEdge(graphNode9, graphNode14);
        simpleGraphAccessor.setEdge(graphNode9, graphNode15);
        simpleGraphAccessor.setEdge(graphNode10, graphNode15);
        simpleGraphAccessor.setEdge(graphNode10, graphNode16);
        simpleGraphAccessor.setEdge(graphNode11, graphNode16);
        simpleGraphAccessor.setEdge(graphNode12, graphNode17);
        simpleGraphAccessor.setEdge(graphNode17, graphNode16);
        return simpleGraphAccessor;
    }

    private IGraphAccessor generateSampleG2(String string) {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        GraphNode graphNode = new GraphNode("1");
        GraphNode graphNode2 = new GraphNode("5");
        GraphNode graphNode3 = new GraphNode("3");
        GraphNode graphNode4 = new GraphNode("10");
        GraphNode graphNode5 = new GraphNode("11");
        GraphNode graphNode6 = new GraphNode("12");
        GraphNode graphNode7 = new GraphNode("17");
        GraphNode graphNode8 = new GraphNode("8");
        GraphNode graphNode9 = new GraphNode("16");
        graphNode9 = string.equals("rename") || string.equals("remove_node") || string.equals("remove_edge") ? new GraphNode("16") : new GraphNode("4");
        GraphNode graphNode10 = new GraphNode("9");
        if (!string.equals("remove_node") && !string.equals("remove_edge")) {
            GraphNode graphNode11 = new GraphNode("2");
            simpleGraphAccessor.setEdge(graphNode3, graphNode11);
            simpleGraphAccessor.setEdge(graphNode11, graphNode8);
        }
        if (!string.equals("remove_edge")) {
            simpleGraphAccessor.setEdge(graphNode6, graphNode7);
        }
        simpleGraphAccessor.setEdge(graphNode, graphNode2);
        simpleGraphAccessor.setEdge(graphNode, graphNode3);
        simpleGraphAccessor.setEdge(graphNode2, graphNode4);
        simpleGraphAccessor.setEdge(graphNode2, graphNode5);
        simpleGraphAccessor.setEdge(graphNode2, graphNode6);
        simpleGraphAccessor.setEdge(graphNode3, graphNode6);
        simpleGraphAccessor.setEdge(graphNode4, graphNode9);
        simpleGraphAccessor.setEdge(graphNode5, graphNode9);
        simpleGraphAccessor.setEdge(graphNode7, graphNode9);
        simpleGraphAccessor.setEdge(graphNode7, graphNode10);
        simpleGraphAccessor.setEdge(graphNode8, graphNode10);
        return simpleGraphAccessor;
    }

    private IGraphAccessor generateSampleG3(String string) {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        GraphNode graphNode = new GraphNode("1");
        GraphNode graphNode2 = new GraphNode("2");
        GraphNode graphNode3 = new GraphNode("3");
        GraphNode graphNode4 = new GraphNode("4");
        GraphNode graphNode5 = new GraphNode("5");
        GraphNode graphNode6 = new GraphNode("6");
        GraphNode graphNode7 = new GraphNode("7");
        GraphNode graphNode8 = new GraphNode("8");
        GraphNode graphNode9 = new GraphNode("9");
        GraphNode graphNode10 = new GraphNode("10");
        GraphNode graphNode11 = new GraphNode("11");
        GraphNode graphNode12 = new GraphNode("13");
        GraphNode graphNode13 = new GraphNode("14");
        GraphNode graphNode14 = new GraphNode("15");
        GraphNode graphNode15 = new GraphNode("16");
        GraphNode graphNode16 = new GraphNode("17");
        GraphNode graphNode17 = new GraphNode("18");
        graphNode17 = string.equals("rename") || string.equals("remove_node") || string.equals("remove_edge") ? new GraphNode("18") : new GraphNode("12");
        if (!string.equals("remove_node") && !string.equals("remove_edge")) {
            graphNode6 = new GraphNode("6");
            simpleGraphAccessor.setEdge(graphNode2, graphNode6);
            simpleGraphAccessor.setEdge(graphNode3, graphNode6);
            simpleGraphAccessor.setEdge(graphNode6, graphNode9);
        }
        if (!string.equals("remove_edge")) {
            simpleGraphAccessor.setEdge(graphNode3, graphNode7);
        }
        simpleGraphAccessor.setEdge(graphNode, graphNode2);
        simpleGraphAccessor.setEdge(graphNode, graphNode3);
        simpleGraphAccessor.setEdge(graphNode2, graphNode4);
        simpleGraphAccessor.setEdge(graphNode2, graphNode5);
        simpleGraphAccessor.setEdge(graphNode4, graphNode8);
        simpleGraphAccessor.setEdge(graphNode7, graphNode10);
        simpleGraphAccessor.setEdge(graphNode7, graphNode11);
        simpleGraphAccessor.setEdge(graphNode7, graphNode17);
        simpleGraphAccessor.setEdge(graphNode8, graphNode12);
        simpleGraphAccessor.setEdge(graphNode9, graphNode12);
        simpleGraphAccessor.setEdge(graphNode9, graphNode13);
        simpleGraphAccessor.setEdge(graphNode9, graphNode14);
        simpleGraphAccessor.setEdge(graphNode10, graphNode14);
        simpleGraphAccessor.setEdge(graphNode10, graphNode15);
        simpleGraphAccessor.setEdge(graphNode11, graphNode15);
        simpleGraphAccessor.setEdge(graphNode17, graphNode16);
        simpleGraphAccessor.setEdge(graphNode16, graphNode15);
        return simpleGraphAccessor;
    }

    private IGraphAccessor generateSampleG4() {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        GraphNode graphNode = new GraphNode("A");
        GraphNode graphNode2 = new GraphNode("B");
        GraphNode graphNode3 = new GraphNode("C");
        GraphNode graphNode4 = new GraphNode("D");
        GraphNode graphNode5 = new GraphNode("E");
        GraphNode graphNode6 = new GraphNode("F");
        GraphNode graphNode7 = new GraphNode("G");
        GraphNode graphNode8 = new GraphNode("H");
        GraphNode graphNode9 = new GraphNode("I");
        GraphNode graphNode10 = new GraphNode("J");
        GraphNode graphNode11 = new GraphNode("K");
        simpleGraphAccessor.setEdge(graphNode, graphNode2);
        simpleGraphAccessor.setEdge(graphNode, graphNode3);
        simpleGraphAccessor.setEdge(graphNode2, graphNode4);
        simpleGraphAccessor.setEdge(graphNode2, graphNode5);
        simpleGraphAccessor.setEdge(graphNode2, graphNode6);
        simpleGraphAccessor.setEdge(graphNode3, graphNode6);
        simpleGraphAccessor.setEdge(graphNode3, graphNode7);
        simpleGraphAccessor.setEdge(graphNode6, graphNode8);
        simpleGraphAccessor.setEdge(graphNode6, graphNode9);
        simpleGraphAccessor.setEdge(graphNode6, graphNode10);
        simpleGraphAccessor.setEdge(graphNode6, graphNode11);
        simpleGraphAccessor.setEdge(graphNode7, graphNode8);
        simpleGraphAccessor.setEdge(graphNode7, graphNode9);
        simpleGraphAccessor.setEdge(graphNode7, graphNode10);
        simpleGraphAccessor.setEdge(graphNode7, graphNode11);
        return simpleGraphAccessor;
    }

    private IGraphAccessor generateSampleG5() {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        GraphNode graphNode = new GraphNode("a");
        GraphNode graphNode2 = new GraphNode("b");
        GraphNode graphNode3 = new GraphNode("c");
        GraphNode graphNode4 = new GraphNode("d");
        GraphNode graphNode5 = new GraphNode("e");
        GraphNode graphNode6 = new GraphNode("f");
        GraphNode graphNode7 = new GraphNode("g");
        GraphNode graphNode8 = new GraphNode("h");
        GraphNode graphNode9 = new GraphNode("i");
        GraphNode graphNode10 = new GraphNode("j");
        GraphNode graphNode11 = new GraphNode("k");
        GraphNode graphNode12 = new GraphNode("l");
        simpleGraphAccessor.setEdge(graphNode, graphNode2);
        simpleGraphAccessor.setEdge(graphNode, graphNode3);
        simpleGraphAccessor.setEdge(graphNode, graphNode4);
        simpleGraphAccessor.setEdge(graphNode, graphNode5);
        simpleGraphAccessor.setEdge(graphNode2, graphNode6);
        simpleGraphAccessor.setEdge(graphNode2, graphNode7);
        simpleGraphAccessor.setEdge(graphNode2, graphNode8);
        simpleGraphAccessor.setEdge(graphNode3, graphNode9);
        simpleGraphAccessor.setEdge(graphNode4, graphNode12);
        simpleGraphAccessor.setEdge(graphNode5, graphNode10);
        simpleGraphAccessor.setEdge(graphNode5, graphNode11);
        return simpleGraphAccessor;
    }
}

