/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.external.secondstring;

import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.api.StringWrapper;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import simpack.measure.external.secondstring.TFIDF;

public class TFIDFTest
extends TestCase {
    private String str1;
    private String str2;
    private String str3;
    private List<StringWrapper> corpus;
    private TFIDF TFIDF;
    private double w_service;
    private double w_hotel;
    private double w_city;
    private double w_country;
    private double w_capital;
    private double w_locator;
    private double str1_normalizer;
    private double str2_normalizer;

    public void setUp() {
        this.str1 = "service hotel city locator";
        this.str2 = "service country capital";
        this.str3 = "country hospital finder";
        this.corpus = new ArrayList<StringWrapper>();
        String[] stringArray = new String[]{this.str1, this.str2, this.str3};
        for (int i = 0; i < stringArray.length; ++i) {
            this.corpus.add((StringWrapper)new BasicStringWrapper(stringArray[i]));
        }
        this.w_service = Math.log(2.0) * Math.log(1.5);
        this.w_hotel = Math.log(2.0) * Math.log(3.0);
        this.w_city = Math.log(2.0) * Math.log(3.0);
        this.w_locator = Math.log(2.0) * Math.log(3.0);
        this.w_country = Math.log(2.0) * Math.log(1.5);
        this.w_capital = Math.log(2.0) * Math.log(3.0);
        this.str1_normalizer = Math.sqrt(this.w_service * this.w_service + this.w_hotel * this.w_hotel + this.w_city * this.w_city + this.w_locator * this.w_locator);
        this.str2_normalizer = Math.sqrt(this.w_service * this.w_service + this.w_country * this.w_country + this.w_capital * this.w_capital);
    }

    public void testCalculateSimilarity() {
        this.TFIDF = new TFIDF(this.str1, this.str1, this.corpus);
        TFIDFTest.assertNotNull((Object)this.TFIDF);
        TFIDFTest.assertTrue((boolean)this.TFIDF.calculate());
        TFIDFTest.assertTrue((boolean)this.TFIDF.isCalculated());
        TFIDFTest.assertEquals((Object)this.TFIDF.getSimilarity(), (Object)new Double(1.0));
    }

    public void testCalculateSimilarity2() {
        this.TFIDF = new TFIDF(this.str1, this.str2, this.corpus);
        TFIDFTest.assertNotNull((Object)this.TFIDF);
        TFIDFTest.assertTrue((boolean)this.TFIDF.calculate());
        TFIDFTest.assertTrue((boolean)this.TFIDF.isCalculated());
        double d = this.w_service / this.str1_normalizer * (this.w_service / this.str2_normalizer);
        TFIDFTest.assertEquals((Object)this.TFIDF.getSimilarity(), (Object)new Double(d));
    }
}

