/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.external.secondstring;

import com.wcohen.ss.api.Tokenizer;
import com.wcohen.ss.tokens.NGramTokenizer;
import com.wcohen.ss.tokens.SimpleTokenizer;
import junit.framework.TestCase;
import simpack.accessor.string.StringAccessor;
import simpack.measure.external.secondstring.DirichletJS;

public class DirichletJSTest
extends TestCase {
    public void testCalculationSimilarity() {
        DirichletJS dirichletJS = new DirichletJS(new StringAccessor("test"), new StringAccessor("test"));
        DirichletJSTest.assertNotNull((Object)dirichletJS);
        DirichletJSTest.assertTrue((boolean)dirichletJS.calculate());
        DirichletJSTest.assertTrue((boolean)dirichletJS.isCalculated());
        DirichletJSTest.assertEquals((Object)dirichletJS.getSimilarity(), (Object)Double.NaN);
        dirichletJS = new DirichletJS(new StringAccessor("test"), new StringAccessor("west"));
        DirichletJSTest.assertNotNull((Object)dirichletJS);
        DirichletJSTest.assertTrue((boolean)dirichletJS.calculate());
        DirichletJSTest.assertTrue((boolean)dirichletJS.isCalculated());
        DirichletJSTest.assertEquals((Object)dirichletJS.getSimilarity(), (Object)new Double(0.0));
    }

    public void testEmptyStrings() {
        DirichletJS dirichletJS = new DirichletJS(new StringAccessor(""), new StringAccessor("test"));
        DirichletJSTest.assertNotNull((Object)dirichletJS);
        DirichletJSTest.assertTrue((boolean)dirichletJS.calculate());
        DirichletJSTest.assertTrue((boolean)dirichletJS.isCalculated());
        DirichletJSTest.assertEquals((Object)dirichletJS.getSimilarity(), (Object)new Double(0.0));
        dirichletJS = new DirichletJS(new StringAccessor("test"), new StringAccessor(""));
        DirichletJSTest.assertNotNull((Object)dirichletJS);
        DirichletJSTest.assertTrue((boolean)dirichletJS.calculate());
        DirichletJSTest.assertTrue((boolean)dirichletJS.isCalculated());
        DirichletJSTest.assertEquals((Object)dirichletJS.getSimilarity(), (Object)new Double(0.0));
        dirichletJS = new DirichletJS(new StringAccessor(""), new StringAccessor(""));
        DirichletJSTest.assertNotNull((Object)dirichletJS);
        DirichletJSTest.assertTrue((boolean)dirichletJS.calculate());
        DirichletJSTest.assertTrue((boolean)dirichletJS.isCalculated());
        DirichletJSTest.assertEquals((Object)dirichletJS.getSimilarity(), (Object)new Double(0.0));
    }

    public void testCalculationSimilarityWithParameters() {
        DirichletJS dirichletJS = new DirichletJS(new StringAccessor("test"), new StringAccessor("test"), (Tokenizer)SimpleTokenizer.DEFAULT_TOKENIZER, 1.0);
        DirichletJSTest.assertNotNull((Object)dirichletJS);
        DirichletJSTest.assertTrue((boolean)dirichletJS.calculate());
        DirichletJSTest.assertTrue((boolean)dirichletJS.isCalculated());
        DirichletJSTest.assertEquals((Object)dirichletJS.getSimilarity(), (Object)Double.NaN);
        dirichletJS = new DirichletJS(new StringAccessor("test"), new StringAccessor("test"), (Tokenizer)NGramTokenizer.DEFAULT_TOKENIZER, 1.0);
        DirichletJSTest.assertNotNull((Object)dirichletJS);
        DirichletJSTest.assertTrue((boolean)dirichletJS.calculate());
        DirichletJSTest.assertTrue((boolean)dirichletJS.isCalculated());
        DirichletJSTest.assertEquals((Object)dirichletJS.getSimilarity(), (Object)Double.NaN);
        new DirichletJS(new StringAccessor("test"), new StringAccessor("test best"), (Tokenizer)NGramTokenizer.DEFAULT_TOKENIZER, 1.0);
        DirichletJSTest.assertNotNull((Object)dirichletJS);
        DirichletJSTest.assertTrue((boolean)dirichletJS.calculate());
        DirichletJSTest.assertTrue((boolean)dirichletJS.isCalculated());
        DirichletJSTest.assertEquals((Object)dirichletJS.getSimilarity(), (Object)Double.NaN);
    }
}

