/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.weightingscheme;

import com.wcohen.ss.BasicStringWrapperIterator;
import com.wcohen.ss.TFIDF;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.api.StringWrapperIterator;
import com.wcohen.ss.api.Tokenizer;
import com.wcohen.ss.tokens.SimpleTokenizer;
import java.util.List;
import simpack.api.impl.SimilarityMeasure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTFIDF
extends SimilarityMeasure {
    private TFIDF TFIDF;
    private String str1;
    private String str2;

    public StringTFIDF(List<StringWrapper> corpus, String str1, String str2) {
        this(corpus, str1, str2, (Tokenizer)SimpleTokenizer.DEFAULT_TOKENIZER);
    }

    public StringTFIDF(List<StringWrapper> corpus, String str1, String str2, Tokenizer tokenizer) {
        this.str1 = str1;
        this.str2 = str2;
        this.TFIDF = new TFIDF(tokenizer);
        BasicStringWrapperIterator iterator = new BasicStringWrapperIterator(corpus.iterator());
        this.TFIDF.train((StringWrapperIterator)iterator);
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        this.similarity = new Double(this.getSimilarity(this.str1, this.str2));
        this.setCalculated(true);
        return true;
    }

    private double getSimilarity(String str1, String str2) {
        StringWrapper w1 = this.TFIDF.prepare(str1);
        StringWrapper w2 = this.TFIDF.prepare(str2);
        double sim = this.TFIDF.score(w1, w2);
        return sim;
    }
}

