/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.weightingscheme;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.util.PriorityQueue;
import simpack.accessor.list.LuceneIndexAccessor;
import simpack.exception.InvalidElementException;
import simpack.exception.InvalidVectorSizeException;
import simpack.measure.vector.Cosine;
import simpack.measure.weightingscheme.AbstractTFIDF;
import simpack.util.Vector;
import simpack.util.corpus.Indexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneTFIDF
extends AbstractTFIDF {
    public static Logger logger = Logger.getLogger(LuceneTFIDF.class);
    private String d1;
    private String d2;
    private int id1;
    private int id2;
    private LuceneIndexAccessor indexAccessor;

    public LuceneTFIDF(LuceneIndexAccessor<String> indexAccessor, String d1, String d2) throws InvalidElementException {
        this.indexAccessor = indexAccessor;
        this.d1 = d1;
        this.d2 = d2;
        QueryParser qp = new QueryParser("url", Indexer.DEFAULT_ANALYZER);
        try {
            Hits hits = indexAccessor.getIndexSearcher().search(qp.parse(d1));
            if (hits.length() > 1) {
                throw new RuntimeException("Document name " + d1 + " not unique");
            }
            if (hits.length() == 0) {
                throw new InvalidElementException();
            }
            Document doc1 = hits.doc(0);
            this.id1 = hits.id(0);
            hits = indexAccessor.getIndexSearcher().search(qp.parse(d2));
            if (hits.length() > 1) {
                throw new RuntimeException("Document name " + d2 + " not unique");
            }
            if (hits.length() == 0) {
                throw new InvalidElementException();
            }
            Document doc2 = hits.doc(0);
            this.id2 = hits.id(0);
            if (logger.isInfoEnabled()) {
                LuceneTFIDF.getDocumentInfo(doc1);
                LuceneTFIDF.getDocumentInfo(doc2);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        this.similarity = new Double(this.getTFIDF(this.d1, this.d2));
        this.setCalculated(true);
        return true;
    }

    private double getTFIDF(String d1, String d2) {
        double score = 0.0;
        try {
            PriorityQueue queue1 = this.indexAccessor.retrieveTerms(this.id1);
            PriorityQueue queue2 = this.indexAccessor.retrieveTerms(this.id2);
            score = this.score(queue1, queue2);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return score;
    }

    private double score(PriorityQueue queue1, PriorityQueue queue2) {
        ArrayList<Double> list;
        double tfidf;
        String word;
        Object[] ar;
        Object cur;
        Vector v1 = new Vector();
        Vector v2 = new Vector();
        HashMap map = new HashMap();
        while ((cur = queue1.pop()) != null) {
            ar = (Object[])cur;
            word = (String)ar[0];
            tfidf = (Double)ar[2];
            if (map.containsKey(word)) {
                ((ArrayList)map.get(word)).add(tfidf);
                continue;
            }
            list = new ArrayList<Double>();
            list.add(tfidf);
            map.put(word, list);
        }
        while ((cur = queue2.pop()) != null) {
            ar = (Object[])cur;
            word = (String)ar[0];
            tfidf = (Double)ar[2];
            if (map.containsKey(word)) {
                ((ArrayList)map.get(word)).add(tfidf);
                continue;
            }
            list = new ArrayList();
            list.add(tfidf);
            map.put(word, list);
        }
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            if (((ArrayList)entry.getValue()).size() != 2) continue;
            logger.debug(entry);
            v1.add(((ArrayList)entry.getValue()).get(0));
            v2.add(((ArrayList)entry.getValue()).get(1));
        }
        try {
            return new Cosine(v1, v2).getSimilarity();
        }
        catch (InvalidVectorSizeException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private static void getDocumentInfo(Document d) {
        PrintStream o = System.out;
        o.println("url : " + d.get("url"));
        o.println("title : " + d.get("title"));
        o.println("contents : " + d.get("contents"));
        o.println();
    }
}

