/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.vector;

import simpack.api.impl.FeatureVectorSimilarityMeasure;
import simpack.exception.InvalidVectorSizeException;
import simpack.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pearson
extends FeatureVectorSimilarityMeasure {
    public Pearson() {
    }

    public Pearson(Vector<? extends Number> v1, Vector<? extends Number> v2) throws InvalidVectorSizeException {
        super(v1, v2);
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        double sumXY = 0.0;
        try {
            sumXY = this.v1.getDotProduct(this.v2);
        }
        catch (InvalidVectorSizeException e) {
            e.printStackTrace();
            return false;
        }
        double sumXsumY = this.v1.getNorm(1.0) * this.v2.getNorm(1.0);
        double sumX2 = Math.pow(this.v1.getNorm(2.0), 2.0);
        double sumX22 = Math.pow(this.v1.getNorm(1.0), 2.0);
        double sumY2 = Math.pow(this.v2.getNorm(2.0), 2.0);
        double sumY22 = Math.pow(this.v2.getNorm(1.0), 2.0);
        double N = this.v1.size();
        this.similarity = new Double(sumXY - sumXsumY / N) / Math.sqrt((sumX2 - sumX22 / N) * (sumY2 - sumY22 / N));
        this.setCalculated(true);
        return true;
    }
}

