/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.vector;

import simpack.api.impl.FeatureVectorSimilarityMeasure;
import simpack.exception.InvalidVectorSizeException;
import simpack.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jaccard
extends FeatureVectorSimilarityMeasure {
    public Jaccard() {
    }

    public Jaccard(Vector<? extends Number> v1, Vector<? extends Number> v2) throws InvalidVectorSizeException {
        super(v1, v2);
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        double A = 0.0;
        try {
            A = this.v1.getDotProduct(this.v2);
        }
        catch (InvalidVectorSizeException e) {
            e.printStackTrace();
            return false;
        }
        double B = Math.pow(this.v1.getNorm(2.0), 2.0);
        double C = Math.pow(this.v2.getNorm(2.0), 2.0);
        this.similarity = new Double(A / (B + C - A));
        this.setCalculated(true);
        return true;
    }
}

