/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.vector;

import simpack.api.IDistanceConversion;
import simpack.api.impl.FeatureVectorSimilarityMeasure;
import simpack.exception.InvalidVectorSizeException;
import simpack.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Euclidean
extends FeatureVectorSimilarityMeasure {
    private IDistanceConversion conversion = FeatureVectorSimilarityMeasure.CONVERSION;

    public Euclidean() {
    }

    public Euclidean(Vector<? extends Number> v1, Vector<? extends Number> v2, IDistanceConversion conversion) throws InvalidVectorSizeException {
        super(v1, v2);
        if (conversion != null) {
            this.conversion = conversion;
        }
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        try {
            double distance = this.v1.getEuclideanDistance(this.v2);
            this.similarity = new Double(this.conversion.convert(distance));
            this.setCalculated(true);
            return true;
        }
        catch (InvalidVectorSizeException e) {
            e.printStackTrace();
            return false;
        }
    }
}

