/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.vector;

import simpack.api.impl.FeatureVectorSimilarityMeasure;
import simpack.exception.InvalidVectorSizeException;
import simpack.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dice
extends FeatureVectorSimilarityMeasure {
    public Dice() {
    }

    public Dice(Vector<? extends Number> v1, Vector<? extends Number> v2) throws InvalidVectorSizeException {
        super(v1, v2);
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        double A = 0.0;
        try {
            A = this.v1.getDotProduct(this.v2);
        }
        catch (InvalidVectorSizeException e) {
            e.printStackTrace();
            return false;
        }
        double B = this.v1.getNorm(2.0);
        double C = this.v2.getNorm(2.0);
        this.similarity = new Double(2.0 * A / (Math.pow(B, 2.0) + Math.pow(C, 2.0)));
        this.setCalculated(true);
        return true;
    }
}

