/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.vector;

import java.util.Vector;
import org.apache.log4j.Logger;
import simpack.api.impl.FeatureVectorSimilarityMeasure;
import simpack.api.impl.SimilarityMeasure;
import simpack.exception.InvalidVectorSizeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alignment<E>
extends SimilarityMeasure {
    private static Logger logger = Logger.getLogger(Alignment.class);
    private Vector<E> v1;
    private Vector<E> v2;
    private Vector<E> v1Aligned;
    private Vector<E> v2Aligned;
    private simpack.util.Vector<Double> v1AlignedBinary;
    private simpack.util.Vector<Double> v2AlignedBinary;
    private FeatureVectorSimilarityMeasure m;

    public Alignment(Vector<E> v1, Vector<E> v2, FeatureVectorSimilarityMeasure m) {
        this.m = m;
        this.v1 = v1;
        this.v2 = v2;
        this.align();
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        try {
            this.m.setVector(this.v1AlignedBinary, this.v2AlignedBinary);
            if (this.m.calculate()) {
                this.setCalculated(true);
                this.similarity = new Double(this.m.getSimilarity());
                return this.m.isCalculated();
            }
            return false;
        }
        catch (InvalidVectorSizeException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void align() {
        Vector<E> t1 = new Vector<E>(this.v1.size());
        Vector<E> t12 = new Vector<E>(this.v1.size());
        Vector<E> t2 = new Vector<E>(this.v2.size());
        for (E element : this.v1) {
            t1.add(element);
            t12.add(element);
        }
        for (E element : this.v2) {
            t2.add(element);
        }
        this.v1.removeAll(this.v2);
        this.v2.removeAll(t1);
        t1.retainAll(t2);
        this.v1.addAll(t1);
        this.v1.addAll(this.v2);
        Vector<E> collection = this.v1;
        this.v1 = t12;
        this.v2 = t2;
        logger.debug((Object)collection.toString());
        logger.debug((Object)this.v1.toString());
        logger.debug((Object)this.v2.toString());
        this.v1Aligned = new Vector();
        this.v2Aligned = new Vector();
        this.v1AlignedBinary = new simpack.util.Vector();
        this.v2AlignedBinary = new simpack.util.Vector();
        for (E element : collection) {
            if (this.v1.contains(element)) {
                this.v1AlignedBinary.add(1.0);
                this.v1Aligned.add(element);
            } else {
                this.v1AlignedBinary.add(0.0);
                this.v1Aligned.add(null);
            }
            if (this.v2.contains(element)) {
                this.v2AlignedBinary.add(1.0);
                this.v2Aligned.add(element);
                continue;
            }
            this.v2AlignedBinary.add(0.0);
            this.v2Aligned.add(null);
        }
        logger.debug((Object)this.v1AlignedBinary.toString());
        logger.debug((Object)this.v2AlignedBinary.toString());
    }
}

