/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.alg.DijkstraShortestPath;
import org._3pq.jgrapht.graph.SimpleDirectedWeightedGraph;
import simpack.api.ITreeAccessor;
import simpack.api.ITreeNode;
import simpack.api.ITreeNodeComparator;
import simpack.api.impl.DistanceConversion;
import simpack.api.impl.TreeSimilarityMeasure;
import simpack.exception.InvalidElementException;
import simpack.util.conversion.WorstCaseDistanceConversion;
import simpack.util.tree.GraphVertexTuple;
import simpack.util.tree.TreeNodeTuple;
import simpack.util.tree.TreeUtil;
import simpack.util.tree.comparator.AlwaysTrueTreeNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeEditDistance
extends TreeSimilarityMeasure {
    public static double DEFAULT_WEIGHT_DELETE = 1.0;
    public static double DEFAULT_WEIGHT_INSERT = 1.0;
    public static double DEFAULT_WEIGHT_SUBSTITUE = 1.0;
    public static double DEFAULT_WEIGHT_SUBSTITUE_EQUAL = 0.0;
    public static double DEFAULT_PATH_LENGTH_LIMIT = Double.POSITIVE_INFINITY;
    private ITreeNode tree1;
    private List<ITreeNode> list1 = null;
    private HashMap<ITreeNode, Integer> depth1 = new HashMap();
    private ITreeNode tree2;
    private List<ITreeNode> list2 = null;
    private HashMap<ITreeNode, Integer> depth2 = new HashMap();
    private double pathLengthLimit = DEFAULT_PATH_LENGTH_LIMIT;
    private SimpleDirectedWeightedGraph editDistanceGraph;
    private GraphVertexTuple firstVertex;
    private GraphVertexTuple lastVertex;
    private double weightDelete = DEFAULT_WEIGHT_DELETE;
    private double weightInsert = DEFAULT_WEIGHT_INSERT;
    private double weightSubstitute = DEFAULT_WEIGHT_SUBSTITUE;
    private double weightSubstituteEqual = DEFAULT_WEIGHT_SUBSTITUE_EQUAL;
    private DijkstraShortestPath shortestPath;
    private DistanceConversion conversion;

    public TreeEditDistance(ITreeAccessor treeAccessor1, ITreeAccessor treeAccessor2) throws NullPointerException, InvalidElementException {
        this(treeAccessor1, treeAccessor2, new AlwaysTrueTreeNodeComparator(), new WorstCaseDistanceConversion());
    }

    public TreeEditDistance(ITreeAccessor treeAccessor1, ITreeAccessor treeAccessor2, ITreeNodeComparator<ITreeNode> comparator, DistanceConversion conversion) throws NullPointerException, InvalidElementException {
        this(treeAccessor1, treeAccessor2, comparator, conversion, DEFAULT_PATH_LENGTH_LIMIT, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_SUBSTITUE);
    }

    public TreeEditDistance(ITreeAccessor treeAccessor1, ITreeAccessor treeAccessor2, Double pathLengthLimit, Double weigthInsert, Double weigthDelete, Double weigthSubstitute) throws NullPointerException, InvalidElementException {
        this(treeAccessor1, treeAccessor2, new AlwaysTrueTreeNodeComparator(), new WorstCaseDistanceConversion(), pathLengthLimit, weigthInsert, weigthDelete, weigthSubstitute);
    }

    public TreeEditDistance(ITreeAccessor treeAccessor1, ITreeAccessor treeAccessor2, ITreeNodeComparator<ITreeNode> comparator, DistanceConversion conversion, Double pathLengthLimit, Double weigthInsert, Double weigthDelete, Double weigthSubstitute) throws NullPointerException, InvalidElementException {
        this(treeAccessor1, treeAccessor2, comparator, conversion, pathLengthLimit, weigthInsert, weigthDelete, weigthSubstitute, null);
    }

    public TreeEditDistance(ITreeAccessor treeAccessor1, ITreeAccessor treeAccessor2, ITreeNodeComparator<ITreeNode> comparator, DistanceConversion conversion, Double pathLengthLimit, Double weigthInsert, Double weigthDelete, Double weigthSubstitute, Double weigthSubstituteEqual) throws NullPointerException, InvalidElementException {
        super(comparator);
        this.conversion = conversion;
        if (treeAccessor1 == null || treeAccessor2 == null || treeAccessor1.getRoot() == null || treeAccessor2.getRoot() == null) {
            throw new NullPointerException("Invalid accessors passed!");
        }
        this.tree1 = treeAccessor1.getRoot();
        this.tree2 = treeAccessor2.getRoot();
        this.list1 = TreeUtil.enumerationToList(this.tree1.preorderEnumeration());
        this.list2 = TreeUtil.enumerationToList(this.tree2.preorderEnumeration());
        if (pathLengthLimit != null) {
            this.pathLengthLimit = pathLengthLimit;
        }
        if (weigthInsert != null) {
            this.weightInsert = weigthInsert;
        }
        if (weigthDelete != null) {
            this.weightDelete = weigthDelete;
        }
        if (weigthSubstitute != null) {
            this.weightSubstitute = weigthSubstitute;
        }
        if (weigthSubstituteEqual != null) {
            this.weightSubstituteEqual = weigthSubstituteEqual;
        }
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        if (this.calculateGraph()) {
            this.shortestPath = new DijkstraShortestPath((Graph)this.editDistanceGraph, (Object)this.firstVertex, (Object)this.lastVertex, this.pathLengthLimit);
            if (this.shortestPath != null) {
                this.setCalculated(true);
                if (this.conversion instanceof WorstCaseDistanceConversion) {
                    ((WorstCaseDistanceConversion)this.conversion).setWorstCaseDistance(this.getWorstCaseSumOfNodes());
                }
                this.similarity = new Double(this.conversion.convert(this.getTreeEditDistance()));
                return true;
            }
        }
        return false;
    }

    private boolean calculateGraph() {
        int i;
        ITreeNode a;
        int list1size = this.list1.size();
        int list2size = this.list2.size();
        HashMap<ITreeNode, Integer> orderNum1 = new HashMap<ITreeNode, Integer>();
        HashMap<ITreeNode, Integer> orderNum2 = new HashMap<ITreeNode, Integer>();
        this.preorderTreeDepth(this.tree1, orderNum1, this.depth1);
        this.preorderTreeDepth(this.tree2, orderNum2, this.depth2);
        int[] d1 = new int[list1size + 1];
        int[] d2 = new int[list2size + 1];
        ListIterator<ITreeNode> iter = this.list1.listIterator();
        while (iter.hasNext()) {
            a = (ITreeNode)iter.next();
            d1[orderNum1.get((Object)a).intValue()] = this.depth1.get(a);
        }
        iter = this.list2.listIterator();
        while (iter.hasNext()) {
            a = (ITreeNode)iter.next();
            d2[orderNum2.get((Object)a).intValue()] = this.depth2.get(a);
        }
        this.editDistanceGraph = new SimpleDirectedWeightedGraph();
        GraphVertexTuple[][] vertexArray = new GraphVertexTuple[list1size + 1][list2size + 1];
        for (i = 0; i <= list1size; ++i) {
            for (int j = 0; j <= list2size; ++j) {
                GraphVertexTuple t = new GraphVertexTuple(new Integer(i), new Integer(j));
                if (i > 0 && j > 0) {
                    t.setTreeNodeTuple(new TreeNodeTuple(this.list1.get(i - 1), this.list2.get(j - 1)));
                }
                vertexArray[i][j] = t;
                if (this.editDistanceGraph.addVertex((Object)t)) continue;
                return false;
            }
        }
        this.firstVertex = vertexArray[0][0];
        this.lastVertex = vertexArray[list1size][list2size];
        for (i = 0; i < list1size; ++i) {
            Edge e = this.editDistanceGraph.addEdge((Object)vertexArray[i][list2size], (Object)vertexArray[i + 1][list2size]);
            if (e == null) {
                return false;
            }
            e.setWeight(this.weightDelete);
        }
        for (int j = 0; j < list2size; ++j) {
            Edge e = this.editDistanceGraph.addEdge((Object)vertexArray[list1size][j], (Object)vertexArray[list1size][j + 1]);
            if (e == null) {
                return false;
            }
            e.setWeight(this.weightInsert);
        }
        for (i = 0; i < list1size; ++i) {
            for (int j = 0; j < list2size; ++j) {
                Edge e;
                if (d1[i + 1] >= d2[j + 1]) {
                    e = this.editDistanceGraph.addEdge((Object)vertexArray[i][j], (Object)vertexArray[i + 1][j]);
                    if (e == null) {
                        return false;
                    }
                    e.setWeight(this.weightDelete);
                }
                if (d1[i + 1] == d2[j + 1]) {
                    e = this.editDistanceGraph.addEdge((Object)vertexArray[i][j], (Object)vertexArray[i + 1][j + 1]);
                    if (e == null) {
                        return false;
                    }
                    if (this.comparator.compare(this.list1.get(i), this.list2.get(j)) == 0) {
                        e.setWeight(this.weightSubstituteEqual);
                    } else {
                        e.setWeight(this.weightSubstitute);
                    }
                }
                if (d1[i + 1] > d2[j + 1]) continue;
                e = this.editDistanceGraph.addEdge((Object)vertexArray[i][j], (Object)vertexArray[i][j + 1]);
                if (e == null) {
                    return false;
                }
                e.setWeight(this.weightInsert);
            }
        }
        return true;
    }

    private void preorderTreeDepth(ITreeNode tree, HashMap<ITreeNode, Integer> order, HashMap<ITreeNode, Integer> depth) {
        order.clear();
        depth.clear();
        Stack<ITreeNode> stack = new Stack<ITreeNode>();
        stack.push(tree.getRoot());
        int num = 1;
        do {
            ITreeNode v = (ITreeNode)stack.pop();
            order.put(v, num++);
            if (v.isRoot()) {
                depth.put(v, 0);
            } else {
                depth.put(v, depth.get(v.getParent()) + 1);
            }
            try {
            }
            catch (NoSuchElementException e) {
                continue;
            }
            for (ITreeNode w = v.getLastChild(); w != null; w = w.getPreviousSibling()) {
                stack.push(w);
            }
        } while (!stack.isEmpty());
    }

    public boolean hasValidEditDistance() {
        return this.isCalculated() && this.getTreeEditDistance() != Double.POSITIVE_INFINITY && this.shortestPath.getPathEdgeList() != null;
    }

    public double getTreeEditDistance() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.shortestPath.getPathLength();
    }

    public double getWorstCaseSumOfNodes() {
        return this.list1.size() + this.list2.size();
    }

    public double getWorstCaseSubstituteAll() {
        double worstCase = -1.0;
        SimpleDirectedWeightedGraph worstCaseGraph = new SimpleDirectedWeightedGraph();
        Set vertices = this.editDistanceGraph.vertexSet();
        Set edges = this.editDistanceGraph.edgeSet();
        worstCaseGraph.addAllVertices((Collection)vertices);
        worstCaseGraph.addAllEdges((Collection)edges);
        edges = worstCaseGraph.edgeSet();
        for (Edge edge : edges) {
            GraphVertexTuple vertex1 = (GraphVertexTuple)edge.getSource();
            GraphVertexTuple vertex2 = (GraphVertexTuple)edge.getTarget();
            if (vertex2.getLeft() != vertex1.getLeft() + 1 || vertex2.getRight() != vertex1.getRight() + 1) continue;
            edge.setWeight(this.weightSubstitute);
        }
        DijkstraShortestPath shortestPath = new DijkstraShortestPath((Graph)worstCaseGraph, (Object)this.firstVertex, (Object)this.lastVertex, this.pathLengthLimit);
        worstCase = shortestPath.getPathLength();
        return worstCase;
    }

    public double getWorstCaseRetainStructure() {
        double pathLength = 0.0;
        GraphVertexTuple vertex = this.firstVertex;
        while (vertex != this.lastVertex) {
            Edge edgeToWalk;
            Edge verticalEdge = null;
            Edge horizontalEdge = null;
            Edge diagonalEdge = null;
            List adjacentEdges = this.editDistanceGraph.outgoingEdgesOf((Object)vertex);
            for (Edge edge : adjacentEdges) {
                GraphVertexTuple oppositeVertex = (GraphVertexTuple)edge.oppositeVertex((Object)vertex);
                int left = vertex.getLeft();
                int right = vertex.getRight();
                int oppositeLeft = oppositeVertex.getLeft();
                int oppositeRight = oppositeVertex.getRight();
                if (oppositeLeft == left + 1 && oppositeRight == right + 1) {
                    diagonalEdge = edge;
                    break;
                }
                if (oppositeLeft == left + 1 && oppositeRight == right) {
                    verticalEdge = edge;
                    continue;
                }
                horizontalEdge = edge;
            }
            double weight = 0.0;
            if (diagonalEdge != null) {
                edgeToWalk = diagonalEdge;
                weight = this.weightSubstitute;
            } else if (verticalEdge != null) {
                edgeToWalk = verticalEdge;
                weight = edgeToWalk.getWeight();
            } else {
                edgeToWalk = horizontalEdge;
                weight = edgeToWalk.getWeight();
            }
            pathLength += weight;
            vertex = (GraphVertexTuple)edgeToWalk.oppositeVertex((Object)vertex);
        }
        return pathLength;
    }

    public double getWeightDelete() {
        return this.weightDelete;
    }

    public void setWeightDelete(double weightDelete) {
        this.weightDelete = weightDelete;
    }

    public double getWeightInsert() {
        return this.weightInsert;
    }

    public void setWeightInsert(double weightInsert) {
        this.weightInsert = weightInsert;
    }

    public double getWeightSubstitute() {
        return this.weightSubstitute;
    }

    public void setWeightSubstitute(double weightSubstitute) {
        this.weightSubstitute = weightSubstitute;
    }

    public DijkstraShortestPath getShortestPath() {
        return this.shortestPath;
    }
}

