/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.tree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ListIterator;
import javax.swing.tree.TreeNode;
import simpack.api.ITreeAccessor;
import simpack.api.ITreeNode;
import simpack.api.ITreeNodeComparator;
import simpack.api.impl.TreeSimilarityMeasure;
import simpack.exception.InvalidElementException;
import simpack.util.tree.TreeUtil;
import simpack.util.tree.comparator.TypedTreeNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopDownOrderedMaximumSubtree
extends TreeSimilarityMeasure {
    private ITreeNode tree1;
    private ITreeNode tree2;
    private HashMap<ITreeNode, ITreeNode> mappedTrees = new HashMap();
    private ITreeNode matchedTree1;
    private ITreeNode matchedTree2;
    private ITreeNode currentParent1;
    private ITreeNode currentParent2;

    public TopDownOrderedMaximumSubtree(ITreeAccessor treeAccessor1, ITreeAccessor treeAccessor2) throws NullPointerException, InvalidElementException {
        this(treeAccessor1, treeAccessor2, new TypedTreeNodeComparator());
    }

    public TopDownOrderedMaximumSubtree(ITreeAccessor treeAccessor1, ITreeAccessor treeAccessor2, ITreeNodeComparator<ITreeNode> comparator) throws NullPointerException, InvalidElementException {
        super(comparator);
        if (treeAccessor1 == null || treeAccessor2 == null || treeAccessor1.getRoot() == null || treeAccessor2.getRoot() == null) {
            throw new NullPointerException("Invalid accessors passed!");
        }
        this.tree1 = treeAccessor1.getRoot();
        this.tree2 = treeAccessor2.getRoot();
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        if (this.mapOrderedCommonSubtree(this.tree1.getRoot(), this.tree2.getRoot())) {
            this.setCalculated(true);
            this.similarity = TreeUtil.getSimilarity1to1(this.getTree1(), this.getTree2(), this.getMatchedTree2());
            return true;
        }
        return false;
    }

    private boolean mapOrderedCommonSubtree(ITreeNode node1, ITreeNode node2) {
        if (this.comparator.compare(node1, node2) != 0) {
            return false;
        }
        this.mappedTrees.put(node1, node2);
        ITreeNode clone1 = (ITreeNode)node1.clone();
        ITreeNode clone2 = (ITreeNode)node2.clone();
        if (!node1.isRoot()) {
            this.currentParent1.add(clone1);
            this.currentParent1 = clone1;
        } else {
            this.matchedTree1 = this.currentParent1 = clone1;
        }
        if (!node2.isRoot()) {
            this.currentParent2.add(clone2);
            this.currentParent2 = clone2;
        } else {
            this.matchedTree2 = this.currentParent2 = clone2;
        }
        if (!node1.isLeaf() && !node2.isLeaf()) {
            Enumeration<? extends TreeNode> childs1 = node1.children();
            Enumeration<? extends TreeNode> childs2 = node2.children();
            ArrayList<ITreeNode> list1 = new ArrayList<ITreeNode>();
            while (childs1.hasMoreElements()) {
                list1.add((ITreeNode)childs1.nextElement());
            }
            ArrayList<ITreeNode> list2 = new ArrayList<ITreeNode>();
            while (childs2.hasMoreElements()) {
                list2.add((ITreeNode)childs2.nextElement());
            }
            ListIterator iter1 = list1.listIterator();
            ListIterator iter2 = list2.listIterator();
            boolean res = true;
            while (res && iter1.hasNext() && iter2.hasNext()) {
                ITreeNode v = (ITreeNode)iter1.next();
                ITreeNode w = (ITreeNode)iter2.next();
                res = this.mapOrderedCommonSubtree(v, w);
                this.currentParent1 = clone1;
                this.currentParent2 = clone2;
            }
        }
        return true;
    }

    public ITreeNode getTree1() {
        return this.tree1;
    }

    public ITreeNode getTree2() {
        return this.tree2;
    }

    public HashMap<ITreeNode, ITreeNode> getMappedTrees() {
        if (this.isCalculated()) {
            return this.mappedTrees;
        }
        return null;
    }

    public ITreeNode getMatchedTree1() {
        if (this.isCalculated()) {
            return this.matchedTree1;
        }
        return null;
    }

    public ITreeNode getMatchedTree2() {
        if (this.isCalculated()) {
            return this.matchedTree2;
        }
        return null;
    }
}

