/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.tree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.PriorityQueue;
import simpack.api.ITreeAccessor;
import simpack.api.ITreeNode;
import simpack.api.ITreeNodeComparator;
import simpack.api.impl.TreeSimilarityMeasure;
import simpack.exception.InvalidElementException;
import simpack.util.tree.EquivalenceClassCalculator;
import simpack.util.tree.NodePriority;
import simpack.util.tree.TreeNode;
import simpack.util.tree.TreeNodePriorityTuple;
import simpack.util.tree.TreeUtil;
import simpack.util.tree.comparator.AlwaysTrueTreeNodeComparator;
import simpack.util.tree.comparator.NodeComparator;
import simpack.util.tree.visitor.BuildTreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BottomUpMaximumSubtree
extends TreeSimilarityMeasure {
    private ITreeNode tree1;
    private List<ITreeNode> list1 = null;
    private PriorityQueue<TreeNodePriorityTuple> queue1 = new PriorityQueue<TreeNodePriorityTuple>(3, new NodeComparator());
    private LinkedHashMap<ITreeNode, Integer> size1 = new LinkedHashMap();
    private ArrayList<ITreeNode> subtreeRootNodesTree1 = new ArrayList();
    private ITreeNode tree2;
    private List<ITreeNode> list2 = null;
    private boolean ordered;
    private boolean labeled;
    private PriorityQueue<TreeNodePriorityTuple> queue2 = new PriorityQueue<TreeNodePriorityTuple>(3, new NodeComparator());
    private LinkedHashMap<ITreeNode, Integer> size2 = new LinkedHashMap();
    private ArrayList<ITreeNode> subtreeRootNodesTree2 = new ArrayList();
    private EquivalenceClassCalculator equivalenceClass = null;
    private HashMap<TreeNode, TreeNode> orderedMapping;

    public BottomUpMaximumSubtree(ITreeAccessor treeAccessor1, ITreeAccessor treeAccessor2) throws NullPointerException, InvalidElementException {
        this(treeAccessor1, treeAccessor2, new AlwaysTrueTreeNodeComparator());
    }

    public BottomUpMaximumSubtree(ITreeAccessor treeAccessor1, ITreeAccessor treeAccessor2, ITreeNodeComparator<ITreeNode> comparator) throws NullPointerException, InvalidElementException {
        this(treeAccessor1, treeAccessor2, comparator, false);
    }

    public BottomUpMaximumSubtree(ITreeAccessor treeAccessor1, ITreeAccessor treeAccessor2, ITreeNodeComparator<ITreeNode> comparator, boolean ordered) throws NullPointerException, InvalidElementException {
        this(treeAccessor1, treeAccessor2, comparator, ordered, false);
    }

    public BottomUpMaximumSubtree(ITreeAccessor treeAccessor1, ITreeAccessor treeAccessor2, ITreeNodeComparator<ITreeNode> comparator, boolean ordered, boolean labeled) throws NullPointerException, InvalidElementException {
        super(comparator);
        if (treeAccessor1 == null || treeAccessor2 == null || treeAccessor1.getRoot() == null || treeAccessor2.getRoot() == null) {
            throw new NullPointerException("Invalid accessors passed!");
        }
        this.ordered = ordered;
        this.labeled = labeled;
        this.tree1 = treeAccessor1.getRoot();
        this.tree2 = treeAccessor2.getRoot();
        this.list1 = TreeUtil.enumerationToList(this.tree1.postorderEnumeration());
        this.list2 = TreeUtil.enumerationToList(this.tree2.postorderEnumeration());
        if (this.list1 == null || this.list2 == null) {
            throw new NullPointerException("Postorder lists were not initialized.");
        }
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        try {
            this.equivalenceClass = new EquivalenceClassCalculator(this.tree1, this.list1, this.tree2, this.list2, this.ordered, this.labeled);
            if (!this.equivalenceClass.calculate() || !this.equivalenceClass.isCalculated()) {
                return false;
            }
            this.queue1 = this.calculateQueue(this.list1, this.equivalenceClass.getEquivalenceClassesTree1(), this.size1);
            this.queue2 = this.calculateQueue(this.list2, this.equivalenceClass.getEquivalenceClassesTree2(), this.size2);
        }
        catch (Exception e1) {
            return false;
        }
        ITreeNode v = this.findMaxCommonSubtree();
        if (v == null) {
            return false;
        }
        this.setCalculated(true);
        List<ITreeNode> subtreeList = null;
        try {
            subtreeList = TreeUtil.enumerationToList(v.preorderEnumeration());
        }
        catch (InvalidElementException e) {
            return false;
        }
        if (subtreeList == null) {
            return false;
        }
        HashMap<TreeNode, TreeNode> mapped = null;
        try {
            mapped = this.mapTrees(this.getSubtreeRootNodesTree1().get(0), this.getSubtreeRootNodesTree2().get(0));
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (InvalidElementException e) {
            return false;
        }
        if (mapped == null) {
            return false;
        }
        BuildTreeVisitor visitor = new BuildTreeVisitor(mapped, this.getSubtreeRootNodesTree1().get(0));
        ITreeNode resultTree = visitor.getTree();
        this.similarity = TreeUtil.getSimilarity1to1(this.getTree1(), this.getTree2(), resultTree);
        return true;
    }

    private ITreeNode findMaxCommonSubtree() {
        ArrayList<TreeNodePriorityTuple> queue1original = this.copyQueue(this.queue1);
        ArrayList<TreeNodePriorityTuple> queue2original = this.copyQueue(this.queue2);
        TreeNodePriorityTuple v = null;
        TreeNodePriorityTuple w = null;
        while (!this.queue1.isEmpty() && !this.queue2.isEmpty()) {
            v = this.queue1.peek();
            w = this.queue2.peek();
            if (v.getPriority().getCode().equals(w.getPriority().getCode())) {
                this.subtreeRootNodesTree1.add(v.getNode());
                this.subtreeRootNodesTree2.add(w.getNode());
                this.subtreeRootNodesTree1.addAll(this.findSame(v, queue1original));
                this.subtreeRootNodesTree2.addAll(this.findSame(w, queue2original));
                break;
            }
            if (NodePriority.compare(v.getPriority(), w.getPriority()) == -1) {
                this.queue1.remove(v);
                continue;
            }
            this.queue2.remove(w);
        }
        if (v == null || w == null) {
            return null;
        }
        return v.getNode();
    }

    private ArrayList<ITreeNode> findSame(TreeNodePriorityTuple tuple, ArrayList<TreeNodePriorityTuple> queue) {
        ArrayList<ITreeNode> ret = new ArrayList<ITreeNode>();
        for (TreeNodePriorityTuple a : queue) {
            if (a.equals(tuple) || !a.getPriority().getCode().equals(tuple.getPriority().getCode())) continue;
            ret.add(a.getNode());
        }
        return ret;
    }

    private ArrayList<TreeNodePriorityTuple> copyQueue(PriorityQueue<TreeNodePriorityTuple> queue) {
        ArrayList<TreeNodePriorityTuple> ret = new ArrayList<TreeNodePriorityTuple>();
        for (TreeNodePriorityTuple a : queue) {
            ret.add(a);
        }
        return ret;
    }

    private PriorityQueue<TreeNodePriorityTuple> calculateQueue(List<ITreeNode> list, LinkedHashMap<ITreeNode, Integer> code, LinkedHashMap<ITreeNode, Integer> size) throws InvalidElementException {
        PriorityQueue<TreeNodePriorityTuple> queue = new PriorityQueue<TreeNodePriorityTuple>(3, new NodeComparator());
        ListIterator<ITreeNode> liter = list.listIterator();
        while (liter.hasNext()) {
            ITreeNode node = liter.next();
            size.put(node, new Integer(1));
            if (!node.isLeaf()) {
                Enumeration<? extends javax.swing.tree.TreeNode> enumer = node.children();
                while (enumer.hasMoreElements()) {
                    javax.swing.tree.TreeNode o = enumer.nextElement();
                    if (o instanceof ITreeNode) {
                        size.put(node, size.get(node) + size.get((ITreeNode)o));
                        continue;
                    }
                    throw new InvalidElementException("Unexpected child type in Tree while calculating child size.");
                }
            }
            TreeNodePriorityTuple tp = new TreeNodePriorityTuple(node, new NodePriority(size.get(node), code.get(node)));
            queue.add(tp);
        }
        return queue;
    }

    public HashMap<TreeNode, TreeNode> mapTrees(ITreeNode root1, ITreeNode root2) throws InvalidElementException {
        if (this.ordered) {
            return this.mapOrderedTrees(root1, root2);
        }
        return this.mapUnorderedTrees(root1, root2);
    }

    private HashMap<TreeNode, TreeNode> mapUnorderedTrees(ITreeNode root1, ITreeNode root2) throws InvalidElementException {
        HashMap<TreeNode, TreeNode> mappedSubtree = new HashMap<TreeNode, TreeNode>();
        if (root1 == null || root2 == null) {
            return null;
        }
        if (!root1.getRoot().equals(this.tree1.getRoot()) || !root2.getRoot().equals(this.tree2.getRoot())) {
            return null;
        }
        if (!this.equivalenceClass.getEquivalenceClassesTree1().get(root1).equals(this.equivalenceClass.getEquivalenceClassesTree2().get(root2))) {
            return null;
        }
        List<ITreeNode> subtreeList = null;
        subtreeList = TreeUtil.enumerationToList(root1.preorderEnumeration());
        if (subtreeList == null) {
            throw new InvalidElementException();
        }
        mappedSubtree.put((TreeNode)root1, (TreeNode)root2);
        HashMap<ITreeNode, Boolean> mapped = new HashMap<ITreeNode, Boolean>();
        ListIterator<ITreeNode> subtreeIterator = subtreeList.listIterator(1);
        block0: while (subtreeIterator.hasNext()) {
            ITreeNode nodeV = subtreeIterator.next();
            Enumeration<javax.swing.tree.TreeNode> e = mappedSubtree.get(nodeV.getParent()).children();
            while (e.hasMoreElements()) {
                javax.swing.tree.TreeNode o = e.nextElement();
                if (o instanceof ITreeNode) {
                    ITreeNode nodeW = (ITreeNode)o;
                    if (!this.equivalenceClass.getEquivalenceClassesTree1().get(nodeV).equals(this.equivalenceClass.getEquivalenceClassesTree2().get(nodeW)) || mapped.containsKey(nodeW) && ((Boolean)mapped.get(nodeW)).booleanValue()) continue;
                    mappedSubtree.put((TreeNode)nodeV, (TreeNode)nodeW);
                    mapped.put(nodeW, true);
                    continue block0;
                }
                throw new InvalidElementException();
            }
        }
        return mappedSubtree;
    }

    private HashMap<TreeNode, TreeNode> mapOrderedTrees(ITreeNode root1, ITreeNode root2) {
        this.orderedMapping = new HashMap();
        if (this.mapOrderedSubtrees(root1, root2)) {
            return this.orderedMapping;
        }
        return null;
    }

    private boolean mapOrderedSubtrees(ITreeNode root1, ITreeNode root2) {
        if (root1 == null || root2 == null) {
            return false;
        }
        if (!root1.getRoot().equals(this.tree1.getRoot()) || !root2.getRoot().equals(this.tree2.getRoot())) {
            return false;
        }
        if (!this.equivalenceClass.getEquivalenceClassesTree1().get(root1).equals(this.equivalenceClass.getEquivalenceClassesTree2().get(root2))) {
            return false;
        }
        if (this.comparator.compare(root1, root2) != 0) {
            return false;
        }
        this.orderedMapping.put((TreeNode)root1, (TreeNode)root2);
        if (root1.getChildCount() > root2.getChildCount()) {
            return false;
        }
        if (!root1.isLeaf()) {
            ITreeNode v2;
            ITreeNode v1 = root1.getFirstChild();
            if (!this.mapOrderedSubtrees(v1, v2 = root2.getFirstChild())) {
                return false;
            }
            for (int i = 2; i <= root1.getChildCount(); ++i) {
                if (this.mapOrderedSubtrees(v1 = root1.getChildAfter(v1), v2 = root2.getChildAfter(v2))) continue;
                return false;
            }
        }
        return true;
    }

    public LinkedHashMap<ITreeNode, Integer> getEquivalenceClassTree1() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.equivalenceClass.getEquivalenceClassesTree1();
    }

    public LinkedHashMap<ITreeNode, Integer> getEquivalenceClassTree2() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.equivalenceClass.getEquivalenceClassesTree2();
    }

    public LinkedHashMap<ITreeNode, Integer> getSizeTree1() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.size1;
    }

    public LinkedHashMap<ITreeNode, Integer> getSizeTree2() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.size2;
    }

    public ArrayList<ITreeNode> getSubtreeRootNodesTree1() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.subtreeRootNodesTree1;
    }

    public ArrayList<ITreeNode> getSubtreeRootNodesTree2() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.subtreeRootNodesTree2;
    }

    public ITreeNode getTree1() {
        return this.tree1;
    }

    public ITreeNode getTree2() {
        return this.tree2;
    }
}

