/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.string;

import org.apache.log4j.Logger;
import simpack.api.impl.SimilarityMeasure;

public class Jaro
extends SimilarityMeasure {
    public static Logger logger = Logger.getLogger(Jaro.class);
    private String str1;
    private String str2;

    public Jaro(String str1, String str2) {
        this.str1 = str1;
        this.str2 = str2;
    }

    public boolean calculate() {
        this.str1 = this.str1.toLowerCase();
        this.str2 = this.str2.toLowerCase();
        int halflen = this.halfLengthOfShorter(this.str1, this.str2);
        String common1 = this.commonChars(this.str1, this.str2, halflen);
        String common2 = this.commonChars(this.str2, this.str1, halflen);
        if (common1.length() != common2.length()) {
            logger.error((Object)("common1 != common2: '" + common1 + "' != '" + common2 + "'"));
            this.similarity = new Double(-1.0);
            this.setCalculated(true);
            return true;
        }
        if (common1.length() == 0 || common2.length() == 0) {
            this.similarity = new Double(0.0);
            this.setCalculated(true);
            return true;
        }
        int common = common1.length();
        int transpositions = this.transpositions(common1, common2);
        double dist = ((double)common / (double)this.str1.length() + (double)common / (double)this.str2.length() + (double)(common - transpositions) / (double)common) / 3.0;
        this.similarity = new Double(dist);
        this.setCalculated(true);
        return true;
    }

    private int halfLengthOfShorter(String str1, String str2) {
        return str1.length() > str2.length() ? str2.length() / 2 + 1 : str1.length() / 2 + 1;
    }

    private String commonChars(String s, String t, int halflen) {
        StringBuffer common = new StringBuffer();
        StringBuffer copy = new StringBuffer(t);
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            boolean foundIt = false;
            for (int j = Math.max(0, i - halflen); !foundIt && j < Math.min(i + halflen, t.length()); ++j) {
                if (copy.charAt(j) != ch) continue;
                foundIt = true;
                common.append(ch);
                copy.setCharAt(j, '*');
            }
        }
        return common.toString();
    }

    private int transpositions(String common1, String common2) {
        int transpositions = 0;
        for (int i = 0; i < common1.length(); ++i) {
            if (common1.charAt(i) == common2.charAt(i)) continue;
            ++transpositions;
        }
        return transpositions /= 2;
    }
}

