/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.string;

import java.util.List;
import org.apache.log4j.Logger;
import simpack.accessor.string.StringAccessor;
import simpack.api.ISequenceAccessor;
import simpack.api.impl.SequenceSimilarityMeasure;
import simpack.api.impl.SimilarityMeasure;
import simpack.exception.InvalidSimilarityMeasureNameException;
import simpack.measure.sequence.Levenshtein;
import simpack.util.conversion.WorstCaseDistanceConversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AveragedStringMatching
extends SimilarityMeasure {
    static Logger logger = Logger.getLogger(AveragedStringMatching.class);
    private ISequenceAccessor<String> sa1;
    private ISequenceAccessor<String> sa2;
    private String sim;

    public AveragedStringMatching(ISequenceAccessor<String> sa1, ISequenceAccessor<String> sa2) throws InvalidSimilarityMeasureNameException {
        this(sa1, sa2, "Levenshtein-SimPack");
    }

    public AveragedStringMatching(ISequenceAccessor<String> sa1, ISequenceAccessor<String> sa2, String sim) throws InvalidSimilarityMeasureNameException {
        this.sa1 = sa1;
        this.sa2 = sa2;
        this.sim = sim;
        if (!(sim.equals("Levenshtein-SimPack") || sim.equals("Levenshtein-SecondString") || sim.equals("Levenshtein-SimMetrics"))) {
            throw new InvalidSimilarityMeasureNameException();
        }
    }

    @Override
    public boolean calculate() {
        double sum = 0.0;
        List<String> seq1 = this.sa1.getSequence();
        for (String str1 : seq1) {
            double max = Double.NEGATIVE_INFINITY;
            List<String> seq2 = this.sa2.getSequence();
            for (String str2 : seq2) {
                SequenceSimilarityMeasure m = null;
                double s = 0.0;
                if (this.sim.equals("Levenshtein-SimPack")) {
                    m = new Levenshtein<String>(new StringAccessor(str1), new StringAccessor(str2));
                    s = m.getSimilarity();
                } else if (this.sim.equals("Levenshtein-SecondString")) {
                    m = new simpack.measure.external.secondstring.Levenshtein(new StringAccessor(str1), new StringAccessor(str2));
                    s = Math.abs(m.getSimilarity());
                    double worstCaseDistance = this.calculateWorstCaseDistance(str1.length(), str2.length(), 1, 1, 1);
                    WorstCaseDistanceConversion conversion = new WorstCaseDistanceConversion(worstCaseDistance);
                    s = conversion.convert(s);
                } else if (this.sim.equals("Levenshtein-SimMetrics")) {
                    m = new simpack.measure.external.simmetrics.Levenshtein(str1, str2);
                    s = m.getSimilarity();
                }
                logger.debug((Object)(str1 + " <-> " + str2 + " = " + s));
                if (!(s >= max)) continue;
                max = s;
            }
            sum += max;
        }
        double asm = sum / (double)seq1.size();
        this.similarity = new Double(asm);
        this.setCalculated(true);
        return true;
    }

    private double calculateWorstCaseDistance(int sizeX, int sizeY, int weightReplace, int weightInsert, int weightDelete) {
        double maxDistance = 0.0;
        if (sizeY > sizeX) {
            maxDistance = sizeX * weightReplace;
            int diff = sizeY - sizeX;
            maxDistance += (double)(diff * weightInsert);
        } else if (sizeX == sizeY) {
            maxDistance = sizeX * weightReplace;
        } else if (sizeY < sizeX) {
            maxDistance = sizeY * weightReplace;
            int diff = sizeX - sizeY;
            maxDistance += (double)(diff * weightDelete);
        }
        return maxDistance;
    }
}

