/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.sequence;

import java.util.List;
import org.apache.log4j.Logger;
import simpack.accessor.string.StringAccessor;
import simpack.api.IDistanceConversion;
import simpack.api.ISequenceAccessor;
import simpack.api.impl.DistanceConversion;
import simpack.api.impl.SequenceSimilarityMeasure;
import simpack.exception.WeightBalanceException;
import simpack.util.conversion.WorstCaseDistanceConversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Levenshtein<E>
extends SequenceSimilarityMeasure<E> {
    protected static final Logger logger = Logger.getLogger(Levenshtein.class);
    public static double DEFAULT_WEIGHT_INSERT = 1.0;
    public static double DEFAULT_WEIGHT_DELETE = 1.0;
    public static double DEFAULT_WEIGHT_REPLACE = 1.0;
    public static double DEFAULT_WEIGHT_REPLACE_EQUAL = 0.0;
    protected double weightInsert = DEFAULT_WEIGHT_INSERT;
    protected double weightDelete = DEFAULT_WEIGHT_DELETE;
    protected double weightReplace = DEFAULT_WEIGHT_REPLACE;
    protected double weightReplaceEqual = DEFAULT_WEIGHT_REPLACE_EQUAL;
    protected IDistanceConversion conversion;

    public Levenshtein(ISequenceAccessor<E> sequenceAccessor1, ISequenceAccessor<E> sequenceAccessor2) {
        this(sequenceAccessor1, sequenceAccessor2, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_REPLACE, DEFAULT_WEIGHT_REPLACE_EQUAL, new WorstCaseDistanceConversion());
    }

    public Levenshtein(ISequenceAccessor<E> sequenceAccessor1, ISequenceAccessor<E> sequenceAccessor2, DistanceConversion conversion) {
        this(sequenceAccessor1, sequenceAccessor2, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_REPLACE, DEFAULT_WEIGHT_REPLACE_EQUAL, conversion);
    }

    public Levenshtein(ISequenceAccessor<E> sequenceAccessor1, ISequenceAccessor<E> sequenceAccessor2, double weightInsert, double weightDelete, double weightReplace, double weightReplaceEqual, DistanceConversion conversion) {
        super(sequenceAccessor1, sequenceAccessor2);
        if (weightInsert + weightDelete < weightReplace || weightInsert + weightDelete < weightReplaceEqual) {
            throw new WeightBalanceException("c(weightInsert) + c(weightDelete) <= c(weightReplace)");
        }
        this.weightInsert = weightInsert;
        this.weightDelete = weightDelete;
        this.weightReplace = weightReplace;
        this.weightReplaceEqual = weightReplaceEqual;
        this.conversion = conversion;
    }

    @Override
    public boolean calculate() {
        int spalte;
        this.setCalculated(false);
        List sequenceSrc = this.sequenceAccessor1.getSequence();
        List sequenceTgt = this.sequenceAccessor2.getSequence();
        logger.debug((Object)sequenceSrc.toString());
        logger.debug((Object)sequenceTgt.toString());
        double[][] matrix = new double[sequenceSrc.size() + 1][sequenceTgt.size() + 1];
        for (int zeile = 0; zeile <= sequenceSrc.size(); ++zeile) {
            matrix[zeile][0] = zeile;
        }
        for (spalte = 0; spalte <= sequenceTgt.size(); ++spalte) {
            matrix[0][spalte] = spalte;
        }
        for (spalte = 1; spalte <= sequenceTgt.size(); ++spalte) {
            for (int zeile = 1; zeile <= sequenceSrc.size(); ++zeile) {
                double valueFromLeft = matrix[zeile][spalte - 1] + this.weightInsert;
                double valueFromTop = matrix[zeile - 1][spalte] + this.weightDelete;
                double valueFromDiag = matrix[zeile - 1][spalte - 1];
                valueFromDiag = !sequenceSrc.get(zeile - 1).equals(sequenceTgt.get(spalte - 1)) ? (valueFromDiag += this.weightReplace) : (valueFromDiag += this.weightReplaceEqual);
                matrix[zeile][spalte] = Math.min(valueFromLeft, Math.min(valueFromDiag, valueFromTop));
            }
        }
        double dist = matrix[sequenceSrc.size()][sequenceTgt.size()];
        double wDist = 0.0;
        if (this.conversion instanceof WorstCaseDistanceConversion) {
            wDist = this.calculateWorstCaseDistance(((Object)this.sequenceAccessor1).toString(), ((Object)this.sequenceAccessor2).toString());
            ((WorstCaseDistanceConversion)this.conversion).setWorstCaseDistance(wDist);
        }
        double sim = this.conversion.convert(dist);
        logger.debug((Object)("dist = " + dist + ", wDist = " + wDist + ", sim = " + sim));
        this.similarity = new Double(sim);
        this.setCalculated(true);
        return true;
    }

    protected double calculateWorstCaseDistance(String source, String target) {
        double sourceLen = source.length();
        double targetLen = target.length();
        double maxDistance = 0.0;
        if (targetLen == sourceLen) {
            maxDistance = sourceLen * this.weightReplace;
        }
        if (targetLen > sourceLen) {
            maxDistance = sourceLen * this.weightReplace;
            maxDistance += (targetLen - sourceLen) * this.weightInsert;
        }
        if (targetLen < sourceLen) {
            maxDistance = targetLen * this.weightReplace;
            maxDistance += (sourceLen - targetLen) * this.weightDelete;
        }
        return maxDistance;
    }

    public static void main(String[] args) {
        Levenshtein<String> l = null;
        try {
            l = new Levenshtein<String>(new StringAccessor("Levenshtein"), new StringAccessor("shteinLeven"));
        }
        catch (WeightBalanceException e) {
            e.printStackTrace();
        }
        System.out.println(l.getSimilarity());
    }
}

