/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.it;

import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.SimilarityMeasure;
import simpack.exception.InvalidElementException;

public class Resnik
extends SimilarityMeasure {
    static Logger logger = Logger.getLogger(Resnik.class);
    private double N;
    private double numCommons;
    private IGraphAccessor graphAccessor;
    private IGraphNode x;
    private IGraphNode y;

    public Resnik(double N, double numCommons) {
        this.N = N;
        this.numCommons = numCommons;
    }

    public Resnik(IGraphAccessor graphAccessor, IGraphNode x, IGraphNode y) throws InvalidElementException {
        this.graphAccessor = graphAccessor;
        this.x = x;
        this.y = y;
        if (!graphAccessor.contains(x)) {
            throw new InvalidElementException(((Object)x).toString() + " not in set");
        }
        if (!graphAccessor.contains(y)) {
            throw new InvalidElementException(((Object)y).toString() + " not in set");
        }
    }

    public boolean calculate() {
        this.setCalculated(false);
        if (this.graphAccessor == null) {
            this.similarity = new Double(-1.0 * Math.log(this.numCommons / this.N));
            this.setCalculated(true);
            return true;
        }
        IGraphNode mrca = null;
        try {
            mrca = this.graphAccessor.getMostRecentCommonAncestor(this.x, this.y);
            if (logger.isDebugEnabled()) {
                System.out.println("MRCA of " + ((Object)this.x).toString() + " and " + ((Object)this.y).toString() + " is " + ((Object)mrca).toString());
            }
            double size = this.graphAccessor.size();
            double num = 0.0;
            num = this.graphAccessor.getSuccessors(mrca, false).size() + 1;
            double p = num / size;
            this.similarity = p == 0.0 ? new Double(0.0) : new Double(-1.0 * Math.log(p));
            this.setCalculated(true);
            return true;
        }
        catch (InvalidElementException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

