/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.it;

import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.SimilarityMeasure;
import simpack.exception.InvalidElementException;

public class Lin
extends SimilarityMeasure {
    static Logger logger = Logger.getLogger(Lin.class);
    private double N;
    private double numCommons;
    private double numElemX;
    private double numElemY;
    private IGraphAccessor graphAccessor;
    private IGraphNode x;
    private IGraphNode y;

    public Lin(double N, double numCommons, double numElemX, double numElemY) {
        this.N = N;
        this.numCommons = numCommons;
        this.numElemX = numElemX;
        this.numElemY = numElemY;
    }

    public Lin(IGraphAccessor graphAccessor, IGraphNode x, IGraphNode y) throws InvalidElementException {
        this.graphAccessor = graphAccessor;
        this.x = x;
        this.y = y;
        if (!graphAccessor.contains(x)) {
            throw new InvalidElementException(((Object)x).toString() + " not in set");
        }
        if (!graphAccessor.contains(y)) {
            throw new InvalidElementException(((Object)y).toString() + " not in set");
        }
    }

    public boolean calculate() {
        double p_x = 0.0;
        double p_y = 0.0;
        double p_z = 0.0;
        this.setCalculated(false);
        if (this.graphAccessor == null) {
            p_z = this.numCommons / this.N;
            p_x = this.numElemX / this.N;
            p_y = this.numElemY / this.N;
            this.similarity = new Double(2.0 * Math.log(p_z) / (Math.log(p_x) + Math.log(p_y)));
            this.setCalculated(true);
            return true;
        }
        try {
            double size = this.graphAccessor.size();
            int nX = this.graphAccessor.getSuccessors(this.x, false).size() + 1;
            p_x = (double)nX / new Double(size);
            int nY = this.graphAccessor.getSuccessors(this.y, false).size() + 1;
            p_y = (double)nY / new Double(size);
            IGraphNode mrca = this.graphAccessor.getMostRecentCommonAncestor(this.x, this.y);
            int nXY = this.graphAccessor.getSuccessors(mrca, false).size() + 1;
            p_z = (double)nXY / new Double(size);
            this.similarity = p_z == 1.0 ? new Double(0.0) : new Double(2.0 * Math.log(p_z) / (Math.log(p_x) + Math.log(p_y)));
            this.setCalculated(true);
            return true;
        }
        catch (InvalidElementException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

