/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import simpack.accessor.string.StringAccessor;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.GraphSimilarityMeasure;
import simpack.measure.sequence.Levenshtein;
import simpack.util.graph.GroupNode;
import simpack.util.graph.MappedVertex;
import simpack.util.graph.comparator.MappedVertexComparator;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubgraphIsomorphism
extends GraphSimilarityMeasure {
    public static Logger logger = Logger.getLogger(SubgraphIsomorphism.class);
    public static String DEFAULT_NODE_LABEL_SIMILARITY_MEASURE = "Levenshtein";
    public static int DEFAULT_MIN_CLIQUE_SIZE = 2;
    public static double DEFAULT_STRUCTURE_WEIGHT = 0.5;
    public static double DEFAULT_LABEL_WEIGHT = 0.5;
    public static boolean NODE_GROUPING = false;
    public static String DEFAULT_DENOMINATOR = "average";
    protected String similarityMeasure = DEFAULT_NODE_LABEL_SIMILARITY_MEASURE;
    protected int minCliqueSize = DEFAULT_MIN_CLIQUE_SIZE;
    protected double structureWeight = DEFAULT_STRUCTURE_WEIGHT;
    protected double labelWeight = DEFAULT_LABEL_WEIGHT;
    protected boolean groupNodes = NODE_GROUPING;
    protected IGraphAccessor graphAccessor1;
    protected IGraphAccessor graphAccessor2;
    protected double graphsSize = 0.0;
    protected int countCliq = 0;
    protected int countLoop = 0;
    protected int countMV = 0;
    protected int countLoopAdjacentMap = 0;
    protected TreeSet<IGraphNode> nodeSet1 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
    protected TreeSet<IGraphNode> nodeSet2 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
    protected ArrayList<MappedVertex> mappedVertexList = new ArrayList();
    protected ArrayList<MappedVertex> startCandidateList = new ArrayList();
    protected TreeMap<MappedVertex, TreeSet<MappedVertex>> adjacentMap = new TreeMap(new MappedVertexComparator());
    protected TreeMap<IGraphNode, Double> deleteSet = new TreeMap(new NamedGraphNodeComparator());
    protected TreeSet<String> cliqueList = new TreeSet();
    protected IGraphNode node1;
    protected IGraphNode node2;
    protected double maxSimilarity = 0.0;
    protected double tmpMaxSimilarity = 0.0;
    protected int maxVertex = 0;
    protected int tmpMaxVertex = 0;
    protected String maxVertexPathWithSimNumber;
    protected String maxSimilarityPathWithSimNumber;
    protected long startMillis;
    protected Timestamp ts;
    protected long millis;
    protected Calendar eDate;

    public SubgraphIsomorphism(IGraphAccessor graphAccessor1, IGraphAccessor graphAccessor2) {
        this(graphAccessor1, graphAccessor2, DEFAULT_MIN_CLIQUE_SIZE, DEFAULT_LABEL_WEIGHT, DEFAULT_STRUCTURE_WEIGHT, DEFAULT_DENOMINATOR, NODE_GROUPING);
    }

    public SubgraphIsomorphism(IGraphAccessor graphAccessor1, IGraphAccessor graphAccessor2, int minCliqueSize, double structureWeight, double labelWeight, String denominator, boolean groupNodes) {
        this.graphAccessor1 = graphAccessor1;
        this.graphAccessor2 = graphAccessor2;
        this.minCliqueSize = minCliqueSize;
        this.labelWeight = labelWeight;
        this.structureWeight = structureWeight;
        this.groupNodes = groupNodes;
        if (denominator.equals("first")) {
            this.graphsSize = graphAccessor1.getNodeSet().size();
        } else if (denominator.equals("small")) {
            this.graphsSize = graphAccessor1.getNodeSet().size() > graphAccessor2.getNodeSet().size() ? (double)graphAccessor2.getNodeSet().size() : (double)graphAccessor1.getNodeSet().size();
        } else if (denominator.equals("big")) {
            this.graphsSize = graphAccessor1.getNodeSet().size() > graphAccessor2.getNodeSet().size() ? (double)graphAccessor1.getNodeSet().size() : (double)graphAccessor2.getNodeSet().size();
        } else if (denominator.equals("average")) {
            this.graphsSize = (double)(graphAccessor1.getNodeSet().size() + graphAccessor2.getNodeSet().size()) / 2.0;
        } else {
            logger.debug((Object)"valid denominators are \"first\", \"small\", \"big\" and \"average\". default \"average\" is taken");
            this.graphsSize = (double)(graphAccessor1.getNodeSet().size() + graphAccessor2.getNodeSet().size()) / 2.0;
        }
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        TreeSet<MappedVertex> candidates = new TreeSet<MappedVertex>(new MappedVertexComparator());
        TreeSet<MappedVertex> clique = new TreeSet<MappedVertex>(new MappedVertexComparator());
        this.nodeSet1 = this.graphAccessor1.getNodeSet();
        this.nodeSet2 = this.graphAccessor2.getNodeSet();
        if (this.groupNodes) {
            this.setGroups(this.graphAccessor1, "G1");
            this.setGroups(this.graphAccessor2, "G2");
        }
        this.mappedVertexList = this.getVertexList();
        TreeSet<IGraphNode> impossibleLeft = new TreeSet<IGraphNode>();
        TreeSet<IGraphNode> impossibleRight = new TreeSet<IGraphNode>();
        this.adjacentMap = this.getAdjacentMap();
        if (logger.isDebugEnabled()) {
            for (IGraphNode n : this.graphAccessor1.getNodeSet()) {
                System.out.println("nodeG1: " + n);
                System.out.println("pre: " + n.getPredecessorSet());
                System.out.println("suc: " + n.getSuccessorSet());
            }
            for (IGraphNode n : this.graphAccessor2.getNodeSet()) {
                System.out.println("nodeG2: " + n);
                System.out.println("pre: " + n.getPredecessorSet());
                System.out.println("suc: " + n.getSuccessorSet());
            }
            Set<MappedVertex> set = this.adjacentMap.keySet();
            for (MappedVertex mv : set) {
                System.out.println(mv);
                if (mv.isGroup()) {
                    System.out.println("grpsiz " + mv.getGroupSize() + "  grpsim " + mv.getGroupSimilarity() + "  Map: " + this.adjacentMap.get(mv));
                } else {
                    System.out.println("labelsim " + mv.getLabelSimilarity() + "  Map: " + this.adjacentMap.get(mv));
                }
                for (MappedVertex n : this.adjacentMap.get(mv)) {
                    System.out.println(n + " sim " + n.getLabelSimilarity());
                }
            }
        }
        for (MappedVertex m : this.startCandidateList) {
            ++this.countMV;
            if (Math.IEEEremainder(this.countMV, 100.0) == 0.0) {
                this.eDate = Calendar.getInstance();
                this.millis = this.eDate.getTime().getTime();
                this.ts = new Timestamp(this.millis);
                logger.debug((Object)(this.countMV + ") " + m + " " + this.ts + " = " + (this.millis - this.startMillis) / 1000L + " sec"));
            }
            candidates.add(m);
            this.nextMaximalClique(candidates, impossibleLeft, impossibleRight, clique, this.minCliqueSize);
        }
        logger.debug((Object)("maxSimilarity: " + this.maxSimilarityPathWithSimNumber));
        logger.debug((Object)("maxVertex: " + this.maxVertexPathWithSimNumber));
        this.similarity = this.maxSimilarity;
        this.setCalculated(true);
        return true;
    }

    public void setGroups(IGraphAccessor graphAccessor, String graph) {
        Integer groupCount = 0;
        TreeSet<IGraphNode> groupSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        for (IGraphNode node : graphAccessor.getNodeSet()) {
            logger.debug((Object)("node: " + node));
            boolean group = true;
            if (node.getHasGroup() || node.getSuccessorSet() == null || node.getSuccessorSet().size() <= 1) continue;
            TreeSet<IGraphNode> successorSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            TreeSet<IGraphNode> predecessorSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            TreeSet<IGraphNode> memberSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            successorSet = node.getSuccessorSet();
            IGraphNode firstNode = successorSet.first();
            predecessorSet = firstNode.getPredecessorSet();
            logger.debug((Object)("predecessorSet of 1st successor: " + predecessorSet));
            for (IGraphNode iGraphNode : successorSet) {
                if ((iGraphNode.getSuccessorSet() == null || iGraphNode.getSuccessorSet().size() == 0) && iGraphNode.getPredecessorSet().size() == predecessorSet.size()) {
                    for (IGraphNode predecessor2 : predecessorSet) {
                        if (iGraphNode.getPredecessorSet().contains(predecessor2)) continue;
                        group = false;
                    }
                    continue;
                }
                group = false;
            }
            for (IGraphNode iGraphNode : predecessorSet) {
                if (iGraphNode.getSuccessorSet().size() == successorSet.size()) continue;
                group = false;
            }
            logger.debug((Object)("is groupable: " + group));
            if (!group) continue;
            node.setHasGroup();
            Integer i$ = groupCount;
            Integer n = groupCount = Integer.valueOf(groupCount + 1);
            GroupNode g = new GroupNode(graph.concat("_GROUP_").concat(groupCount.toString()));
            groupSet.add(g);
            logger.debug((Object)("groupNode: " + g.toString()));
            g.setGroupSize(successorSet.size());
            for (IGraphNode member : successorSet) {
                if (member.getIsGroup()) continue;
                memberSet.add(member);
            }
            g.setGroupNodes(memberSet);
            logger.debug((Object)("memberSet: " + memberSet));
            for (IGraphNode predecessor4 : predecessorSet) {
                g.addPredecessor(predecessor4);
                predecessor4.setHasGroup();
                predecessor4.addSuccessor(g);
            }
        }
        for (IGraphNode node : groupSet) {
            graphAccessor.addNode(node);
        }
    }

    public ArrayList<MappedVertex> getVertexList() {
        TreeSet<IGraphNode> nodeSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        logger.debug((Object)("set1 size: " + this.nodeSet1.size() + " set2 size: " + this.nodeSet2.size()));
        for (IGraphNode n : this.nodeSet1) {
            if (n.getSuccessorSet().size() != 0) continue;
            nodeSet.add(n);
        }
        logger.debug(nodeSet);
        this.markNodes(nodeSet, 0.0);
        if (logger.isDebugEnabled()) {
            Set<IGraphNode> set = this.deleteSet.keySet();
            for (IGraphNode n : set) {
                if (this.deleteSet.get(n) != 0.0) continue;
                System.out.println("delete: " + n);
            }
        }
        for (IGraphNode n1 : this.nodeSet1) {
            for (IGraphNode n2 : this.nodeSet2) {
                if (n1.getIsGroup() != n2.getIsGroup()) continue;
                MappedVertex mv = new MappedVertex(n1, n2);
                logger.debug((Object)("mv: " + mv + " groups: " + n1.getIsGroup()));
                this.mappedVertexList.add(mv);
                logger.debug((Object)(n1.getSuccessorSet().size() + " " + this.deleteSet.get(n1) + " " + n2.getSuccessorSet().size()));
                if (n1.getSuccessorSet().size() > 0 && this.deleteSet.get(n1) == 1.0 && n2.getSuccessorSet().size() > 0) {
                    this.startCandidateList.add(mv);
                }
                if (n1.getIsGroup()) {
                    if (n1.getGroupSize() > n2.getGroupSize()) {
                        this.groupSimilarity(mv, n2.getGroupNodes(), n1.getGroupNodes(), "reverse");
                        continue;
                    }
                    this.groupSimilarity(mv, n1.getGroupNodes(), n2.getGroupNodes(), "normal");
                    continue;
                }
                if (this.similarityMeasure.equals("Levenshtein")) {
                    Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor(((Object)n1).toString()), new StringAccessor(((Object)n2).toString()));
                    mv.setLabelSimilarity(levenshtein.getSimilarity());
                    continue;
                }
                logger.error((Object)"Not yet implemented!");
            }
        }
        if (logger.isDebugEnabled()) {
            for (MappedVertex mv : this.mappedVertexList) {
                System.out.println("mappedVertex: " + mv);
            }
        }
        return this.mappedVertexList;
    }

    public void markNodes(TreeSet<IGraphNode> nodeSet, Double mark) {
        TreeSet<IGraphNode> newNodeSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        TreeSet<IGraphNode> passedSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        if (mark == 0.0) {
            for (IGraphNode node : nodeSet) {
                if (this.deleteSet.containsKey(node)) {
                    passedSet.add(node);
                    continue;
                }
                this.deleteSet.put(node, 0.0);
            }
        } else {
            for (IGraphNode node : nodeSet) {
                if (this.deleteSet.containsKey(node)) {
                    passedSet.add(node);
                }
                this.deleteSet.put(node, 1.0);
            }
        }
        for (IGraphNode node : nodeSet) {
            if (passedSet.contains(node)) continue;
            for (IGraphNode predecessor : node.getPredecessorSet()) {
                newNodeSet.add(predecessor);
            }
        }
        mark = Math.IEEEremainder(mark + 1.0, 2.0);
        logger.debug((Object)(mark + " " + newNodeSet));
        if (newNodeSet.size() > 0) {
            this.markNodes(newNodeSet, mark);
        }
    }

    public TreeMap<MappedVertex, TreeSet<MappedVertex>> getAdjacentMap() {
        TreeSet<IGraphNode> sourceSet1 = new TreeSet();
        TreeSet<IGraphNode> sourceSet2 = new TreeSet();
        TreeSet<IGraphNode> targetSet1 = new TreeSet();
        TreeSet<IGraphNode> targetSet2 = new TreeSet();
        for (MappedVertex mv : this.mappedVertexList) {
            logger.debug((Object)("mappedVertex: " + mv));
            ++this.countLoopAdjacentMap;
            if (Math.IEEEremainder(this.countLoopAdjacentMap, 1000.0) == 0.0) {
                System.out.println("loop adjacency: " + this.countLoopAdjacentMap + " mv: " + mv);
            }
            TreeSet<MappedVertex> commonAdjacentSet = new TreeSet<MappedVertex>(new MappedVertexComparator());
            IGraphNode node1 = mv.getLeftNode();
            IGraphNode node2 = mv.getRightNode();
            sourceSet1 = node1.getPredecessorSet();
            sourceSet2 = node2.getPredecessorSet();
            targetSet1 = node1.getSuccessorSet();
            targetSet2 = node2.getSuccessorSet();
            if (logger.isDebugEnabled()) {
                System.out.println("nodes: " + node1 + ", " + node2);
                System.out.println("sourceSet1: " + sourceSet1);
                System.out.println("sourceSet2: " + sourceSet2);
                System.out.println("targetSet1: " + targetSet1);
                System.out.println("targetSet2: " + targetSet2);
            }
            if (sourceSet1 != null && sourceSet2 != null) {
                commonAdjacentSet = this.adjacentNodes(commonAdjacentSet, sourceSet1, sourceSet2);
            }
            if (targetSet1 != null && targetSet2 != null) {
                if (node1.getHasGroup() && node2.getHasGroup()) {
                    logger.debug((Object)"have group!");
                    commonAdjacentSet = this.adjacentGroups(commonAdjacentSet, targetSet1, targetSet2);
                } else {
                    commonAdjacentSet = this.adjacentNodes(commonAdjacentSet, targetSet1, targetSet2);
                }
            }
            logger.debug((Object)("commonAdjacentSet: " + commonAdjacentSet));
            this.adjacentMap.put(mv, commonAdjacentSet);
            if (!logger.isDebugEnabled()) continue;
            for (MappedVertex m : commonAdjacentSet) {
                System.out.println("MV: " + mv + " " + mv.isGroup() + " m: " + m + " " + m.isGroup());
            }
        }
        return this.adjacentMap;
    }

    public TreeSet<MappedVertex> adjacentNodes(TreeSet<MappedVertex> commonAdjacentSet, TreeSet<IGraphNode> adjacentSet1, TreeSet<IGraphNode> adjacentSet2) {
        for (IGraphNode node1 : adjacentSet1) {
            for (IGraphNode node2 : adjacentSet2) {
                if (node1.getIsGroup() || node2.getIsGroup()) continue;
                MappedVertex mv = new MappedVertex(node1, node2);
                for (MappedVertex m : this.mappedVertexList) {
                    if (!mv.equals(m)) continue;
                    commonAdjacentSet.add(m);
                }
                if (!logger.isDebugEnabled()) continue;
                System.out.println("mappedVertex: " + mv);
                System.out.println("equal similarity: " + ((Object)node1).toString().equals(((Object)node2).toString()));
            }
        }
        return commonAdjacentSet;
    }

    public TreeSet<MappedVertex> adjacentGroups(TreeSet<MappedVertex> commonAdjacentSet, TreeSet<IGraphNode> adjacentSet1, TreeSet<IGraphNode> adjacentSet2) {
        for (IGraphNode node1 : adjacentSet1) {
            for (IGraphNode node2 : adjacentSet2) {
                if (!node1.getIsGroup() || !node2.getIsGroup()) continue;
                MappedVertex mv = new MappedVertex(node1, node2);
                for (MappedVertex m : this.mappedVertexList) {
                    if (!mv.equals(m)) continue;
                    commonAdjacentSet.add(m);
                }
                if (!logger.isDebugEnabled()) continue;
                System.out.println("mappedVertex: " + mv + " " + mv.isGroup());
                System.out.println("group1: " + node1.getGroupNodes());
                System.out.println("group2: " + node2.getGroupNodes());
                System.out.println("size: " + mv.getGroupSize());
            }
        }
        return commonAdjacentSet;
    }

    public void groupSimilarity(MappedVertex mv, TreeSet<IGraphNode> groupSmall, TreeSet<IGraphNode> groupLarge, String order) {
        ArrayList currentNodes;
        ArrayList currentSim;
        HashMap<IGraphNode, ArrayList> nodeMapping = new HashMap<IGraphNode, ArrayList>();
        HashMap<IGraphNode, ArrayList> simMapping = new HashMap<IGraphNode, ArrayList>();
        ArrayList<MappedVertex> groupMembers = new ArrayList<MappedVertex>();
        Double groupSim = 0.0;
        int ind = 0;
        for (IGraphNode n1 : groupSmall) {
            currentSim = new ArrayList();
            currentNodes = new ArrayList();
            for (IGraphNode n2 : groupLarge) {
                if (this.similarityMeasure.equals("Levenshtein")) {
                    Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor(((Object)n1).toString()), new StringAccessor(((Object)n2).toString()));
                    currentSim.add(levenshtein.getSimilarity());
                    currentNodes.add(n2);
                    continue;
                }
                logger.error((Object)"Not yet implemented!");
            }
            nodeMapping.put(n1, currentNodes);
            simMapping.put(n1, currentSim);
        }
        for (IGraphNode n1 : groupSmall) {
            currentSim = new ArrayList();
            currentNodes = new ArrayList();
            currentSim = (ArrayList)simMapping.get(n1);
            currentNodes = (ArrayList)nodeMapping.get(n1);
            Double tmpMax = 0.0;
            for (Double d : currentSim) {
                tmpMax = Math.max(tmpMax, d);
            }
            ind = currentSim.indexOf(tmpMax);
            groupSim = groupSim + tmpMax;
            IGraphNode n2 = (IGraphNode)currentNodes.get(ind);
            MappedVertex groupMem = order.equals("normal") ? new MappedVertex(n1, n2) : new MappedVertex(n2, n1);
            groupMembers.add(groupMem);
            for (IGraphNode n : groupSmall) {
                ((ArrayList)simMapping.get(n)).remove(ind);
                ((ArrayList)nodeMapping.get(n)).remove(ind);
            }
        }
        for (MappedVertex m : groupMembers) {
            mv.addGroupMember(m);
        }
        mv.setGroupSimilarity(groupSim);
        mv.setGroupSize(Math.min(groupSmall.size(), groupLarge.size()));
        if (logger.isDebugEnabled()) {
            System.out.println("MappedVertex: " + mv);
            System.out.println("groupMembers: " + groupMembers);
            System.out.println("groupSimilarity: " + groupSim);
        }
    }

    public void nextMaximalClique(TreeSet<MappedVertex> candidates, TreeSet<IGraphNode> impossibleLeft, TreeSet<IGraphNode> impossibleRight, TreeSet<MappedVertex> clique, int shortest) {
        ++this.countLoop;
        if (Math.IEEEremainder(this.countLoop, 2000000.0) == 0.0) {
            logger.debug((Object)("countLoop: " + this.countLoop));
        }
        int cliqueSize = 0;
        TreeSet<MappedVertex> clique2 = new TreeSet<MappedVertex>(new MappedVertexComparator());
        for (MappedVertex copy : clique) {
            clique2.add(copy);
        }
        if (candidates.isEmpty()) {
            for (MappedVertex mv : clique2) {
                if (mv.isGroup()) {
                    cliqueSize += mv.getGroupSize();
                    continue;
                }
                ++cliqueSize;
            }
            if (cliqueSize >= shortest) {
                ++this.countCliq;
                if (Math.IEEEremainder(this.countCliq, 200000.0) == 0.0) {
                    logger.debug((Object)("Cliq: " + this.countCliq + " " + clique2));
                }
                this.checkIfMaxClique(clique2);
            }
        } else {
            while (!candidates.isEmpty()) {
                MappedVertex v = candidates.first();
                candidates.remove(v);
                this.node1 = v.getLeftNode();
                this.node2 = v.getRightNode();
                TreeSet<MappedVertex> tempCandidates = new TreeSet<MappedVertex>(new MappedVertexComparator());
                TreeSet<IGraphNode> tempImpossibleLeft = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
                TreeSet<IGraphNode> tempImpossibleRight = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
                if (logger.isDebugEnabled()) {
                    System.out.println("mappedVertex: " + v);
                    System.out.println("impossible before l: " + impossibleLeft);
                    System.out.println("impossible before r: " + impossibleRight);
                    System.out.println("adjacent for mappedVertex: " + this.adjacentMap.get(v));
                }
                for (MappedVertex w : this.adjacentMap.get(v)) {
                    if (!(impossibleLeft.contains(w.getLeftNode()) || impossibleRight.contains(w.getRightNode()) || clique.contains(w))) {
                        tempCandidates.add(w);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    System.out.println("new candidate not added: " + w);
                    System.out.println(!impossibleLeft.contains(this.node1) + " " + !impossibleRight.contains(this.node2) + " " + !clique.contains(w));
                }
                logger.debug((Object)("only new candidates: " + tempCandidates));
                for (MappedVertex w : candidates) {
                    if (logger.isDebugEnabled()) {
                        System.out.println("old candidate: " + w);
                        System.out.println(this.adjacentMap.get(v).contains(w) + " " + !w.getLeftNode().equals(this.node1) + " " + !w.getRightNode().equals(this.node2) + " " + !this.node1.getAdjacentSet().contains(w.getLeftNode()) + " " + !this.node2.getAdjacentSet().contains(w.getRightNode()));
                    }
                    if (!this.adjacentMap.get(v).contains(w) && (w.getLeftNode().equals(this.node1) || w.getRightNode().equals(this.node2) || this.node1.getAdjacentSet().contains(w.getLeftNode()) || this.node2.getAdjacentSet().contains(w.getRightNode()))) continue;
                    tempCandidates.add(w);
                }
                for (IGraphNode node : impossibleLeft) {
                    tempImpossibleLeft.add(node);
                }
                for (IGraphNode node : impossibleRight) {
                    tempImpossibleRight.add(node);
                }
                for (IGraphNode node : this.node1.getAdjacentSet()) {
                    tempImpossibleLeft.add(node);
                }
                for (IGraphNode node : this.node2.getAdjacentSet()) {
                    tempImpossibleRight.add(node);
                }
                tempImpossibleLeft.add(this.node1);
                tempImpossibleRight.add(this.node2);
                clique.add(v);
                if (logger.isDebugEnabled()) {
                    System.out.println("clique: " + clique);
                    System.out.println("all candidates: " + tempCandidates);
                    System.out.println("impossible after l: " + tempImpossibleLeft);
                    System.out.println("impossible after r: " + tempImpossibleRight);
                }
                this.nextMaximalClique(tempCandidates, tempImpossibleLeft, tempImpossibleRight, clique, shortest);
                clique.remove(v);
            }
        }
    }

    public void checkIfMaxClique(TreeSet<MappedVertex> clique) {
        int groupVertexSize = 0;
        double labelSimilarity = 0.0;
        double structureSimilarity = 0.0;
        double overallSimilarity = 0.0;
        String pathWithSimNumber = "";
        for (MappedVertex m : clique) {
            if (m.isGroup()) {
                labelSimilarity += m.getGroupSimilarity();
                groupVertexSize = groupVertexSize + m.getGroupSize() - 1;
                for (MappedVertex mv : m.getGroupMembers()) {
                    if (pathWithSimNumber.equals("")) {
                        pathWithSimNumber = pathWithSimNumber + mv.toString();
                        continue;
                    }
                    pathWithSimNumber = pathWithSimNumber + ", " + mv.toString();
                }
                continue;
            }
            labelSimilarity += m.getLabelSimilarity();
            if (pathWithSimNumber.equals("")) {
                pathWithSimNumber = pathWithSimNumber + m.toString();
                continue;
            }
            pathWithSimNumber = pathWithSimNumber + ", " + m.toString();
        }
        structureSimilarity = (double)(clique.size() + groupVertexSize) / this.graphsSize;
        overallSimilarity = this.labelWeight * (labelSimilarity /= this.graphsSize) + this.structureWeight * structureSimilarity;
        if (logger.isDebugEnabled()) {
            System.out.println("clique: " + pathWithSimNumber);
            System.out.println("labelSimilarity: " + labelSimilarity);
            System.out.println("structureSimilarity: " + structureSimilarity);
            System.out.println("overallSimilarity: " + overallSimilarity);
        }
        String path = pathWithSimNumber;
        if (overallSimilarity == 1.0) {
            pathWithSimNumber = pathWithSimNumber + "; 1";
        } else {
            int tempInt = (int)(overallSimilarity * 100.0);
            Integer conversion = new Integer(tempInt);
            pathWithSimNumber = pathWithSimNumber + "; 0." + conversion.toString();
        }
        this.checkMax(clique.size() + groupVertexSize, overallSimilarity, path, pathWithSimNumber);
    }

    public void checkMax(int numVertex, double similarity, String clique, String cliqueSim) {
        if (similarity >= this.maxSimilarity) {
            if (similarity > this.maxSimilarity) {
                this.cliqueList.clear();
            }
            this.cliqueList.add(clique);
        }
        if (numVertex > this.maxVertex || numVertex == this.maxVertex && similarity > this.tmpMaxSimilarity) {
            this.maxVertexPathWithSimNumber = cliqueSim;
            logger.debug((Object)("maxVertexPathWithSimNumber: " + this.maxVertexPathWithSimNumber));
            this.maxVertex = numVertex;
            this.tmpMaxSimilarity = Math.max(this.tmpMaxSimilarity, similarity);
        }
        if (similarity > this.maxSimilarity || similarity == this.maxSimilarity && numVertex > this.tmpMaxVertex) {
            this.maxSimilarityPathWithSimNumber = cliqueSim;
            logger.debug((Object)("maxSimilarityPathWithSimNumber: " + this.maxSimilarityPathWithSimNumber));
            this.maxSimilarity = similarity;
            this.tmpMaxVertex = Math.max(this.tmpMaxVertex, numVertex);
        }
    }

    public TreeSet<String> getCliqueList() {
        return this.cliqueList;
    }

    public double getGraphsSize() {
        return this.graphsSize;
    }
}

